/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.metadata.FunctionHandle;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.EquiJoinClause;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.FieldOrExpression;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.sql.analyzer.TupleDescriptor;
import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.planner.PlanBuilder;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.QueryPlanner;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.TranslationMap;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.Union;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class RelationPlanner
extends DefaultTraversalVisitor<RelationPlan, Void> {
    private final Analysis analysis;
    private final SymbolAllocator symbolAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final Metadata metadata;
    private final Session session;

    RelationPlanner(Analysis analysis, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Metadata metadata, Session session) {
        Preconditions.checkNotNull((Object)analysis, (Object)"analysis is null");
        Preconditions.checkNotNull((Object)symbolAllocator, (Object)"symbolAllocator is null");
        Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        this.analysis = analysis;
        this.symbolAllocator = symbolAllocator;
        this.idAllocator = idAllocator;
        this.metadata = metadata;
        this.session = session;
    }

    protected RelationPlan visitTable(Table node, Void context) {
        Query namedQuery;
        if (!node.getName().getPrefix().isPresent() && (namedQuery = this.analysis.getNamedQuery(node)) != null) {
            RelationPlan subPlan = (RelationPlan)this.process((Node)namedQuery, null);
            return new RelationPlan(subPlan.getRoot(), this.analysis.getOutputDescriptor((Node)node), subPlan.getOutputSymbols());
        }
        TupleDescriptor descriptor = this.analysis.getOutputDescriptor((Node)node);
        TableHandle handle = this.analysis.getTableHandle(node);
        ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder();
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (int i = 0; i < descriptor.getFields().size(); ++i) {
            Field field = descriptor.getFields().get(i);
            Symbol symbol = this.symbolAllocator.newSymbol((String)field.getName().get(), field.getType());
            outputSymbolsBuilder.add((Object)symbol);
            columns.put((Object)symbol, (Object)this.analysis.getColumn(field));
        }
        ImmutableList outputSymbols = outputSymbolsBuilder.build();
        return new RelationPlan(new TableScanNode(this.idAllocator.getNextId(), handle, (List<Symbol>)outputSymbols, (Map<Symbol, ColumnHandle>)columns.build(), (Expression)BooleanLiteral.TRUE_LITERAL, (Expression)BooleanLiteral.TRUE_LITERAL), descriptor, (List<Symbol>)outputSymbols);
    }

    protected RelationPlan visitAliasedRelation(AliasedRelation node, Void context) {
        RelationPlan subPlan = (RelationPlan)this.process((Node)node.getRelation(), context);
        TupleDescriptor outputDescriptor = this.analysis.getOutputDescriptor((Node)node);
        return new RelationPlan(subPlan.getRoot(), outputDescriptor, subPlan.getOutputSymbols());
    }

    protected RelationPlan visitSampledRelation(SampledRelation node, Void context) {
        RelationPlan subPlan = (RelationPlan)this.process((Node)node.getRelation(), context);
        TupleDescriptor outputDescriptor = this.analysis.getOutputDescriptor((Node)node);
        double ratio = this.analysis.getSampleRatio(node);
        return new RelationPlan(new SampleNode(this.idAllocator.getNextId(), subPlan.getRoot(), ratio, SampleNode.Type.fromType(node.getType())), outputDescriptor, subPlan.getOutputSymbols());
    }

    protected RelationPlan visitJoin(Join node, Void context) {
        RelationPlan leftPlan = (RelationPlan)this.process((Node)node.getLeft(), context);
        RelationPlan rightPlan = (RelationPlan)this.process((Node)node.getRight(), context);
        PlanBuilder leftPlanBuilder = this.initializePlanBuilder(leftPlan);
        PlanBuilder rightPlanBuilder = this.initializePlanBuilder(rightPlan);
        List<EquiJoinClause> criteria = this.analysis.getJoinCriteria(node);
        Analysis.JoinInPredicates joinInPredicates = this.analysis.getJoinInPredicates(node);
        if (joinInPredicates != null) {
            leftPlanBuilder = this.appendSemiJoins(leftPlanBuilder, joinInPredicates.getLeftInPredicates());
            rightPlanBuilder = this.appendSemiJoins(rightPlanBuilder, joinInPredicates.getRightInPredicates());
        }
        leftPlanBuilder = this.appendProjections(leftPlanBuilder, Iterables.transform(criteria, EquiJoinClause.leftGetter()));
        rightPlanBuilder = this.appendProjections(rightPlanBuilder, Iterables.transform(criteria, EquiJoinClause.rightGetter()));
        ImmutableList.Builder clauses = ImmutableList.builder();
        for (EquiJoinClause clause : criteria) {
            Symbol leftSymbol = leftPlanBuilder.translate(clause.getLeft());
            Symbol rightSymbol = rightPlanBuilder.translate(clause.getRight());
            clauses.add((Object)new JoinNode.EquiJoinClause(leftSymbol, rightSymbol));
        }
        ImmutableList outputSymbols = ImmutableList.builder().addAll(leftPlan.getOutputSymbols()).addAll(rightPlan.getOutputSymbols()).build();
        return new RelationPlan(new JoinNode(this.idAllocator.getNextId(), JoinNode.Type.typeConvert(node.getType()), leftPlanBuilder.getRoot(), rightPlanBuilder.getRoot(), (List<JoinNode.EquiJoinClause>)clauses.build()), this.analysis.getOutputDescriptor((Node)node), (List<Symbol>)outputSymbols);
    }

    protected RelationPlan visitTableSubquery(TableSubquery node, Void context) {
        return (RelationPlan)this.process((Node)node.getQuery(), context);
    }

    protected RelationPlan visitQuery(Query node, Void context) {
        PlanBuilder subPlan = (PlanBuilder)new QueryPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session).process((Node)node, null);
        ImmutableList.Builder outputSymbols = ImmutableList.builder();
        for (FieldOrExpression fieldOrExpression : this.analysis.getOutputExpressions((Node)node)) {
            outputSymbols.add((Object)subPlan.translate(fieldOrExpression));
        }
        return new RelationPlan(subPlan.getRoot(), this.analysis.getOutputDescriptor((Node)node), (List<Symbol>)outputSymbols.build());
    }

    protected RelationPlan visitQuerySpecification(QuerySpecification node, Void context) {
        PlanBuilder subPlan = (PlanBuilder)new QueryPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session).process((Node)node, null);
        ImmutableList.Builder outputSymbols = ImmutableList.builder();
        for (FieldOrExpression fieldOrExpression : this.analysis.getOutputExpressions((Node)node)) {
            outputSymbols.add((Object)subPlan.translate(fieldOrExpression));
        }
        return new RelationPlan(subPlan.getRoot(), this.analysis.getOutputDescriptor((Node)node), (List<Symbol>)outputSymbols.build());
    }

    protected RelationPlan visitUnion(Union node, Void context) {
        Preconditions.checkArgument((!node.getRelations().isEmpty() ? 1 : 0) != 0, (Object)"No relations specified for UNION");
        List outputSymbols = null;
        ImmutableList.Builder sources = ImmutableList.builder();
        ImmutableListMultimap.Builder symbolMapping = ImmutableListMultimap.builder();
        for (Relation relation : node.getRelations()) {
            RelationPlan relationPlan = (RelationPlan)this.process((Node)relation, context);
            if (outputSymbols == null) {
                ImmutableList.Builder outputSymbolBuilder = ImmutableList.builder();
                for (Symbol symbol : relationPlan.getOutputSymbols()) {
                    outputSymbolBuilder.add((Object)this.symbolAllocator.newSymbol(symbol.getName(), this.symbolAllocator.getTypes().get(symbol)));
                }
                outputSymbols = outputSymbolBuilder.build();
            }
            for (int i = 0; i < outputSymbols.size(); ++i) {
                symbolMapping.put(outputSymbols.get(i), (Object)relationPlan.getOutputSymbols().get(i));
            }
            sources.add((Object)relationPlan.getRoot());
        }
        PlanNode planNode = new UnionNode(this.idAllocator.getNextId(), (List<PlanNode>)sources.build(), (ListMultimap<Symbol, Symbol>)symbolMapping.build());
        if (node.isDistinct()) {
            planNode = this.distinct(planNode);
        }
        return new RelationPlan(planNode, this.analysis.getOutputDescriptor((Node)node), planNode.getOutputSymbols());
    }

    private PlanBuilder initializePlanBuilder(RelationPlan relationPlan) {
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis);
        translations.setFieldMappings(relationPlan.getOutputSymbols());
        return new PlanBuilder(translations, relationPlan.getRoot());
    }

    private PlanBuilder appendProjections(PlanBuilder subPlan, Iterable<Expression> expressions) {
        TranslationMap translations = new TranslationMap(subPlan.getRelationPlan(), this.analysis);
        translations.copyMappingsFrom(subPlan.getTranslations());
        ImmutableMap.Builder projections = ImmutableMap.builder();
        for (Symbol symbol : subPlan.getRoot().getOutputSymbols()) {
            QualifiedNameReference qualifiedNameReference = new QualifiedNameReference(symbol.toQualifiedName());
            projections.put((Object)symbol, (Object)qualifiedNameReference);
        }
        ImmutableMap.Builder newTranslations = ImmutableMap.builder();
        for (Expression expression : expressions) {
            Symbol symbol = this.symbolAllocator.newSymbol(expression, this.analysis.getType(expression));
            projections.put((Object)symbol, (Object)translations.rewrite(expression));
            newTranslations.put((Object)symbol, (Object)expression);
        }
        for (Map.Entry entry : newTranslations.build().entrySet()) {
            translations.put((Expression)entry.getValue(), (Symbol)entry.getKey());
        }
        return new PlanBuilder(translations, new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Map<Symbol, Expression>)projections.build()));
    }

    private PlanBuilder appendSemiJoins(PlanBuilder subPlan, Set<InPredicate> inPredicates) {
        for (InPredicate inPredicate : inPredicates) {
            subPlan = this.appendSemiJoin(subPlan, inPredicate);
        }
        return subPlan;
    }

    private PlanBuilder appendSemiJoin(PlanBuilder subPlan, InPredicate inPredicate) {
        TranslationMap translations = new TranslationMap(subPlan.getRelationPlan(), this.analysis);
        translations.copyMappingsFrom(subPlan.getTranslations());
        subPlan = this.appendProjections(subPlan, (Iterable<Expression>)ImmutableList.of((Object)inPredicate.getValue()));
        Symbol sourceJoinSymbol = subPlan.translate(inPredicate.getValue());
        Preconditions.checkState((boolean)(inPredicate.getValueList() instanceof SubqueryExpression));
        SubqueryExpression subqueryExpression = (SubqueryExpression)inPredicate.getValueList();
        RelationPlanner relationPlanner = new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session);
        RelationPlan valueListRelation = (RelationPlan)relationPlanner.process((Node)subqueryExpression.getQuery(), null);
        Symbol filteringSourceJoinSymbol = (Symbol)Iterables.getOnlyElement(valueListRelation.getRoot().getOutputSymbols());
        Symbol semiJoinOutputSymbol = this.symbolAllocator.newSymbol("semijoinresult", Type.BOOLEAN);
        translations.put((Expression)inPredicate, semiJoinOutputSymbol);
        return new PlanBuilder(translations, new SemiJoinNode(this.idAllocator.getNextId(), subPlan.getRoot(), valueListRelation.getRoot(), sourceJoinSymbol, filteringSourceJoinSymbol, semiJoinOutputSymbol));
    }

    private PlanNode distinct(PlanNode node) {
        return new AggregationNode(this.idAllocator.getNextId(), node, node.getOutputSymbols(), (Map<Symbol, FunctionCall>)ImmutableMap.of(), (Map<Symbol, FunctionHandle>)ImmutableMap.of());
    }
}

