/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.planner.DependencyExtractor;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SinkNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PlanSanityChecker {
    public static void validate(PlanNode plan) {
        plan.accept(new Visitor(), null);
    }

    private static class Visitor
    extends PlanVisitor<Void, Void> {
        private final Map<PlanNodeId, PlanNode> nodesById = new HashMap<PlanNodeId, PlanNode>();

        private Visitor() {
        }

        @Override
        protected Void visitPlan(PlanNode node, Void context) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        @Override
        public Void visitAggregation(AggregationNode node, Void context) {
            PlanNode source = node.getSource();
            source.accept(this, context);
            this.verifyUniqueId(node);
            Preconditions.checkArgument((boolean)source.getOutputSymbols().containsAll(node.getGroupBy()), (String)"Invalid node. Group by symbols (%s) not in source plan output (%s)", (Object[])new Object[]{node.getGroupBy(), node.getSource().getOutputSymbols()});
            for (FunctionCall call : node.getAggregations().values()) {
                Set<Symbol> dependencies = DependencyExtractor.extractUnique((Expression)call);
                Preconditions.checkArgument((boolean)source.getOutputSymbols().containsAll(dependencies), (String)"Invalid node. Aggregation dependencies (%s) not in source plan output (%s)", (Object[])new Object[]{dependencies, node.getSource().getOutputSymbols()});
            }
            return null;
        }

        @Override
        public Void visitWindow(WindowNode node, Void context) {
            PlanNode source = node.getSource();
            source.accept(this, context);
            this.verifyUniqueId(node);
            Preconditions.checkArgument((boolean)source.getOutputSymbols().containsAll(node.getPartitionBy()), (String)"Invalid node. Partition by symbols (%s) not in source plan output (%s)", (Object[])new Object[]{node.getPartitionBy(), node.getSource().getOutputSymbols()});
            Preconditions.checkArgument((boolean)source.getOutputSymbols().containsAll(node.getOrderBy()), (String)"Invalid node. Order by symbols (%s) not in source plan output (%s)", (Object[])new Object[]{node.getOrderBy(), node.getSource().getOutputSymbols()});
            for (FunctionCall call : node.getWindowFunctions().values()) {
                Set<Symbol> dependencies = DependencyExtractor.extractUnique((Expression)call);
                Preconditions.checkArgument((boolean)source.getOutputSymbols().containsAll(dependencies), (String)"Invalid node. Window function dependencies (%s) not in source plan output (%s)", (Object[])new Object[]{dependencies, node.getSource().getOutputSymbols()});
            }
            return null;
        }

        @Override
        public Void visitFilter(FilterNode node, Void context) {
            PlanNode source = node.getSource();
            source.accept(this, context);
            this.verifyUniqueId(node);
            Preconditions.checkArgument((boolean)source.getOutputSymbols().containsAll(node.getOutputSymbols()), (String)"Invalid node. Output symbols (%s) not in source plan output (%s)", (Object[])new Object[]{node.getOutputSymbols(), node.getSource().getOutputSymbols()});
            Set<Symbol> dependencies = DependencyExtractor.extractUnique(node.getPredicate());
            Preconditions.checkArgument((boolean)source.getOutputSymbols().containsAll(dependencies), (String)"Invalid node. Predicate dependencies (%s) not in source plan output (%s)", (Object[])new Object[]{dependencies, node.getSource().getOutputSymbols()});
            return null;
        }

        @Override
        public Void visitSample(SampleNode node, Void context) {
            PlanNode source = node.getSource();
            source.accept(this, context);
            this.verifyUniqueId(node);
            return null;
        }

        @Override
        public Void visitProject(ProjectNode node, Void context) {
            PlanNode source = node.getSource();
            source.accept(this, context);
            this.verifyUniqueId(node);
            for (Expression expression : node.getExpressions()) {
                Set<Symbol> dependencies = DependencyExtractor.extractUnique(expression);
                Preconditions.checkArgument((boolean)source.getOutputSymbols().containsAll(dependencies), (String)"Invalid node. Expression dependencies (%s) not in source plan output (%s)", (Object[])new Object[]{dependencies, node.getSource().getOutputSymbols()});
            }
            return null;
        }

        @Override
        public Void visitTopN(TopNNode node, Void context) {
            PlanNode source = node.getSource();
            source.accept(this, context);
            this.verifyUniqueId(node);
            Preconditions.checkArgument((boolean)source.getOutputSymbols().containsAll(node.getOutputSymbols()), (String)"Invalid node. Output symbols (%s) not in source plan output (%s)", (Object[])new Object[]{node.getOutputSymbols(), node.getSource().getOutputSymbols()});
            Preconditions.checkArgument((boolean)source.getOutputSymbols().containsAll(node.getOrderBy()), (String)"Invalid node. Order by dependencies (%s) not in source plan output (%s)", (Object[])new Object[]{node.getOrderBy(), node.getSource().getOutputSymbols()});
            return null;
        }

        @Override
        public Void visitSort(SortNode node, Void context) {
            PlanNode source = node.getSource();
            source.accept(this, context);
            this.verifyUniqueId(node);
            Preconditions.checkArgument((boolean)source.getOutputSymbols().containsAll(node.getOutputSymbols()), (String)"Invalid node. Output symbols (%s) not in source plan output (%s)", (Object[])new Object[]{node.getOutputSymbols(), node.getSource().getOutputSymbols()});
            Preconditions.checkArgument((boolean)source.getOutputSymbols().containsAll(node.getOrderBy()), (String)"Invalid node. Order by dependencies (%s) not in source plan output (%s)", (Object[])new Object[]{node.getOrderBy(), node.getSource().getOutputSymbols()});
            return null;
        }

        @Override
        public Void visitOutput(OutputNode node, Void context) {
            PlanNode source = node.getSource();
            source.accept(this, context);
            this.verifyUniqueId(node);
            Preconditions.checkArgument((boolean)source.getOutputSymbols().containsAll(node.getOutputSymbols()), (String)"Invalid node. Output column dependencies (%s) not in source plan output (%s)", (Object[])new Object[]{node.getOutputSymbols(), node.getSource().getOutputSymbols()});
            return null;
        }

        @Override
        public Void visitLimit(LimitNode node, Void context) {
            PlanNode source = node.getSource();
            source.accept(this, context);
            this.verifyUniqueId(node);
            return null;
        }

        @Override
        public Void visitJoin(JoinNode node, Void context) {
            node.getLeft().accept(this, context);
            node.getRight().accept(this, context);
            this.verifyUniqueId(node);
            for (JoinNode.EquiJoinClause clause : node.getCriteria()) {
                Preconditions.checkArgument((boolean)node.getLeft().getOutputSymbols().contains(clause.getLeft()), (String)"Symbol from join clause (%s) not in left source (%s)", (Object[])new Object[]{clause.getLeft(), node.getLeft().getOutputSymbols()});
                Preconditions.checkArgument((boolean)node.getRight().getOutputSymbols().contains(clause.getRight()), (String)"Symbol from join clause (%s) not in right source (%s)", (Object[])new Object[]{clause.getRight(), node.getRight().getOutputSymbols()});
            }
            return null;
        }

        @Override
        public Void visitSemiJoin(SemiJoinNode node, Void context) {
            node.getSource().accept(this, context);
            node.getFilteringSource().accept(this, context);
            this.verifyUniqueId(node);
            Preconditions.checkArgument((boolean)node.getSource().getOutputSymbols().contains(node.getSourceJoinSymbol()), (String)"Symbol from semi join clause (%s) not in source (%s)", (Object[])new Object[]{node.getSourceJoinSymbol(), node.getSource().getOutputSymbols()});
            Preconditions.checkArgument((boolean)node.getFilteringSource().getOutputSymbols().contains(node.getFilteringSourceJoinSymbol()), (String)"Symbol from semi join clause (%s) not in filtering source (%s)", (Object[])new Object[]{node.getSourceJoinSymbol(), node.getFilteringSource().getOutputSymbols()});
            Preconditions.checkArgument((boolean)node.getOutputSymbols().containsAll(node.getSource().getOutputSymbols()), (String)"Semi join output symbols (%s) must contain all of the source symbols (%s)", (Object[])new Object[]{node.getOutputSymbols(), node.getSource().getOutputSymbols()});
            Preconditions.checkArgument((boolean)node.getOutputSymbols().contains(node.getSemiJoinOutput()), (String)"Semi join output symbols (%s) must contain join result (%s)", (Object[])new Object[]{node.getOutputSymbols(), node.getSemiJoinOutput()});
            return null;
        }

        @Override
        public Void visitTableScan(TableScanNode node, Void context) {
            this.verifyUniqueId(node);
            Preconditions.checkArgument((boolean)node.getAssignments().keySet().containsAll(node.getOutputSymbols()), (Object)"Assignments must contain mappings for output symbols");
            Set<Symbol> predicateSymbols = DependencyExtractor.extractUnique(node.getPartitionPredicate());
            Preconditions.checkArgument((boolean)node.getAssignments().keySet().containsAll(predicateSymbols), (Object)"Assignments must contain mappings for all partition predicate symbols");
            return null;
        }

        @Override
        public Void visitExchange(ExchangeNode node, Void context) {
            this.verifyUniqueId(node);
            return null;
        }

        @Override
        public Void visitSink(SinkNode node, Void context) {
            PlanNode source = node.getSource();
            source.accept(this, context);
            this.verifyUniqueId(node);
            return null;
        }

        @Override
        public Void visitTableWriter(TableWriterNode node, Void context) {
            PlanNode source = node.getSource();
            source.accept(this, context);
            this.verifyUniqueId(node);
            return null;
        }

        @Override
        public Void visitUnion(UnionNode node, Void context) {
            for (int i = 0; i < node.getSources().size(); ++i) {
                PlanNode subplan = node.getSources().get(i);
                Preconditions.checkArgument((boolean)subplan.getOutputSymbols().containsAll(node.sourceOutputLayout(i)), (Object)"UNION subplan must provide all of the necessary symbols");
                subplan.accept(this, context);
            }
            this.verifyUniqueId(node);
            return null;
        }

        private void verifyUniqueId(PlanNode node) {
            PlanNodeId id = node.getId();
            Preconditions.checkArgument((!this.nodesById.containsKey(id) ? 1 : 0) != 0, (String)"Duplicate node id found %s between %s and %s", (Object[])new Object[]{node.getId(), node, this.nodesById.get(id)});
            this.nodesById.put(id, node);
        }
    }
}

