/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SinkNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.util.GraphvizPrinter;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PlanPrinter {
    private final StringBuilder output = new StringBuilder();

    private PlanPrinter(PlanNode plan, Map<Symbol, Type> types, Optional<Map<PlanFragmentId, PlanFragment>> fragmentsById) {
        Preconditions.checkNotNull((Object)plan, (Object)"plan is null");
        Preconditions.checkNotNull(types, (Object)"types is null");
        Preconditions.checkNotNull(fragmentsById, (Object)"fragmentsById is null");
        Visitor visitor = new Visitor(types, fragmentsById);
        plan.accept(visitor, 0);
    }

    public String toString() {
        return this.output.toString();
    }

    public static String textLogicalPlan(PlanNode plan, Map<Symbol, Type> types) {
        return new PlanPrinter(plan, types, (Optional<Map<PlanFragmentId, PlanFragment>>)Optional.absent()).toString();
    }

    public static String textDistributedPlan(SubPlan plan) {
        List<PlanFragment> fragments = plan.getAllFragments();
        ImmutableMap fragmentsById = Maps.uniqueIndex(fragments, PlanFragment.idGetter());
        PlanFragment fragment = plan.getFragment();
        return new PlanPrinter(fragment.getRoot(), fragment.getSymbols(), (Optional<Map<PlanFragmentId, PlanFragment>>)Optional.of((Object)fragmentsById)).toString();
    }

    public static String graphvizLogicalPlan(PlanNode plan, Map<Symbol, Type> types) {
        PlanFragment fragment = new PlanFragment(new PlanFragmentId("graphviz_plan"), plan.getId(), types, plan);
        return GraphvizPrinter.printLogical((List<PlanFragment>)ImmutableList.of((Object)fragment));
    }

    public static String graphvizDistributedPlan(SubPlan plan) {
        return GraphvizPrinter.printDistributed(plan);
    }

    private void print(int indent, String format, Object ... args) {
        String value = args.length == 0 ? format : String.format(format, args);
        this.output.append(Strings.repeat((String)"    ", (int)indent)).append(value).append('\n');
    }

    private class Visitor
    extends PlanVisitor<Integer, Void> {
        private final Map<Symbol, Type> types;
        private final Optional<Map<PlanFragmentId, PlanFragment>> fragmentsById;

        public Visitor(Map<Symbol, Type> types, Optional<Map<PlanFragmentId, PlanFragment>> fragmentsById) {
            this.types = types;
            this.fragmentsById = fragmentsById;
        }

        @Override
        public Void visitJoin(JoinNode node, Integer indent) {
            ArrayList<ComparisonExpression> joinExpressions = new ArrayList<ComparisonExpression>();
            for (JoinNode.EquiJoinClause clause : node.getCriteria()) {
                joinExpressions.add(new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)new QualifiedNameReference(clause.getLeft().toQualifiedName()), (Expression)new QualifiedNameReference(clause.getRight().toQualifiedName())));
            }
            PlanPrinter.this.print(indent, "- %s[%s] => [%s]", new Object[]{node.getType().getJoinLabel(), Joiner.on((String)" AND ").join(joinExpressions), this.formatOutputs(node.getOutputSymbols())});
            node.getLeft().accept(this, indent + 1);
            node.getRight().accept(this, indent + 1);
            return null;
        }

        @Override
        public Void visitSemiJoin(SemiJoinNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- SemiJoin[%s = %s] => [%s]", new Object[]{node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol(), this.formatOutputs(node.getOutputSymbols())});
            node.getSource().accept(this, indent + 1);
            node.getFilteringSource().accept(this, indent + 1);
            return null;
        }

        @Override
        public Void visitLimit(LimitNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Limit[%s] => [%s]", new Object[]{node.getCount(), this.formatOutputs(node.getOutputSymbols())});
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitAggregation(AggregationNode node, Integer indent) {
            String type = "";
            if (node.getStep() != AggregationNode.Step.SINGLE) {
                type = String.format("(%s)", node.getStep().toString());
            }
            String key = "";
            if (!node.getGroupBy().isEmpty()) {
                key = node.getGroupBy().toString();
            }
            PlanPrinter.this.print(indent, "- Aggregate%s%s => [%s]", new Object[]{type, key, this.formatOutputs(node.getOutputSymbols())});
            for (Map.Entry<Symbol, FunctionCall> entry : node.getAggregations().entrySet()) {
                PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{entry.getKey(), entry.getValue()});
            }
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitWindow(final WindowNode node, Integer indent) {
            List partitionBy = Lists.transform(node.getPartitionBy(), (Function)Functions.toStringFunction());
            List orderBy = Lists.transform(node.getOrderBy(), (Function)new Function<Symbol, String>(){

                public String apply(Symbol input) {
                    return input + " " + node.getOrderings().get(input);
                }
            });
            ArrayList<String> args = new ArrayList<String>();
            if (!partitionBy.isEmpty()) {
                args.add(String.format("partition by (%s)", Joiner.on((String)", ").join((Iterable)partitionBy)));
            }
            if (!orderBy.isEmpty()) {
                args.add(String.format("order by (%s)", Joiner.on((String)", ").join((Iterable)orderBy)));
            }
            PlanPrinter.this.print(indent, "- Window[%s] => [%s]", new Object[]{Joiner.on((String)", ").join(args), this.formatOutputs(node.getOutputSymbols())});
            for (Map.Entry<Symbol, FunctionCall> entry : node.getWindowFunctions().entrySet()) {
                PlanPrinter.this.print(indent + 2, "%s := %s(%s)", new Object[]{entry.getKey(), entry.getValue().getName(), Joiner.on((String)", ").join((Iterable)entry.getValue().getArguments())});
            }
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitTableScan(TableScanNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- TableScan[%s, partition predicate=%s, upstream predicate=%s] => [%s]", new Object[]{node.getTable(), node.getPartitionPredicate(), node.getUpstreamPredicateHint(), this.formatOutputs(node.getOutputSymbols())});
            for (Map.Entry<Symbol, ColumnHandle> entry : node.getAssignments().entrySet()) {
                PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{entry.getKey(), entry.getValue()});
            }
            return null;
        }

        @Override
        public Void visitFilter(FilterNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Filter[%s] => [%s]", new Object[]{node.getPredicate(), this.formatOutputs(node.getOutputSymbols())});
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitProject(ProjectNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Project => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            for (Map.Entry<Symbol, Expression> entry : node.getOutputMap().entrySet()) {
                if (entry.getValue() instanceof QualifiedNameReference && ((QualifiedNameReference)entry.getValue()).getName().equals((Object)entry.getKey().toQualifiedName())) continue;
                PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{entry.getKey(), entry.getValue()});
            }
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitOutput(OutputNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Output[%s]", new Object[]{Joiner.on((String)", ").join(node.getColumnNames())});
            for (int i = 0; i < node.getColumnNames().size(); ++i) {
                Symbol symbol;
                String name = node.getColumnNames().get(i);
                if (name.equals((symbol = node.getOutputSymbols().get(i)).toString())) continue;
                PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{name, symbol});
            }
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitTopN(final TopNNode node, Integer indent) {
            Iterable keys = Iterables.transform(node.getOrderBy(), (Function)new Function<Symbol, String>(){

                public String apply(Symbol input) {
                    return input + " " + node.getOrderings().get(input);
                }
            });
            PlanPrinter.this.print(indent, "- TopN[%s by (%s)] => [%s]", new Object[]{node.getCount(), Joiner.on((String)", ").join(keys), this.formatOutputs(node.getOutputSymbols())});
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitSort(final SortNode node, Integer indent) {
            Iterable keys = Iterables.transform(node.getOrderBy(), (Function)new Function<Symbol, String>(){

                public String apply(Symbol input) {
                    return input + " " + node.getOrderings().get(input);
                }
            });
            PlanPrinter.this.print(indent, "- Sort[%s] => [%s]", new Object[]{Joiner.on((String)", ").join(keys), this.formatOutputs(node.getOutputSymbols())});
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitTableWriter(TableWriterNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- TableWrite[%s] => [%s]", new Object[]{node.getTable(), this.formatOutputs(node.getOutputSymbols())});
            for (Map.Entry<Symbol, ColumnHandle> entry : node.getColumns().entrySet()) {
                PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{entry.getValue(), entry.getKey()});
            }
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitExchange(ExchangeNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Exchange[%s] => [%s]", new Object[]{node.getSourceFragmentIds(), this.formatOutputs(node.getOutputSymbols())});
            return this.processExchange(node, indent + 1);
        }

        @Override
        public Void visitSink(SinkNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Sink[%s] => [%s]", new Object[]{node.getId(), this.formatOutputs(node.getOutputSymbols())});
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitUnion(UnionNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Union => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            return this.processChildren(node, indent + 1);
        }

        @Override
        protected Void visitPlan(PlanNode node, Integer context) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        private Void processChildren(PlanNode node, int indent) {
            for (PlanNode child : node.getSources()) {
                child.accept(this, indent);
            }
            return null;
        }

        private Void processExchange(ExchangeNode node, int indent) {
            for (PlanFragmentId planFragmentId : node.getSourceFragmentIds()) {
                PlanFragment target = (PlanFragment)((Map)this.fragmentsById.get()).get(planFragmentId);
                target.getRoot().accept(this, indent);
            }
            return null;
        }

        private String formatOutputs(List<Symbol> symbols) {
            return Joiner.on((String)", ").join(Iterables.transform(symbols, (Function)new Function<Symbol, String>(){

                public String apply(Symbol input) {
                    return input + ":" + Visitor.this.types.get(input);
                }
            }));
        }
    }
}

