/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.metadata.AliasDao;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.NodeManager;
import com.facebook.presto.metadata.ShardManager;
import com.facebook.presto.sql.planner.optimizations.ImplementSampleAsFilter;
import com.facebook.presto.sql.planner.optimizations.LimitPushDown;
import com.facebook.presto.sql.planner.optimizations.MergeProjections;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PredicatePushDown;
import com.facebook.presto.sql.planner.optimizations.PruneRedundantProjections;
import com.facebook.presto.sql.planner.optimizations.PruneUnreferencedOutputs;
import com.facebook.presto.sql.planner.optimizations.SetFlatteningOptimizer;
import com.facebook.presto.sql.planner.optimizations.SimplifyExpressions;
import com.facebook.presto.sql.planner.optimizations.TableAliasSelector;
import com.facebook.presto.sql.planner.optimizations.UnaliasSymbolReferences;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import javax.inject.Provider;

public class PlanOptimizersFactory
implements Provider<List<PlanOptimizer>> {
    private final Metadata metadata;
    private List<PlanOptimizer> optimizers;

    @Inject
    public PlanOptimizersFactory(Metadata metadata) {
        this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object[])new PlanOptimizer[]{new ImplementSampleAsFilter(), new SimplifyExpressions(metadata), new PruneUnreferencedOutputs(), new UnaliasSymbolReferences(), new PruneRedundantProjections(), new SetFlatteningOptimizer(), new LimitPushDown(), new PredicatePushDown(metadata), new MergeProjections(), new SimplifyExpressions(metadata), new UnaliasSymbolReferences(), new PruneUnreferencedOutputs(), new PruneRedundantProjections()});
        this.optimizers = builder.build();
    }

    @Inject(optional=true)
    public synchronized void injectAdditionalDependencies(AliasDao aliasDao, NodeManager nodeManager, ShardManager shardManager) {
        Preconditions.checkNotNull((Object)aliasDao, (Object)"aliasDao is null");
        Preconditions.checkNotNull((Object)nodeManager, (Object)"nodeManager is null");
        Preconditions.checkNotNull((Object)shardManager, (Object)"shardManager is null");
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.optimizers);
        builder.add((Object)new TableAliasSelector(this.metadata, aliasDao, nodeManager, shardManager));
        this.optimizers = builder.build();
    }

    public synchronized List<PlanOptimizer> get() {
        return this.optimizers;
    }
}

