/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.util.IterableTransformer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PlanFragment {
    private final PlanFragmentId id;
    private final PlanNode root;
    private final PlanNodeId partitionedSource;
    private final Map<Symbol, Type> symbols;

    @JsonCreator
    public PlanFragment(@JsonProperty(value="id") PlanFragmentId id, @JsonProperty(value="partitionedSource") PlanNodeId partitionedSource, @JsonProperty(value="symbols") Map<Symbol, Type> symbols, @JsonProperty(value="root") PlanNode root) {
        Preconditions.checkNotNull((Object)id, (Object)"id is null");
        Preconditions.checkNotNull(symbols, (Object)"symbols is null");
        Preconditions.checkNotNull((Object)root, (Object)"root is null");
        this.id = id;
        this.root = root;
        this.partitionedSource = partitionedSource;
        this.symbols = symbols;
    }

    @JsonProperty
    public PlanFragmentId getId() {
        return this.id;
    }

    public boolean isPartitioned() {
        return this.partitionedSource != null;
    }

    @JsonProperty
    public PlanNodeId getPartitionedSource() {
        return this.partitionedSource;
    }

    @JsonProperty
    public PlanNode getRoot() {
        return this.root;
    }

    @JsonProperty
    public Map<Symbol, Type> getSymbols() {
        return this.symbols;
    }

    public List<TupleInfo> getTupleInfos() {
        return ImmutableList.copyOf(IterableTransformer.on(this.getRoot().getOutputSymbols()).transform(Functions.forMap(this.getSymbols())).transform(Type.toRaw()).transform(new Function<TupleInfo.Type, TupleInfo>(){

            public TupleInfo apply(TupleInfo.Type input) {
                return new TupleInfo(input);
            }
        }).list());
    }

    public List<PlanNode> getSources() {
        ImmutableList.Builder sources = ImmutableList.builder();
        this.findSources(this.root, (ImmutableList.Builder<PlanNode>)sources);
        return sources.build();
    }

    private void findSources(PlanNode node, ImmutableList.Builder<PlanNode> builder) {
        for (PlanNode source : node.getSources()) {
            this.findSources(source, builder);
        }
        if (node.getSources().isEmpty()) {
            builder.add((Object)node);
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("partitionedSource", (Object)this.partitionedSource).toString();
    }

    public static Function<PlanFragment, PlanFragmentId> idGetter() {
        return new Function<PlanFragment, PlanFragmentId>(){

            public PlanFragmentId apply(PlanFragment input) {
                return input.getId();
            }
        };
    }
}

