/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.importer.PeriodicImportJob;
import com.facebook.presto.importer.PeriodicImportManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.NativeTableHandle;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TableMetadata;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.sql.analyzer.TupleDescriptor;
import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.PlanSanityChecker;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.RelationPlanner;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QueryBody;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.storage.StorageManager;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;

public class LogicalPlanner {
    private final PlanNodeIdAllocator idAllocator;
    private final Session session;
    private final List<PlanOptimizer> planOptimizers;
    private final SymbolAllocator symbolAllocator = new SymbolAllocator();
    private final Metadata metadata;
    private final PeriodicImportManager periodicImportManager;
    private final StorageManager storageManager;

    public LogicalPlanner(Session session, List<PlanOptimizer> planOptimizers, PlanNodeIdAllocator idAllocator, Metadata metadata, PeriodicImportManager periodicImportManager, StorageManager storageManager) {
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        Preconditions.checkNotNull(planOptimizers, (Object)"planOptimizers is null");
        Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        Preconditions.checkNotNull((Object)periodicImportManager, (Object)"periodicImportManager is null");
        Preconditions.checkNotNull((Object)storageManager, (Object)"storageManager is null");
        this.session = session;
        this.planOptimizers = planOptimizers;
        this.idAllocator = idAllocator;
        this.metadata = metadata;
        this.periodicImportManager = periodicImportManager;
        this.storageManager = storageManager;
    }

    public Plan plan(Analysis analysis) {
        RelationPlan plan;
        if (analysis.getDestination() != null) {
            plan = this.createTableWriterPlan(analysis);
        } else {
            RelationPlanner planner = new RelationPlanner(analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session);
            plan = (RelationPlan)planner.process((Node)analysis.getQuery(), null);
        }
        PlanNode root = this.createOutputPlan(plan, analysis);
        PlanSanityChecker.validate(root);
        for (PlanOptimizer optimizer : this.planOptimizers) {
            root = optimizer.optimize(root, this.session, this.symbolAllocator.getTypes(), this.symbolAllocator, this.idAllocator);
        }
        PlanSanityChecker.validate(root);
        return new Plan(root, this.symbolAllocator);
    }

    private RelationPlan createTableWriterPlan(Analysis analysis) {
        ImmutableList targetColumnHandles;
        RelationPlan plan;
        TableHandle targetTable;
        QualifiedTableName destination = analysis.getDestination();
        if (analysis.isDoRefresh()) {
            targetTable = (TableHandle)this.metadata.getTableHandle(destination).get();
            QualifiedTableName sourceTable = this.storageManager.getTableSource((NativeTableHandle)targetTable);
            TableHandle sourceTableHandle = (TableHandle)this.metadata.getTableHandle(sourceTable).get();
            TableMetadata sourceTableMetadata = this.metadata.getTableMetadata(sourceTableHandle);
            Map<String, ColumnHandle> sourceTableColumns = this.metadata.getColumnHandles(sourceTableHandle);
            Map<String, ColumnHandle> targetTableColumns = this.metadata.getColumnHandles(targetTable);
            ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder();
            ImmutableMap.Builder inputColumnsBuilder = ImmutableMap.builder();
            ImmutableList.Builder fields = ImmutableList.builder();
            ImmutableList.Builder columnHandleBuilder = ImmutableList.builder();
            for (ColumnMetadata column : sourceTableMetadata.getColumns()) {
                Field field = Field.newQualified(sourceTable.asQualifiedName(), (Optional<String>)Optional.of((Object)column.getName()), Type.fromRaw(column.getType()));
                Symbol symbol = this.symbolAllocator.newSymbol(field);
                inputColumnsBuilder.put((Object)symbol, (Object)sourceTableColumns.get(column.getName()));
                ColumnHandle targetColumnHandle = targetTableColumns.get(column.getName());
                fields.add((Object)field);
                columnHandleBuilder.add((Object)targetColumnHandle);
                outputSymbolsBuilder.add((Object)symbol);
            }
            ImmutableList outputSymbols = outputSymbolsBuilder.build();
            plan = new RelationPlan(new TableScanNode(this.idAllocator.getNextId(), sourceTableHandle, (List<Symbol>)outputSymbols, (Map<Symbol, ColumnHandle>)inputColumnsBuilder.build(), (Expression)BooleanLiteral.TRUE_LITERAL, (Expression)BooleanLiteral.TRUE_LITERAL), new TupleDescriptor((List<Field>)fields.build()), (List<Symbol>)outputSymbols);
            targetColumnHandles = columnHandleBuilder.build();
        } else {
            RelationPlanner planner = new RelationPlanner(analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session);
            plan = (RelationPlan)planner.process((Node)analysis.getQuery(), null);
            ImmutableList.Builder columns = ImmutableList.builder();
            for (int i = 0; i < plan.getDescriptor().getFields().size(); ++i) {
                Field field = plan.getDescriptor().getFields().get(i);
                String name = (String)field.getName().or((Object)("_field" + i));
                ColumnMetadata columnMetadata = new ColumnMetadata(name, field.getType().getColumnType(), i, false);
                columns.add((Object)columnMetadata);
            }
            TableMetadata tableMetadata = new TableMetadata(destination.asSchemaTableName(), (List)columns.build());
            targetTable = this.metadata.createTable(destination.getCatalogName(), tableMetadata);
            Map<String, ColumnHandle> columnHandleIndex = this.metadata.getColumnHandles(targetTable);
            ImmutableList.Builder columnHandleBuilder = ImmutableList.builder();
            for (ColumnMetadata column : tableMetadata.getColumns()) {
                columnHandleBuilder.add((Object)columnHandleIndex.get(column.getName()));
            }
            targetColumnHandles = columnHandleBuilder.build();
            QueryBody queryBody = analysis.getQuery().getQueryBody();
            Preconditions.checkState((boolean)(queryBody instanceof QuerySpecification), (Object)"Query is not a simple select statement");
            List relations = ((QuerySpecification)queryBody).getFrom();
            Preconditions.checkState((relations.size() == 1 ? 1 : 0) != 0, (Object)"Query has more than one source table");
            Relation relation = (Relation)Iterables.getOnlyElement((Iterable)relations);
            Preconditions.checkState((boolean)(relation instanceof Table), (Object)"FROM clause is not a simple table name");
            QualifiedTableName sourceTable = MetadataUtil.createQualifiedTableName(this.session, ((Table)relation).getName());
            this.storageManager.insertTableSource((NativeTableHandle)targetTable, sourceTable);
            if (analysis.getRefreshInterval().isPresent()) {
                PeriodicImportJob job = PeriodicImportJob.createJob(sourceTable, destination, ((Integer)analysis.getRefreshInterval().get()).intValue());
                this.periodicImportManager.insertJob(job);
            }
        }
        ImmutableMap.Builder mappings = ImmutableMap.builder();
        for (int i = 0; i < targetColumnHandles.size(); ++i) {
            ColumnHandle column = (ColumnHandle)targetColumnHandles.get(i);
            Symbol symbol = plan.getSymbol(i);
            mappings.put((Object)symbol, (Object)column);
        }
        Symbol output = this.symbolAllocator.newSymbol("imported_rows", Type.BIGINT);
        TableWriterNode writerNode = new TableWriterNode(this.idAllocator.getNextId(), plan.getRoot(), targetTable, (Map<Symbol, ColumnHandle>)mappings.build(), output);
        return new RelationPlan(writerNode, analysis.getOutputDescriptor(), (List<Symbol>)ImmutableList.of((Object)output));
    }

    private PlanNode createOutputPlan(RelationPlan plan, Analysis analysis) {
        ImmutableList.Builder names = ImmutableList.builder();
        ImmutableList.Builder outputs = ImmutableList.builder();
        for (int i = 0; i < analysis.getOutputDescriptor().getFields().size(); ++i) {
            Field field = analysis.getOutputDescriptor().getFields().get(i);
            String name = (String)field.getName().or((Object)("_col" + i));
            names.add((Object)name);
            outputs.add((Object)plan.getSymbol(i));
        }
        return new OutputNode(this.idAllocator.getNextId(), plan.getRoot(), (List<String>)names.build(), (List<Symbol>)outputs.build());
    }
}

