/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.metadata.FunctionHandle;
import com.facebook.presto.metadata.LocalStorageManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.AggregationFunctionDefinition;
import com.facebook.presto.operator.AggregationOperator;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.ExchangeClient;
import com.facebook.presto.operator.ExchangeOperator;
import com.facebook.presto.operator.FilterAndProjectOperator;
import com.facebook.presto.operator.FilterFunction;
import com.facebook.presto.operator.FilterFunctions;
import com.facebook.presto.operator.HashAggregationOperator;
import com.facebook.presto.operator.HashBuilderOperator;
import com.facebook.presto.operator.HashJoinOperator;
import com.facebook.presto.operator.HashSemiJoinOperator;
import com.facebook.presto.operator.InMemoryExchange;
import com.facebook.presto.operator.InMemoryExchangeSourceOperator;
import com.facebook.presto.operator.LimitOperator;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OrderByOperator;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.operator.ProjectionFunction;
import com.facebook.presto.operator.ProjectionFunctions;
import com.facebook.presto.operator.ScanFilterAndProjectOperator;
import com.facebook.presto.operator.SetBuilderOperator;
import com.facebook.presto.operator.TableScanOperator;
import com.facebook.presto.operator.TableWriterOperator;
import com.facebook.presto.operator.TopNOperator;
import com.facebook.presto.operator.WindowOperator;
import com.facebook.presto.operator.window.WindowFunction;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.split.DataStreamProvider;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.planner.InterpretedFilterFunction;
import com.facebook.presto.sql.planner.InterpretedProjectionFunction;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolToInputRewriter;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SinkNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Input;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.tuple.FieldOrderedTupleComparator;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.tuple.TupleReadable;
import com.facebook.presto.util.IterableTransformer;
import com.facebook.presto.util.MoreFunctions;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

public class LocalExecutionPlanner {
    private static final Logger log = Logger.get(LocalExecutionPlanner.class);
    private final NodeInfo nodeInfo;
    private final Metadata metadata;
    private final DataStreamProvider dataStreamProvider;
    private final LocalStorageManager storageManager;
    private final Supplier<ExchangeClient> exchangeClientSupplier;
    private final ExpressionCompiler compiler;

    @Inject
    public LocalExecutionPlanner(NodeInfo nodeInfo, Metadata metadata, DataStreamProvider dataStreamProvider, LocalStorageManager storageManager, Supplier<ExchangeClient> exchangeClientSupplier, ExpressionCompiler compiler) {
        this.nodeInfo = (NodeInfo)Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null");
        this.dataStreamProvider = dataStreamProvider;
        this.exchangeClientSupplier = exchangeClientSupplier;
        this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        this.storageManager = (LocalStorageManager)Preconditions.checkNotNull((Object)storageManager, (Object)"storageManager is null");
        this.compiler = (ExpressionCompiler)Preconditions.checkNotNull((Object)compiler, (Object)"compiler is null");
    }

    public LocalExecutionPlan plan(Session session, PlanNode plan, Map<Symbol, Type> types, OutputFactory outputOperatorFactory) {
        LocalExecutionPlanContext context = new LocalExecutionPlanContext(session, types);
        PhysicalOperation physicalOperation = plan.accept(new Visitor(), context);
        DriverFactory driverFactory = new DriverFactory(context.isInputDriver(), true, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)physicalOperation.getOperatorFactories()).add((Object)outputOperatorFactory.createOutputOperator(context.getNextOperatorId(), physicalOperation.getTupleInfos())).build());
        context.addDriverFactory(driverFactory);
        return new LocalExecutionPlan(context.getDriverFactories());
    }

    private static IdentityProjectionInfo computeIdentityMapping(List<Symbol> symbols, Multimap<Symbol, Input> inputLayout, Map<Symbol, Type> types) {
        ImmutableMultimap.Builder outputMappings = ImmutableMultimap.builder();
        ArrayList<ProjectionFunction> projections = new ArrayList<ProjectionFunction>();
        int channel = 0;
        for (Symbol symbol : symbols) {
            ProjectionFunction function = ProjectionFunctions.singleColumn(types.get(symbol).getRawType(), (Input)LocalExecutionPlanner.getFirst(inputLayout.get((Object)symbol)));
            projections.add(function);
            outputMappings.put((Object)symbol, (Object)new Input(channel, 0));
            ++channel;
        }
        return new IdentityProjectionInfo((Multimap<Symbol, Input>)outputMappings.build(), projections);
    }

    private PhysicalOperation packIfNecessary(List<Symbol> symbols, PhysicalOperation source, Map<Symbol, Type> types, LocalExecutionPlanContext context) {
        List<Integer> channels = LocalExecutionPlanner.getChannelsForSymbols(symbols, source.getLayout());
        List<TupleInfo> tupleInfos = source.getTupleInfos();
        if (channels.size() > 1 || tupleInfos.get((Integer)Iterables.getOnlyElement(channels)).getFieldCount() > 1) {
            source = LocalExecutionPlanner.pack(source, symbols, types, context);
        }
        return source;
    }

    private static PhysicalOperation pack(PhysicalOperation source, List<Symbol> symbols, Map<Symbol, Type> types, LocalExecutionPlanContext context) {
        Preconditions.checkArgument((!symbols.isEmpty() ? 1 : 0) != 0, (Object)"symbols is empty");
        ImmutableList otherSymbols = ImmutableList.copyOf((Collection)Sets.difference((Set)source.getLayout().keySet(), (Set)ImmutableSet.copyOf(symbols)));
        IdentityProjectionInfo mappings = LocalExecutionPlanner.computeIdentityMapping((List<Symbol>)otherSymbols, source.getLayout(), types);
        ImmutableMultimap.Builder outputMappings = ImmutableMultimap.builder();
        ImmutableList.Builder projections = ImmutableList.builder();
        outputMappings.putAll(mappings.getOutputLayout());
        projections.addAll(mappings.getProjections());
        ArrayList<ProjectionFunction> packedProjections = new ArrayList<ProjectionFunction>();
        int channel = mappings.getProjections().size();
        int field = 0;
        for (Symbol symbol : symbols) {
            packedProjections.add(ProjectionFunctions.singleColumn(types.get(symbol).getRawType(), (Input)LocalExecutionPlanner.getFirst(source.getLayout().get((Object)symbol))));
            outputMappings.put((Object)symbol, (Object)new Input(channel, field));
            ++field;
        }
        projections.add((Object)ProjectionFunctions.concat(packedProjections));
        FilterAndProjectOperator.FilterAndProjectOperatorFactory operatorFactory = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(context.getNextOperatorId(), FilterFunctions.TRUE_FUNCTION, (Iterable<? extends ProjectionFunction>)projections.build());
        return new PhysicalOperation(operatorFactory, (Multimap<Symbol, Input>)outputMappings.build(), source);
    }

    private static List<Integer> getChannelsForSymbols(List<Symbol> symbols, Multimap<Symbol, Input> layout) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Symbol symbol : symbols) {
            builder.add((Object)((Input)LocalExecutionPlanner.getFirst(layout.get((Object)symbol))).getChannel());
        }
        return builder.build();
    }

    private static Set<Integer> getChannelSetForSymbols(List<Symbol> symbols, Multimap<Symbol, Input> layout) {
        return ImmutableSet.copyOf(LocalExecutionPlanner.getChannelsForSymbols(symbols, layout));
    }

    private static Map<Symbol, Input> convertLayoutToInputMap(Multimap<Symbol, Input> layout) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : layout.asMap().entrySet()) {
            builder.put(entry.getKey(), LocalExecutionPlanner.getFirst((Iterable)entry.getValue()));
        }
        return builder.build();
    }

    private static <T> T getFirst(Iterable<T> iterable) {
        return iterable.iterator().next();
    }

    private static Ordering<Input> inputOrdering() {
        return Ordering.from((Comparator)new Comparator<Input>(){

            @Override
            public int compare(Input o1, Input o2) {
                return ComparisonChain.start().compare(o1.getChannel(), o2.getChannel()).compare(o1.getField(), o2.getField()).result();
            }
        });
    }

    private static class PhysicalOperation {
        private final List<OperatorFactory> operatorFactories;
        private final Multimap<Symbol, Input> layout;
        private final List<TupleInfo> tupleInfos;

        public PhysicalOperation(OperatorFactory operatorFactory, Multimap<Symbol, Input> layout) {
            Preconditions.checkNotNull((Object)operatorFactory, (Object)"operatorFactory is null");
            Preconditions.checkNotNull(layout, (Object)"layout is null");
            this.operatorFactories = ImmutableList.of((Object)operatorFactory);
            this.layout = ImmutableMultimap.copyOf(layout);
            this.tupleInfos = operatorFactory.getTupleInfos();
        }

        public PhysicalOperation(OperatorFactory operatorFactory, Multimap<Symbol, Input> layout, PhysicalOperation source) {
            Preconditions.checkNotNull((Object)operatorFactory, (Object)"operatorFactory is null");
            Preconditions.checkNotNull(layout, (Object)"layout is null");
            Preconditions.checkNotNull((Object)source, (Object)"source is null");
            this.operatorFactories = ImmutableList.builder().addAll(source.getOperatorFactories()).add((Object)operatorFactory).build();
            this.layout = ImmutableMultimap.copyOf(layout);
            this.tupleInfos = operatorFactory.getTupleInfos();
        }

        public List<TupleInfo> getTupleInfos() {
            return this.tupleInfos;
        }

        public Multimap<Symbol, Input> getLayout() {
            return this.layout;
        }

        private List<OperatorFactory> getOperatorFactories() {
            return this.operatorFactories;
        }
    }

    private static class IdentityProjectionInfo {
        private final Multimap<Symbol, Input> layout;
        private final List<ProjectionFunction> projections;

        public IdentityProjectionInfo(Multimap<Symbol, Input> outputLayout, List<ProjectionFunction> projections) {
            this.layout = (Multimap)Preconditions.checkNotNull(outputLayout, (Object)"outputLayout is null");
            this.projections = (List)Preconditions.checkNotNull(projections, (Object)"projections is null");
        }

        public Multimap<Symbol, Input> getOutputLayout() {
            return this.layout;
        }

        public List<ProjectionFunction> getProjections() {
            return this.projections;
        }
    }

    private class Visitor
    extends PlanVisitor<LocalExecutionPlanContext, PhysicalOperation> {
        private Visitor() {
        }

        @Override
        public PhysicalOperation visitExchange(ExchangeNode node, LocalExecutionPlanContext context) {
            List<TupleInfo> tupleInfos = this.getSourceOperatorTupleInfos(node, context.getTypes());
            ExchangeOperator.ExchangeOperatorFactory operatorFactory = new ExchangeOperator.ExchangeOperatorFactory(context.getNextOperatorId(), node.getId(), (Supplier<ExchangeClient>)LocalExecutionPlanner.this.exchangeClientSupplier, tupleInfos);
            ImmutableMultimap.Builder outputMappings = ImmutableMultimap.builder();
            int channel = 0;
            for (Symbol symbol : node.getOutputSymbols()) {
                outputMappings.put((Object)symbol, (Object)new Input(channel, 0));
                ++channel;
            }
            return new PhysicalOperation(operatorFactory, (Multimap<Symbol, Input>)outputMappings.build());
        }

        @Override
        public PhysicalOperation visitOutput(OutputNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            Ordering comparator = LocalExecutionPlanner.inputOrdering();
            List sourceSymbols = IterableTransformer.on(source.getLayout().entries()).orderBy(comparator.onResultOf(MoreFunctions.valueGetter())).transform(MoreFunctions.keyGetter()).list();
            List<Symbol> resultSymbols = node.getOutputSymbols();
            if (resultSymbols.equals(sourceSymbols) && resultSymbols.size() == source.getTupleInfos().size()) {
                return source;
            }
            IdentityProjectionInfo mappings = LocalExecutionPlanner.computeIdentityMapping(resultSymbols, (Multimap<Symbol, Input>)source.getLayout(), context.getTypes());
            FilterAndProjectOperator.FilterAndProjectOperatorFactory operatorFactory = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(context.getNextOperatorId(), FilterFunctions.TRUE_FUNCTION, mappings.getProjections());
            return new PhysicalOperation(operatorFactory, mappings.getOutputLayout(), source);
        }

        @Override
        public PhysicalOperation visitWindow(WindowNode node, LocalExecutionPlanContext context) {
            List<Symbol> orderBySymbols;
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> partitionBySymbols = node.getPartitionBy();
            ImmutableList orderingSymbols = ImmutableList.copyOf((Iterable)Iterables.concat(partitionBySymbols, orderBySymbols = node.getOrderBy()));
            if (!orderingSymbols.isEmpty()) {
                source = LocalExecutionPlanner.this.packIfNecessary((List)orderingSymbols, source, context.getTypes(), context);
            }
            int orderByChannel = 0;
            if (!orderingSymbols.isEmpty()) {
                orderByChannel = (Integer)Iterables.getOnlyElement((Iterable)LocalExecutionPlanner.getChannelSetForSymbols((List)orderingSymbols, (Multimap<Symbol, Input>)source.getLayout()));
            }
            int[] partitionFields = new int[partitionBySymbols.size()];
            for (int i = 0; i < partitionFields.length; ++i) {
                Symbol symbol = partitionBySymbols.get(i);
                partitionFields[i] = ((Input)LocalExecutionPlanner.getFirst(source.getLayout().get((Object)symbol))).getField();
            }
            int[] sortFields = new int[orderBySymbols.size()];
            boolean[] sortOrder = new boolean[orderBySymbols.size()];
            for (int i = 0; i < sortFields.length; ++i) {
                Symbol symbol = orderBySymbols.get(i);
                sortFields[i] = ((Input)LocalExecutionPlanner.getFirst(source.getLayout().get((Object)symbol))).getField();
                sortOrder[i] = node.getOrderings().get(symbol) == SortItem.Ordering.ASCENDING;
            }
            int[] outputChannels = new int[source.getTupleInfos().size()];
            for (int i = 0; i < outputChannels.length; ++i) {
                outputChannels[i] = i;
            }
            ImmutableList.Builder windowFunctions = ImmutableList.builder();
            ArrayList<Symbol> windowFunctionOutputSymbols = new ArrayList<Symbol>();
            for (Map.Entry<Symbol, FunctionCall> entry : node.getWindowFunctions().entrySet()) {
                Symbol symbol = entry.getKey();
                FunctionHandle handle = node.getFunctionHandles().get(symbol);
                windowFunctions.add(LocalExecutionPlanner.this.metadata.getFunction(handle).getWindowFunction().get());
                windowFunctionOutputSymbols.add(symbol);
            }
            ImmutableMultimap.Builder outputMappings = ImmutableMultimap.builder();
            for (Symbol symbol : node.getSource().getOutputSymbols()) {
                outputMappings.putAll((Object)symbol, (Iterable)source.getLayout().get((Object)symbol));
            }
            int channel = source.getTupleInfos().size();
            for (Symbol symbol : windowFunctionOutputSymbols) {
                outputMappings.put((Object)symbol, (Object)new Input(channel, 0));
                ++channel;
            }
            WindowOperator.InMemoryWindowOperatorFactory operatorFactory = new WindowOperator.InMemoryWindowOperatorFactory(context.getNextOperatorId(), source.getTupleInfos(), orderByChannel, outputChannels, (List<WindowFunction>)windowFunctions.build(), partitionFields, sortFields, sortOrder, 1000000);
            return new PhysicalOperation(operatorFactory, (Multimap<Symbol, Input>)outputMappings.build(), source);
        }

        @Override
        public PhysicalOperation visitTopN(TopNNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> orderBySymbols = node.getOrderBy();
            source = LocalExecutionPlanner.this.packIfNecessary(orderBySymbols, source, context.getTypes(), context);
            int orderByChannel = (Integer)Iterables.getOnlyElement((Iterable)LocalExecutionPlanner.getChannelSetForSymbols(orderBySymbols, (Multimap<Symbol, Input>)source.getLayout()));
            ArrayList<Integer> sortFields = new ArrayList<Integer>();
            ArrayList<SortItem.Ordering> sortOrders = new ArrayList<SortItem.Ordering>();
            for (Symbol symbol : orderBySymbols) {
                sortFields.add(((Input)LocalExecutionPlanner.getFirst(source.getLayout().get((Object)symbol))).getField());
                sortOrders.add(node.getOrderings().get(symbol));
            }
            Ordering ordering = Ordering.from((Comparator)new FieldOrderedTupleComparator(sortFields, sortOrders));
            IdentityProjectionInfo mappings = LocalExecutionPlanner.computeIdentityMapping(node.getOutputSymbols(), (Multimap<Symbol, Input>)source.getLayout(), context.getTypes());
            TopNOperator.TopNOperatorFactory operator = new TopNOperator.TopNOperatorFactory(context.getNextOperatorId(), (int)node.getCount(), orderByChannel, mappings.getProjections(), (Ordering<TupleReadable>)ordering, node.isPartial());
            return new PhysicalOperation(operator, mappings.getOutputLayout(), source);
        }

        @Override
        public PhysicalOperation visitSort(SortNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> orderBySymbols = node.getOrderBy();
            source = LocalExecutionPlanner.this.packIfNecessary(orderBySymbols, source, context.getTypes(), context);
            int orderByChannel = (Integer)Iterables.getOnlyElement((Iterable)LocalExecutionPlanner.getChannelSetForSymbols(orderBySymbols, (Multimap<Symbol, Input>)source.getLayout()));
            int[] sortFields = new int[orderBySymbols.size()];
            boolean[] sortOrder = new boolean[orderBySymbols.size()];
            for (int i = 0; i < sortFields.length; ++i) {
                Symbol symbol = orderBySymbols.get(i);
                sortFields[i] = ((Input)LocalExecutionPlanner.getFirst(source.getLayout().get((Object)symbol))).getField();
                sortOrder[i] = node.getOrderings().get(symbol) == SortItem.Ordering.ASCENDING;
            }
            int[] outputChannels = new int[source.getTupleInfos().size()];
            for (int i = 0; i < outputChannels.length; ++i) {
                outputChannels[i] = i;
            }
            OrderByOperator.InMemoryOrderByOperatorFactory operator = new OrderByOperator.InMemoryOrderByOperatorFactory(context.getNextOperatorId(), source.getTupleInfos(), orderByChannel, outputChannels, 10000, sortFields, sortOrder);
            return new PhysicalOperation(operator, source.getLayout(), source);
        }

        @Override
        public PhysicalOperation visitLimit(LimitNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            LimitOperator.LimitOperatorFactory operatorFactory = new LimitOperator.LimitOperatorFactory(context.getNextOperatorId(), source.getTupleInfos(), node.getCount());
            return new PhysicalOperation(operatorFactory, source.getLayout(), source);
        }

        @Override
        public PhysicalOperation visitAggregation(AggregationNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            if (node.getGroupBy().isEmpty()) {
                return this.planGlobalAggregation(context.getNextOperatorId(), node, source);
            }
            return this.planGroupByAggregation(node, source, context);
        }

        @Override
        public PhysicalOperation visitSample(SampleNode node, LocalExecutionPlanContext context) {
            if (node.getSampleType() == SampleNode.Type.SYSTEM) {
                return node.getSource().accept(this, context);
            }
            throw new UnsupportedOperationException("not yet implemented: " + node);
        }

        @Override
        public PhysicalOperation visitFilter(FilterNode node, LocalExecutionPlanContext context) {
            PlanNode sourceNode = node.getSource();
            Expression filterExpression = node.getPredicate();
            ArrayList<Expression> projectionExpressions = new ArrayList<Expression>();
            for (int i = 0; i < node.getOutputSymbols().size(); ++i) {
                Symbol symbol = node.getOutputSymbols().get(i);
                projectionExpressions.add((Expression)new QualifiedNameReference(symbol.toQualifiedName()));
            }
            List<Symbol> outputSymbols = node.getOutputSymbols();
            return this.visitScanFilterAndProject(context, sourceNode, filterExpression, projectionExpressions, outputSymbols);
        }

        @Override
        public PhysicalOperation visitProject(ProjectNode node, LocalExecutionPlanContext context) {
            BooleanLiteral filterExpression;
            PlanNode sourceNode;
            if (node.getSource() instanceof FilterNode) {
                FilterNode filterNode = (FilterNode)node.getSource();
                sourceNode = filterNode.getSource();
                filterExpression = filterNode.getPredicate();
            } else {
                sourceNode = node.getSource();
                filterExpression = BooleanLiteral.TRUE_LITERAL;
            }
            List<Expression> projectionExpressions = node.getExpressions();
            List<Symbol> outputSymbols = node.getOutputSymbols();
            return this.visitScanFilterAndProject(context, sourceNode, (Expression)filterExpression, projectionExpressions, outputSymbols);
        }

        private PhysicalOperation visitScanFilterAndProject(LocalExecutionPlanContext context, PlanNode sourceNode, Expression filterExpression, List<Expression> projectionExpressions, List<Symbol> outputSymbols) {
            LinkedHashMap<Input, Type> sourceTypes;
            LinkedHashMap<Symbol, Input> sourceLayout;
            ArrayList<ColumnHandle> columns = null;
            PhysicalOperation source = null;
            if (sourceNode instanceof TableScanNode) {
                TableScanNode tableScanNode = (TableScanNode)sourceNode;
                sourceLayout = new LinkedHashMap();
                sourceTypes = new LinkedHashMap();
                columns = new ArrayList<ColumnHandle>();
                int channel = 0;
                for (Symbol symbol : tableScanNode.getOutputSymbols()) {
                    columns.add(tableScanNode.getAssignments().get(symbol));
                    Input input = new Input(channel, 0);
                    sourceLayout.put(symbol, input);
                    Type type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)context.getTypes().get(symbol)), (String)"No type for symbol %s", (Object[])new Object[]{symbol}));
                    sourceTypes.put(input, type);
                    ++channel;
                }
            } else {
                source = sourceNode.accept(this, context);
                sourceLayout = LocalExecutionPlanner.convertLayoutToInputMap((Multimap<Symbol, Input>)source.getLayout());
                sourceTypes = this.getInputTypes(source.getLayout(), source.getTupleInfos());
            }
            ImmutableMultimap.Builder outputMappingsBuilder = ImmutableMultimap.builder();
            for (int i = 0; i < outputSymbols.size(); ++i) {
                Symbol symbol = outputSymbols.get(i);
                outputMappingsBuilder.put((Object)symbol, (Object)new Input(i, 0));
            }
            ImmutableMultimap outputMappings = outputMappingsBuilder.build();
            try {
                OperatorFactory operatorFactory;
                SymbolToInputRewriter symbolToInputRewriter = new SymbolToInputRewriter(sourceLayout);
                Expression rewrittenFilter = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)symbolToInputRewriter, (Expression)filterExpression);
                ArrayList<Expression> rewrittenProjections = new ArrayList<Expression>();
                for (Expression projection : projectionExpressions) {
                    rewrittenProjections.add(ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)symbolToInputRewriter, (Expression)projection));
                }
                if (columns != null) {
                    operatorFactory = LocalExecutionPlanner.this.compiler.compileScanFilterAndProjectOperator(context.getNextOperatorId(), sourceNode.getId(), LocalExecutionPlanner.this.dataStreamProvider, columns, rewrittenFilter, rewrittenProjections, sourceTypes);
                    return new PhysicalOperation(operatorFactory, (Multimap<Symbol, Input>)outputMappings);
                }
                operatorFactory = LocalExecutionPlanner.this.compiler.compileFilterAndProjectOperator(context.getNextOperatorId(), rewrittenFilter, rewrittenProjections, sourceTypes);
                return new PhysicalOperation(operatorFactory, (Multimap<Symbol, Input>)outputMappings, source);
            }
            catch (RuntimeException e) {
                log.error((Throwable)e, "Compile failed for filter=%s projections=%s sourceTypes=%s error=%s", new Object[]{filterExpression, projectionExpressions, sourceTypes, e});
                FilterFunction filterFunction = filterExpression != BooleanLiteral.TRUE_LITERAL ? new InterpretedFilterFunction(filterExpression, sourceLayout, LocalExecutionPlanner.this.metadata, context.getSession()) : FilterFunctions.TRUE_FUNCTION;
                ArrayList<InterpretedProjectionFunction> projectionFunctions = new ArrayList<InterpretedProjectionFunction>();
                for (int i = 0; i < projectionExpressions.size(); ++i) {
                    ProjectionFunction function;
                    Symbol symbol = outputSymbols.get(i);
                    Expression expression = projectionExpressions.get(i);
                    if (expression instanceof QualifiedNameReference) {
                        Symbol reference = Symbol.fromQualifiedName(((QualifiedNameReference)expression).getName());
                        function = ProjectionFunctions.singleColumn(context.getTypes().get(reference).getRawType(), (Input)sourceLayout.get(reference));
                    } else {
                        function = new InterpretedProjectionFunction(context.getTypes().get(symbol), expression, sourceLayout, LocalExecutionPlanner.this.metadata, context.getSession());
                    }
                    projectionFunctions.add((InterpretedProjectionFunction)function);
                }
                if (columns != null) {
                    ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory operatorFactory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(context.getNextOperatorId(), sourceNode.getId(), LocalExecutionPlanner.this.dataStreamProvider, columns, filterFunction, projectionFunctions);
                    return new PhysicalOperation(operatorFactory, (Multimap<Symbol, Input>)outputMappings);
                }
                FilterAndProjectOperator.FilterAndProjectOperatorFactory operatorFactory = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(context.getNextOperatorId(), filterFunction, projectionFunctions);
                return new PhysicalOperation(operatorFactory, (Multimap<Symbol, Input>)outputMappings, source);
            }
        }

        private Map<Input, Type> getInputTypes(Multimap<Symbol, Input> layout, List<TupleInfo> tupleInfos) {
            ImmutableMap.Builder inputTypes = ImmutableMap.builder();
            block6: for (Input input : ImmutableSet.copyOf((Collection)layout.values())) {
                TupleInfo.Type type = tupleInfos.get(input.getChannel()).getTypes().get(input.getField());
                switch (type) {
                    case BOOLEAN: {
                        inputTypes.put((Object)input, (Object)Type.BOOLEAN);
                        continue block6;
                    }
                    case FIXED_INT_64: {
                        inputTypes.put((Object)input, (Object)Type.BIGINT);
                        continue block6;
                    }
                    case VARIABLE_BINARY: {
                        inputTypes.put((Object)input, (Object)Type.VARCHAR);
                        continue block6;
                    }
                    case DOUBLE: {
                        inputTypes.put((Object)input, (Object)Type.DOUBLE);
                        continue block6;
                    }
                }
                throw new IllegalArgumentException("Unsupported type " + type);
            }
            return inputTypes.build();
        }

        @Override
        public PhysicalOperation visitTableScan(TableScanNode node, LocalExecutionPlanContext context) {
            ImmutableMultimap.Builder outputMappings = ImmutableMultimap.builder();
            ArrayList<ColumnHandle> columns = new ArrayList<ColumnHandle>();
            int channel = 0;
            for (Symbol symbol : node.getOutputSymbols()) {
                columns.add(node.getAssignments().get(symbol));
                outputMappings.put((Object)symbol, (Object)new Input(channel, 0));
                ++channel;
            }
            List<TupleInfo> tupleInfos = this.getSourceOperatorTupleInfos(node, context.getTypes());
            TableScanOperator.TableScanOperatorFactory operatorFactory = new TableScanOperator.TableScanOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.dataStreamProvider, tupleInfos, columns);
            return new PhysicalOperation(operatorFactory, (Multimap<Symbol, Input>)outputMappings.build());
        }

        @Override
        public PhysicalOperation visitJoin(JoinNode node, LocalExecutionPlanContext context) {
            List<JoinNode.EquiJoinClause> clauses = node.getCriteria();
            List leftSymbols = Lists.transform(clauses, JoinNode.EquiJoinClause.leftGetter());
            List rightSymbols = Lists.transform(clauses, JoinNode.EquiJoinClause.rightGetter());
            switch (node.getType()) {
                case INNER: 
                case LEFT: {
                    return this.createJoinOperator(node, node.getLeft(), leftSymbols, node.getRight(), rightSymbols, context);
                }
                case RIGHT: {
                    return this.createJoinOperator(node, node.getRight(), rightSymbols, node.getLeft(), leftSymbols, context);
                }
            }
            throw new UnsupportedOperationException("Unsupported join type: " + (Object)((Object)node.getType()));
        }

        private PhysicalOperation createJoinOperator(JoinNode node, PlanNode probeNode, List<Symbol> probeSymbols, PlanNode buildNode, List<Symbol> buildSymbols, LocalExecutionPlanContext context) {
            PhysicalOperation probeSource = probeNode.accept(this, context);
            probeSource = LocalExecutionPlanner.this.packIfNecessary(probeSymbols, probeSource, context.getTypes(), context);
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = buildNode.accept(this, buildContext);
            buildSource = LocalExecutionPlanner.this.packIfNecessary(buildSymbols, buildSource, buildContext.getTypes(), buildContext);
            int probeChannel = (Integer)Iterables.getOnlyElement((Iterable)LocalExecutionPlanner.getChannelSetForSymbols(probeSymbols, (Multimap<Symbol, Input>)probeSource.getLayout()));
            int buildChannel = (Integer)Iterables.getOnlyElement((Iterable)LocalExecutionPlanner.getChannelSetForSymbols(buildSymbols, (Multimap<Symbol, Input>)buildSource.getLayout()));
            HashBuilderOperator.HashBuilderOperatorFactory hashBuilderOperatorFactory = new HashBuilderOperator.HashBuilderOperatorFactory(buildContext.getNextOperatorId(), buildSource.getTupleInfos(), buildChannel, 100000);
            HashBuilderOperator.HashSupplier hashSupplier = hashBuilderOperatorFactory.getHashSupplier();
            DriverFactory buildDriverFactory = new DriverFactory(buildContext.isInputDriver(), false, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)buildSource.getOperatorFactories()).add((Object)hashBuilderOperatorFactory).build());
            context.addDriverFactory(buildDriverFactory);
            ImmutableMultimap.Builder outputMappings = ImmutableMultimap.builder();
            outputMappings.putAll(probeSource.getLayout());
            int offset = probeSource.getTupleInfos().size();
            for (Map.Entry entry : buildSource.getLayout().entries()) {
                Input input = (Input)entry.getValue();
                outputMappings.put(entry.getKey(), (Object)new Input(offset + input.getChannel(), input.getField()));
            }
            HashJoinOperator.HashJoinOperatorFactory operator = this.createJoinOperator(node.getType(), hashSupplier, probeSource.getTupleInfos(), probeChannel, context);
            return new PhysicalOperation(operator, (Multimap<Symbol, Input>)outputMappings.build(), probeSource);
        }

        private HashJoinOperator.HashJoinOperatorFactory createJoinOperator(JoinNode.Type type, HashBuilderOperator.HashSupplier hashSupplier, List<TupleInfo> probeTupleInfos, int probeJoinChannel, LocalExecutionPlanContext context) {
            switch (type) {
                case INNER: {
                    return HashJoinOperator.innerJoin(context.getNextOperatorId(), hashSupplier, probeTupleInfos, probeJoinChannel);
                }
                case LEFT: 
                case RIGHT: {
                    return HashJoinOperator.outerJoin(context.getNextOperatorId(), hashSupplier, probeTupleInfos, probeJoinChannel);
                }
            }
            throw new UnsupportedOperationException("Unsupported join type: " + (Object)((Object)type));
        }

        @Override
        public PhysicalOperation visitSemiJoin(SemiJoinNode node, LocalExecutionPlanContext context) {
            PhysicalOperation probeSource = node.getSource().accept(this, context);
            probeSource = LocalExecutionPlanner.this.packIfNecessary((List)ImmutableList.of((Object)node.getSourceJoinSymbol()), probeSource, context.getTypes(), context);
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = node.getFilteringSource().accept(this, buildContext);
            buildSource = LocalExecutionPlanner.this.packIfNecessary((List)ImmutableList.of((Object)node.getFilteringSourceJoinSymbol()), buildSource, buildContext.getTypes(), buildContext);
            int probeChannel = (Integer)Iterables.getOnlyElement((Iterable)LocalExecutionPlanner.getChannelSetForSymbols((List)ImmutableList.of((Object)node.getSourceJoinSymbol()), (Multimap<Symbol, Input>)probeSource.getLayout()));
            int buildChannel = (Integer)Iterables.getOnlyElement((Iterable)LocalExecutionPlanner.getChannelSetForSymbols((List)ImmutableList.of((Object)node.getFilteringSourceJoinSymbol()), (Multimap<Symbol, Input>)buildSource.getLayout()));
            SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(buildContext.getNextOperatorId(), buildSource.getTupleInfos(), buildChannel, 100000);
            SetBuilderOperator.SetSupplier setProvider = setBuilderOperatorFactory.getSetProvider();
            DriverFactory buildDriverFactory = new DriverFactory(buildContext.isInputDriver(), false, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)buildSource.getOperatorFactories()).add((Object)setBuilderOperatorFactory).build());
            context.addDriverFactory(buildDriverFactory);
            ImmutableMultimap outputMappings = ImmutableMultimap.builder().putAll(probeSource.getLayout()).put((Object)node.getSemiJoinOutput(), (Object)new Input(probeSource.getLayout().size(), 0)).build();
            HashSemiJoinOperator.HashSemiJoinOperatorFactory operator = new HashSemiJoinOperator.HashSemiJoinOperatorFactory(context.getNextOperatorId(), setProvider, probeSource.getTupleInfos(), probeChannel);
            return new PhysicalOperation(operator, (Multimap<Symbol, Input>)outputMappings, probeSource);
        }

        @Override
        public PhysicalOperation visitSink(SinkNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            boolean projectionMatchesOutput = IterableTransformer.on(source.getLayout().entries()).orderBy(LocalExecutionPlanner.inputOrdering().onResultOf(MoreFunctions.valueGetter())).transform(MoreFunctions.keyGetter()).list().equals(node.getOutputSymbols());
            boolean hasMultiFieldChannels = IterableTransformer.on(source.getLayout().values()).transform(Input.fieldGetter()).any(Predicates.not((Predicate)Predicates.equalTo((Object)0)));
            if (hasMultiFieldChannels || !projectionMatchesOutput) {
                IdentityProjectionInfo mappings = LocalExecutionPlanner.computeIdentityMapping(node.getOutputSymbols(), (Multimap<Symbol, Input>)source.getLayout(), context.getTypes());
                FilterAndProjectOperator.FilterAndProjectOperatorFactory operatorFactory = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(context.getNextOperatorId(), FilterFunctions.TRUE_FUNCTION, mappings.getProjections());
                return new PhysicalOperation(operatorFactory, mappings.getOutputLayout(), source);
            }
            return source;
        }

        @Override
        public PhysicalOperation visitTableWriter(TableWriterNode node, LocalExecutionPlanContext context) {
            PhysicalOperation query = node.getSource().accept(this, context);
            ImmutableList.Builder columns = ImmutableList.builder();
            ImmutableList.Builder symbols = ImmutableList.builder();
            for (Map.Entry<Symbol, ColumnHandle> entry : node.getColumns().entrySet()) {
                symbols.add((Object)entry.getKey());
                columns.add((Object)entry.getValue());
            }
            IdentityProjectionInfo mappings = LocalExecutionPlanner.computeIdentityMapping((List)symbols.build(), (Multimap<Symbol, Input>)query.getLayout(), context.getTypes());
            FilterAndProjectOperator.FilterAndProjectOperatorFactory sourceOperator = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(context.getNextOperatorId(), FilterFunctions.TRUE_FUNCTION, mappings.getProjections());
            PhysicalOperation source = new PhysicalOperation(sourceOperator, mappings.getOutputLayout(), query);
            Symbol outputSymbol = (Symbol)Iterables.getOnlyElement(node.getOutputSymbols());
            TableWriterOperator.TableWriterOperatorFactory operator = new TableWriterOperator.TableWriterOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.storageManager, LocalExecutionPlanner.this.nodeInfo.getNodeId(), (List<ColumnHandle>)columns.build());
            return new PhysicalOperation(operator, (Multimap<Symbol, Input>)ImmutableMultimap.of((Object)outputSymbol, (Object)new Input(0, 0)), source);
        }

        @Override
        public PhysicalOperation visitUnion(UnionNode node, LocalExecutionPlanContext context) {
            List<TupleInfo> tupleInfos = this.getSourceOperatorTupleInfos(node, context.getTypes());
            InMemoryExchange inMemoryExchange = new InMemoryExchange(tupleInfos);
            for (int i = 0; i < node.getSources().size(); ++i) {
                PlanNode subplan = node.getSources().get(i);
                List<Symbol> expectedLayout = node.sourceOutputLayout(i);
                LocalExecutionPlanContext subContext = context.createSubContext();
                PhysicalOperation source = subplan.accept(this, subContext);
                ArrayList<OperatorFactory> operatorFactories = new ArrayList<OperatorFactory>(source.getOperatorFactories());
                boolean projectionMatchesOutput = IterableTransformer.on(source.getLayout().entries()).orderBy(LocalExecutionPlanner.inputOrdering().onResultOf(MoreFunctions.valueGetter())).transform(MoreFunctions.keyGetter()).list().equals(expectedLayout);
                if (!projectionMatchesOutput) {
                    IdentityProjectionInfo mappings = LocalExecutionPlanner.computeIdentityMapping(expectedLayout, (Multimap<Symbol, Input>)source.getLayout(), context.getTypes());
                    operatorFactories.add(new FilterAndProjectOperator.FilterAndProjectOperatorFactory(subContext.getNextOperatorId(), FilterFunctions.TRUE_FUNCTION, mappings.getProjections()));
                }
                operatorFactories.add(inMemoryExchange.createSinkFactory(subContext.getNextOperatorId()));
                DriverFactory driverFactory = new DriverFactory(subContext.isInputDriver(), false, operatorFactories);
                context.addDriverFactory(driverFactory);
            }
            inMemoryExchange.noMoreSinkFactories();
            context.setInputDriver(false);
            ImmutableMultimap.Builder outputMappings = ImmutableMultimap.builder();
            int channel = 0;
            for (Symbol symbol : node.getOutputSymbols()) {
                outputMappings.put((Object)symbol, (Object)new Input(channel, 0));
                ++channel;
            }
            return new PhysicalOperation(new InMemoryExchangeSourceOperator.InMemoryExchangeSourceOperatorFactory(context.getNextOperatorId(), inMemoryExchange), (Multimap<Symbol, Input>)outputMappings.build());
        }

        @Override
        protected PhysicalOperation visitPlan(PlanNode node, LocalExecutionPlanContext context) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        private List<TupleInfo> getSourceOperatorTupleInfos(PlanNode node, Map<Symbol, Type> types) {
            return ImmutableList.copyOf(IterableTransformer.on(node.getOutputSymbols()).transform(Functions.forMap(types)).transform(Type.toRaw()).transform(new Function<TupleInfo.Type, TupleInfo>(){

                public TupleInfo apply(TupleInfo.Type input) {
                    return new TupleInfo(input);
                }
            }).list());
        }

        private AggregationFunctionDefinition buildFunctionDefinition(PhysicalOperation source, FunctionHandle function, FunctionCall call) {
            ArrayList<Input> arguments = new ArrayList<Input>();
            for (Expression argument : call.getArguments()) {
                Symbol argumentSymbol = Symbol.fromQualifiedName(((QualifiedNameReference)argument).getName());
                arguments.add((Input)LocalExecutionPlanner.getFirst(source.getLayout().get((Object)argumentSymbol)));
            }
            return LocalExecutionPlanner.this.metadata.getFunction(function).bind(arguments);
        }

        private PhysicalOperation planGlobalAggregation(int operatorId, AggregationNode node, PhysicalOperation source) {
            int outputChannel = 0;
            ImmutableMultimap.Builder outputMappings = ImmutableMultimap.builder();
            ArrayList<AggregationFunctionDefinition> functionDefinitions = new ArrayList<AggregationFunctionDefinition>();
            for (Map.Entry<Symbol, FunctionCall> entry : node.getAggregations().entrySet()) {
                Symbol symbol = entry.getKey();
                functionDefinitions.add(this.buildFunctionDefinition(source, node.getFunctions().get(symbol), entry.getValue()));
                outputMappings.put((Object)symbol, (Object)new Input(outputChannel, 0));
                ++outputChannel;
            }
            AggregationOperator.AggregationOperatorFactory operatorFactory = new AggregationOperator.AggregationOperatorFactory(operatorId, node.getStep(), functionDefinitions);
            return new PhysicalOperation(operatorFactory, (Multimap<Symbol, Input>)outputMappings.build(), source);
        }

        private PhysicalOperation planGroupByAggregation(AggregationNode node, PhysicalOperation source, LocalExecutionPlanContext context) {
            List<Symbol> groupBySymbols = node.getGroupBy();
            source = LocalExecutionPlanner.this.packIfNecessary(groupBySymbols, source, context.getTypes(), context);
            ArrayList<Symbol> aggregationOutputSymbols = new ArrayList<Symbol>();
            ArrayList<AggregationFunctionDefinition> functionDefinitions = new ArrayList<AggregationFunctionDefinition>();
            for (Map.Entry<Symbol, FunctionCall> entry : node.getAggregations().entrySet()) {
                Symbol symbol = entry.getKey();
                functionDefinitions.add(this.buildFunctionDefinition(source, node.getFunctions().get(symbol), entry.getValue()));
                aggregationOutputSymbols.add(symbol);
            }
            ImmutableMultimap.Builder outputMappings = ImmutableMultimap.builder();
            for (Symbol symbol : groupBySymbols) {
                outputMappings.put((Object)symbol, (Object)new Input(0, ((Input)LocalExecutionPlanner.getFirst(source.getLayout().get((Object)symbol))).getField()));
            }
            int channel = 1;
            for (Symbol symbol : aggregationOutputSymbols) {
                outputMappings.put((Object)symbol, (Object)new Input(channel, 0));
                ++channel;
            }
            Integer groupByChannel = (Integer)Iterables.getOnlyElement((Iterable)LocalExecutionPlanner.getChannelSetForSymbols(groupBySymbols, (Multimap<Symbol, Input>)source.getLayout()));
            HashAggregationOperator.HashAggregationOperatorFactory operatorFactory = new HashAggregationOperator.HashAggregationOperatorFactory(context.getNextOperatorId(), source.getTupleInfos().get(groupByChannel), groupByChannel, node.getStep(), functionDefinitions, 10000);
            return new PhysicalOperation(operatorFactory, (Multimap<Symbol, Input>)outputMappings.build(), source);
        }
    }

    public static class LocalExecutionPlan {
        private final List<DriverFactory> driverFactories;

        public LocalExecutionPlan(List<DriverFactory> driverFactories) {
            this.driverFactories = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(driverFactories, (Object)"driverFactories is null")));
        }

        public List<DriverFactory> getDriverFactories() {
            return this.driverFactories;
        }
    }

    private static class LocalExecutionPlanContext {
        private final Session session;
        private final Map<Symbol, Type> types;
        private final List<DriverFactory> driverFactories;
        private int nextOperatorId;
        private boolean inputDriver = true;

        public LocalExecutionPlanContext(Session session, Map<Symbol, Type> types) {
            this(session, types, new ArrayList<DriverFactory>());
        }

        private LocalExecutionPlanContext(Session session, Map<Symbol, Type> types, List<DriverFactory> driverFactories) {
            this.session = session;
            this.types = types;
            this.driverFactories = driverFactories;
        }

        public void addDriverFactory(DriverFactory driverFactory) {
            this.driverFactories.add((DriverFactory)Preconditions.checkNotNull((Object)driverFactory, (Object)"driverFactory is null"));
        }

        private List<DriverFactory> getDriverFactories() {
            return ImmutableList.copyOf(this.driverFactories);
        }

        public Session getSession() {
            return this.session;
        }

        public Map<Symbol, Type> getTypes() {
            return this.types;
        }

        private int getNextOperatorId() {
            return this.nextOperatorId++;
        }

        private boolean isInputDriver() {
            return this.inputDriver;
        }

        private void setInputDriver(boolean inputDriver) {
            this.inputDriver = inputDriver;
        }

        public LocalExecutionPlanContext createSubContext() {
            return new LocalExecutionPlanContext(this.session, this.types, this.driverFactories);
        }
    }
}

