/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.DefaultExpressionTraversalVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;

public class DependencyExtractor {
    public static Set<Symbol> extractUnique(Expression expression) {
        return ImmutableSet.copyOf(DependencyExtractor.extractAll(expression));
    }

    public static List<Symbol> extractAll(Expression expression) {
        ImmutableList.Builder builder = ImmutableList.builder();
        new Visitor().process((Node)expression, builder);
        return builder.build();
    }

    private static class Visitor
    extends DefaultExpressionTraversalVisitor<Void, ImmutableList.Builder<Symbol>> {
        private Visitor() {
        }

        protected Void visitQualifiedNameReference(QualifiedNameReference node, ImmutableList.Builder<Symbol> builder) {
            builder.add((Object)Symbol.fromQualifiedName(node.getName()));
            return null;
        }
    }
}

