/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.OpCodes;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.control.LookupSwitch;
import com.facebook.presto.byteCode.instruction.Constant;
import com.facebook.presto.byteCode.instruction.JumpInstruction;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.gen.BootstrapFunctionBinder;
import com.facebook.presto.sql.gen.FunctionBinder;
import com.facebook.presto.sql.gen.FunctionBinding;
import com.facebook.presto.sql.gen.LikeFunctionBinder;
import com.facebook.presto.sql.gen.Operations;
import com.facebook.presto.sql.gen.SliceConstant;
import com.facebook.presto.sql.gen.TypedByteCodeNode;
import com.facebook.presto.sql.tree.ArithmeticExpression;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.CurrentTime;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Input;
import com.facebook.presto.sql.tree.InputReference;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.NegativeExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.tuple.TupleReadable;
import com.facebook.presto.util.IterableTransformer;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ByteCodeExpressionVisitor
extends AstVisitor<TypedByteCodeNode, CompilerContext> {
    private final BootstrapFunctionBinder bootstrapFunctionBinder;
    private final Map<Input, Type> inputTypes;
    private final ByteCodeNode getSessionByteCode;
    private final boolean sourceIsCursor;

    public ByteCodeExpressionVisitor(BootstrapFunctionBinder bootstrapFunctionBinder, Map<Input, Type> inputTypes, ByteCodeNode getSessionByteCode, boolean sourceIsCursor) {
        this.bootstrapFunctionBinder = bootstrapFunctionBinder;
        this.inputTypes = inputTypes;
        this.getSessionByteCode = getSessionByteCode;
        this.sourceIsCursor = sourceIsCursor;
    }

    protected TypedByteCodeNode visitBooleanLiteral(BooleanLiteral node, CompilerContext context) {
        return TypedByteCodeNode.typedByteCodeNode(Constant.loadBoolean(node.getValue()), Boolean.TYPE);
    }

    protected TypedByteCodeNode visitLongLiteral(LongLiteral node, CompilerContext context) {
        return TypedByteCodeNode.typedByteCodeNode(Constant.loadLong(node.getValue()), Long.TYPE);
    }

    protected TypedByteCodeNode visitDoubleLiteral(DoubleLiteral node, CompilerContext context) {
        return TypedByteCodeNode.typedByteCodeNode(Constant.loadDouble(node.getValue()), Double.TYPE);
    }

    protected TypedByteCodeNode visitStringLiteral(StringLiteral node, CompilerContext context) {
        return TypedByteCodeNode.typedByteCodeNode(SliceConstant.sliceConstant(node.getSlice()), Slice.class);
    }

    protected TypedByteCodeNode visitNullLiteral(NullLiteral node, CompilerContext context) {
        return TypedByteCodeNode.typedByteCodeNode(new Block(context).putVariable("wasNull", true), Void.TYPE);
    }

    public TypedByteCodeNode visitInputReference(InputReference node, CompilerContext context) {
        Input input = node.getInput();
        int channel = input.getChannel();
        Type type = this.inputTypes.get(input);
        Preconditions.checkState((type != null ? 1 : 0) != 0, (String)"No type for input %s", (Object[])new Object[]{input});
        if (this.sourceIsCursor) {
            Block isNullCheck = new Block(context).setDescription(String.format("cursor.get%s(%d)", new Object[]{type, channel})).getVariable("cursor").push(channel).invokeInterface(RecordCursor.class, "isNull", Boolean.TYPE, Integer.TYPE);
            switch (type) {
                case BOOLEAN: {
                    Block isNull = new Block(context).putVariable("wasNull", true).pushJavaDefault(Boolean.TYPE);
                    Block isNotNull = new Block(context).getVariable("cursor").push(channel).invokeInterface(RecordCursor.class, "getBoolean", Boolean.TYPE, Integer.TYPE);
                    return TypedByteCodeNode.typedByteCodeNode(new IfStatement(context, isNullCheck, isNull, isNotNull), Boolean.TYPE);
                }
                case BIGINT: {
                    Block isNull = new Block(context).putVariable("wasNull", true).pushJavaDefault(Long.TYPE);
                    Block isNotNull = new Block(context).getVariable("cursor").push(channel).invokeInterface(RecordCursor.class, "getLong", Long.TYPE, Integer.TYPE);
                    return TypedByteCodeNode.typedByteCodeNode(new IfStatement(context, isNullCheck, isNull, isNotNull), Long.TYPE);
                }
                case DOUBLE: {
                    Block isNull = new Block(context).putVariable("wasNull", true).pushJavaDefault(Double.TYPE);
                    Block isNotNull = new Block(context).getVariable("cursor").push(channel).invokeInterface(RecordCursor.class, "getDouble", Double.TYPE, Integer.TYPE);
                    return TypedByteCodeNode.typedByteCodeNode(new IfStatement(context, isNullCheck, isNull, isNotNull), Double.TYPE);
                }
                case VARCHAR: {
                    Block isNull = new Block(context).putVariable("wasNull", true).pushJavaDefault(Slice.class);
                    Block isNotNull = new Block(context).getVariable("cursor").push(channel).invokeInterface(RecordCursor.class, "getString", byte[].class, Integer.TYPE).invokeStatic(Slices.class, "wrappedBuffer", Slice.class, byte[].class);
                    return TypedByteCodeNode.typedByteCodeNode(new IfStatement(context, isNullCheck, isNull, isNotNull), Slice.class);
                }
            }
            throw new UnsupportedOperationException("not yet implemented: " + (Object)((Object)type));
        }
        int field = input.getField();
        Block isNullCheck = new Block(context).setDescription(String.format("channel_%d.get%s(%d)", new Object[]{channel, type, field})).getVariable("channel_" + channel).push(field).invokeInterface(TupleReadable.class, "isNull", Boolean.TYPE, Integer.TYPE);
        switch (type) {
            case BOOLEAN: {
                Block isNull = new Block(context).putVariable("wasNull", true).pushJavaDefault(Boolean.TYPE);
                Block isNotNull = new Block(context).getVariable("channel_" + channel).push(field).invokeInterface(TupleReadable.class, "getBoolean", Boolean.TYPE, Integer.TYPE);
                return TypedByteCodeNode.typedByteCodeNode(new IfStatement(context, isNullCheck, isNull, isNotNull), Boolean.TYPE);
            }
            case BIGINT: {
                Block isNull = new Block(context).putVariable("wasNull", true).pushJavaDefault(Long.TYPE);
                Block isNotNull = new Block(context).getVariable("channel_" + channel).push(field).invokeInterface(TupleReadable.class, "getLong", Long.TYPE, Integer.TYPE);
                return TypedByteCodeNode.typedByteCodeNode(new IfStatement(context, isNullCheck, isNull, isNotNull), Long.TYPE);
            }
            case DOUBLE: {
                Block isNull = new Block(context).putVariable("wasNull", true).pushJavaDefault(Double.TYPE);
                Block isNotNull = new Block(context).getVariable("channel_" + channel).push(field).invokeInterface(TupleReadable.class, "getDouble", Double.TYPE, Integer.TYPE);
                return TypedByteCodeNode.typedByteCodeNode(new IfStatement(context, isNullCheck, isNull, isNotNull), Double.TYPE);
            }
            case VARCHAR: {
                Block isNull = new Block(context).putVariable("wasNull", true).pushJavaDefault(Slice.class);
                Block isNotNull = new Block(context).getVariable("channel_" + channel).push(field).invokeInterface(TupleReadable.class, "getSlice", Slice.class, Integer.TYPE);
                return TypedByteCodeNode.typedByteCodeNode(new IfStatement(context, isNullCheck, isNull, isNotNull), Slice.class);
            }
        }
        throw new UnsupportedOperationException("not yet implemented: " + (Object)((Object)type));
    }

    protected TypedByteCodeNode visitCurrentTime(CurrentTime node, CompilerContext context) {
        return this.visitFunctionCall(new FunctionCall(new QualifiedName("now"), (List)ImmutableList.of()), context);
    }

    protected TypedByteCodeNode visitFunctionCall(FunctionCall node, CompilerContext context) {
        ArrayList<TypedByteCodeNode> arguments = new ArrayList<TypedByteCodeNode>();
        for (Expression argument : node.getArguments()) {
            TypedByteCodeNode typedByteCodeNode = (TypedByteCodeNode)this.process((Node)argument, context);
            if (typedByteCodeNode.getType() == Void.TYPE) {
                return typedByteCodeNode;
            }
            arguments.add(typedByteCodeNode);
        }
        FunctionBinding functionBinding = this.bootstrapFunctionBinder.bindFunction(node.getName(), this.getSessionByteCode, arguments);
        return this.visitFunctionBinding(context, functionBinding, node.toString());
    }

    protected TypedByteCodeNode visitExtract(Extract node, CompilerContext context) {
        TypedByteCodeNode expression = (TypedByteCodeNode)this.process((Node)node.getExpression(), context);
        if (expression.getType() == Void.TYPE) {
            return expression;
        }
        if (node.getField() == Extract.Field.TIMEZONE_HOUR || node.getField() == Extract.Field.TIMEZONE_MINUTE) {
            return TypedByteCodeNode.typedByteCodeNode(new Block(context).append(expression.getNode()).pop(Long.TYPE).push(0L), Long.TYPE);
        }
        QualifiedName functionName = QualifiedName.of((String)node.getField().name().toLowerCase(), (String[])new String[0]);
        FunctionBinding functionBinding = this.bootstrapFunctionBinder.bindFunction(functionName, this.getSessionByteCode, (List<TypedByteCodeNode>)ImmutableList.of((Object)expression));
        return this.visitFunctionBinding(context, functionBinding, node.toString());
    }

    protected TypedByteCodeNode visitLikePredicate(LikePredicate node, CompilerContext context) {
        ImmutableList expressions = node.getEscape() != null ? ImmutableList.of((Object)node.getValue(), (Object)node.getPattern(), (Object)node.getEscape()) : ImmutableList.of((Object)node.getValue(), (Object)node.getPattern());
        ArrayList<TypedByteCodeNode> arguments = new ArrayList<TypedByteCodeNode>();
        for (Expression argument : expressions) {
            TypedByteCodeNode typedByteCodeNode = (TypedByteCodeNode)this.process((Node)argument, context);
            if (typedByteCodeNode.getType() == Void.TYPE) {
                return typedByteCodeNode;
            }
            arguments.add(typedByteCodeNode);
        }
        FunctionBinding functionBinding = this.bootstrapFunctionBinder.bindFunction("like", this.getSessionByteCode, arguments, new LikeFunctionBinder());
        return this.visitFunctionBinding(context, functionBinding, node.toString());
    }

    private TypedByteCodeNode visitFunctionBinding(CompilerContext context, FunctionBinding functionBinding, String comment) {
        List<TypedByteCodeNode> arguments = functionBinding.getArguments();
        MethodType methodType = functionBinding.getCallSite().type();
        Class unboxedReturnType = Primitives.unwrap((Class)methodType.returnType());
        LabelNode end = new LabelNode("end");
        Block block = new Block(context).setDescription("invoke").comment(comment);
        ArrayList stackTypes = new ArrayList();
        for (int i = 0; i < arguments.size(); ++i) {
            TypedByteCodeNode argument = arguments.get(i);
            Class<?> argumentType = methodType.parameterList().get(i);
            block.append(this.coerceToType(context, argument, argumentType).getNode());
            stackTypes.add(argument.getType());
            block.append(this.ifWasNullPopAndGoto(context, end, unboxedReturnType, Lists.reverse(stackTypes)));
        }
        block.invokeDynamic(functionBinding.getName(), methodType, functionBinding.getBindingId());
        if (functionBinding.isNullable()) {
            if (unboxedReturnType.isPrimitive()) {
                LabelNode notNull = new LabelNode("notNull");
                block.dup((Class<?>)methodType.returnType()).ifNotNullGoto(notNull).putVariable("wasNull", true).comment("swap boxed null with unboxed default").pop((Class<?>)methodType.returnType()).pushJavaDefault(unboxedReturnType).gotoLabel(end).visitLabel(notNull).append(ByteCodeExpressionVisitor.unboxPrimitive(context, unboxedReturnType));
            } else {
                block.dup((Class<?>)methodType.returnType()).ifNotNullGoto(end).putVariable("wasNull", true);
            }
        }
        block.visitLabel(end);
        return TypedByteCodeNode.typedByteCodeNode(block, unboxedReturnType);
    }

    private static ByteCodeNode unboxPrimitive(CompilerContext context, Class<?> unboxedType) {
        Block block = new Block(context).comment("unbox primitive");
        if (unboxedType == Long.TYPE) {
            return block.invokeVirtual(Long.class, "longValue", Long.TYPE, new Class[0]);
        }
        if (unboxedType == Double.TYPE) {
            return block.invokeVirtual(Double.class, "doubleValue", Double.TYPE, new Class[0]);
        }
        if (unboxedType == Boolean.TYPE) {
            return block.invokeVirtual(Boolean.class, "booleanValue", Boolean.TYPE, new Class[0]);
        }
        throw new UnsupportedOperationException("not yet implemented: " + unboxedType);
    }

    public TypedByteCodeNode visitCast(Cast node, CompilerContext context) {
        TypedByteCodeNode value = (TypedByteCodeNode)this.process((Node)node.getExpression(), context);
        Block block = new Block(context).comment(node.toString());
        block.append(value.getNode());
        if (value.getType() == Void.TYPE) {
            switch (node.getType()) {
                case "BOOLEAN": {
                    block.pushJavaDefault(Boolean.TYPE);
                    return TypedByteCodeNode.typedByteCodeNode(block, Boolean.TYPE);
                }
                case "BIGINT": {
                    block.pushJavaDefault(Long.TYPE);
                    return TypedByteCodeNode.typedByteCodeNode(block, Long.TYPE);
                }
                case "DOUBLE": {
                    block.pushJavaDefault(Double.TYPE);
                    return TypedByteCodeNode.typedByteCodeNode(block, Double.TYPE);
                }
                case "VARCHAR": {
                    block.pushJavaDefault(Slice.class);
                    return TypedByteCodeNode.typedByteCodeNode(block, Slice.class);
                }
            }
        } else {
            LabelNode end = new LabelNode("end");
            switch (node.getType()) {
                case "BOOLEAN": {
                    block.append(this.ifWasNullPopAndGoto(context, end, Boolean.TYPE, value.getType()));
                    block.invokeStatic(Operations.class, "castToBoolean", Boolean.TYPE, value.getType());
                    return TypedByteCodeNode.typedByteCodeNode(block.visitLabel(end), Boolean.TYPE);
                }
                case "BIGINT": {
                    block.append(this.ifWasNullPopAndGoto(context, end, Long.TYPE, value.getType()));
                    block.invokeStatic(Operations.class, "castToLong", Long.TYPE, value.getType());
                    return TypedByteCodeNode.typedByteCodeNode(block.visitLabel(end), Long.TYPE);
                }
                case "DOUBLE": {
                    block.append(this.ifWasNullPopAndGoto(context, end, Double.TYPE, value.getType()));
                    block.invokeStatic(Operations.class, "castToDouble", Double.TYPE, value.getType());
                    return TypedByteCodeNode.typedByteCodeNode(block.visitLabel(end), Double.TYPE);
                }
                case "VARCHAR": {
                    block.append(this.ifWasNullPopAndGoto(context, end, Slice.class, value.getType()));
                    block.invokeStatic(Operations.class, "castToSlice", Slice.class, value.getType());
                    return TypedByteCodeNode.typedByteCodeNode(block.visitLabel(end), Slice.class);
                }
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + node.getType());
    }

    protected TypedByteCodeNode visitArithmeticExpression(ArithmeticExpression node, CompilerContext context) {
        TypedByteCodeNode left = (TypedByteCodeNode)this.process((Node)node.getLeft(), context);
        if (left.getType() == Void.TYPE) {
            return left;
        }
        TypedByteCodeNode right = (TypedByteCodeNode)this.process((Node)node.getRight(), context);
        if (right.getType() == Void.TYPE) {
            return right;
        }
        Class<?> type = this.getType(left, right);
        if (!ByteCodeExpressionVisitor.isNumber(type)) {
            throw new UnsupportedOperationException(String.format("not yet implemented: %s(%s, %s)", node.getType(), left.getType(), right.getType()));
        }
        Block block = new Block(context).comment(node.toString());
        LabelNode end = new LabelNode("end");
        block.append(this.coerceToType(context, left, type).getNode());
        block.append(this.ifWasNullPopAndGoto(context, end, type, left.getType()));
        block.append(this.coerceToType(context, right, type).getNode());
        block.append(this.ifWasNullPopAndGoto(context, end, type, type, right.getType()));
        switch (node.getType()) {
            case ADD: {
                block.invokeStatic(Operations.class, "add", type, type, type);
                break;
            }
            case SUBTRACT: {
                block.invokeStatic(Operations.class, "subtract", type, type, type);
                break;
            }
            case MULTIPLY: {
                block.invokeStatic(Operations.class, "multiply", type, type, type);
                break;
            }
            case DIVIDE: {
                block.invokeStatic(Operations.class, "divide", type, type, type);
                break;
            }
            case MODULUS: {
                block.invokeStatic(Operations.class, "modulus", type, type, type);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("not yet implemented: %s(%s, %s)", node.getType(), left.getType(), right.getType()));
            }
        }
        return TypedByteCodeNode.typedByteCodeNode(block.visitLabel(end), type);
    }

    protected TypedByteCodeNode visitNegativeExpression(NegativeExpression node, CompilerContext context) {
        TypedByteCodeNode value = (TypedByteCodeNode)this.process((Node)node.getValue(), context);
        if (value.getType() == Void.TYPE) {
            return value;
        }
        if (!ByteCodeExpressionVisitor.isNumber(value.getType())) {
            throw new UnsupportedOperationException(String.format("not yet implemented: negate(%s)", value.getType()));
        }
        Block block = new Block(context).comment(node.toString()).append(value.getNode()).invokeStatic(Operations.class, "negate", value.getType(), value.getType());
        return TypedByteCodeNode.typedByteCodeNode(block, value.getType());
    }

    protected TypedByteCodeNode visitLogicalBinaryExpression(LogicalBinaryExpression node, CompilerContext context) {
        TypedByteCodeNode left = (TypedByteCodeNode)this.process((Node)node.getLeft(), context);
        if (left.getType() == Void.TYPE) {
            left = this.coerceToType(context, left, Boolean.TYPE);
        }
        Preconditions.checkState((left.getType() == Boolean.TYPE ? 1 : 0) != 0, (String)"Expected logical binary expression left value to be a boolean but is a %s: %s", (Object[])new Object[]{left.getType().getName(), node});
        TypedByteCodeNode right = (TypedByteCodeNode)this.process((Node)node.getRight(), context);
        if (right.getType() == Void.TYPE) {
            right = this.coerceToType(context, right, Boolean.TYPE);
        }
        Preconditions.checkState((right.getType() == Boolean.TYPE ? 1 : 0) != 0, (String)"Expected logical binary expression right value to be a boolean but is a %s: %s", (Object[])new Object[]{right.getType().getName(), node});
        switch (node.getType()) {
            case AND: {
                return this.visitAnd(context, left, right, node.toString());
            }
            case OR: {
                return this.visitOr(context, left, right, node.toString());
            }
        }
        throw new UnsupportedOperationException(String.format("not yet implemented: %s(%s, %s)", node.getType(), left.getType(), right.getType()));
    }

    private TypedByteCodeNode visitAnd(CompilerContext context, TypedByteCodeNode left, TypedByteCodeNode right, String comment) {
        Block block = new Block(context).comment(comment).setDescription("AND");
        block.append(left.getNode());
        IfStatement.IfStatementBuilder ifLeftIsNull = IfStatement.ifStatementBuilder(context).comment("if left wasNull...", new Object[0]).condition(new Block(context).getVariable("wasNull"));
        LabelNode end = new LabelNode("end");
        ifLeftIsNull.ifTrue(new Block(context).comment("clear the null flag, pop left value off stack, and push left null flag on the stack (true)").putVariable("wasNull", false).pop(left.getType()).push(true));
        LabelNode leftIsTrue = new LabelNode("leftIsTrue");
        ifLeftIsNull.ifFalse(new Block(context).comment("if left is false, push false, and goto end").ifTrueGoto(leftIsTrue).push(false).gotoLabel(end).comment("left was true; push left null flag on the stack (false)").visitLabel(leftIsTrue).push(false));
        block.append(ifLeftIsNull.build());
        block.append(right.getNode());
        IfStatement.IfStatementBuilder ifRightIsNull = IfStatement.ifStatementBuilder(context).comment("if right wasNull...", new Object[0]).condition(new Block(context).getVariable("wasNull"));
        ifRightIsNull.ifTrue(new Block(context).comment("right was null, pop the right value off the stack; wasNull flag remains set to TRUE").pop(right.getType()));
        LabelNode rightIsTrue = new LabelNode("rightIsTrue");
        ifRightIsNull.ifFalse(new Block(context).comment("if right is false, pop left null flag off stack, push false and goto end").ifTrueGoto(rightIsTrue).pop(Boolean.TYPE).push(false).gotoLabel(end).comment("right was true; store left null flag (on stack) in wasNull variable, and push true").visitLabel(rightIsTrue).putVariable("wasNull").push(true));
        block.append(ifRightIsNull.build()).visitLabel(end);
        return TypedByteCodeNode.typedByteCodeNode(block, Boolean.TYPE);
    }

    private TypedByteCodeNode visitOr(CompilerContext context, TypedByteCodeNode left, TypedByteCodeNode right, String comment) {
        Block block = new Block(context).comment(comment).setDescription("OR");
        block.append(left.getNode());
        IfStatement.IfStatementBuilder ifLeftIsNull = IfStatement.ifStatementBuilder(context).comment("if left wasNull...", new Object[0]).condition(new Block(context).getVariable("wasNull"));
        LabelNode end = new LabelNode("end");
        ifLeftIsNull.ifTrue(new Block(context).comment("clear the null flag, pop left value off stack, and push left null flag on the stack (true)").putVariable("wasNull", false).pop(left.getType()).push(true));
        LabelNode leftIsFalse = new LabelNode("leftIsFalse");
        ifLeftIsNull.ifFalse(new Block(context).comment("if left is true, push true, and goto end").ifFalseGoto(leftIsFalse).push(true).gotoLabel(end).comment("left was false; push left null flag on the stack (false)").visitLabel(leftIsFalse).push(false));
        block.append(ifLeftIsNull.build());
        block.append(right.getNode());
        IfStatement.IfStatementBuilder ifRightIsNull = IfStatement.ifStatementBuilder(context).comment("if right wasNull...", new Object[0]).condition(new Block(context).getVariable("wasNull"));
        ifRightIsNull.ifTrue(new Block(context).comment("right was null, pop the right value off the stack; wasNull flag remains set to TRUE").pop(right.getType()));
        LabelNode rightIsTrue = new LabelNode("rightIsTrue");
        ifRightIsNull.ifFalse(new Block(context).comment("if right is true, pop left null flag off stack, push true and goto end").ifFalseGoto(rightIsTrue).pop(Boolean.TYPE).push(true).gotoLabel(end).comment("right was false; store left null flag (on stack) in wasNull variable, and push false").visitLabel(rightIsTrue).putVariable("wasNull").push(false));
        block.append(ifRightIsNull.build()).visitLabel(end);
        return TypedByteCodeNode.typedByteCodeNode(block, Boolean.TYPE);
    }

    protected TypedByteCodeNode visitNotExpression(NotExpression node, CompilerContext context) {
        TypedByteCodeNode value = (TypedByteCodeNode)this.process((Node)node.getValue(), context);
        if (value.getType() == Void.TYPE) {
            return value;
        }
        Preconditions.checkState((value.getType() == Boolean.TYPE ? 1 : 0) != 0);
        return TypedByteCodeNode.typedByteCodeNode(new Block(context).comment(node.toString()).append(value.getNode()).invokeStatic(Operations.class, "not", Boolean.TYPE, Boolean.TYPE), Boolean.TYPE);
    }

    protected TypedByteCodeNode visitComparisonExpression(ComparisonExpression node, CompilerContext context) {
        String function;
        if (node.getType() == ComparisonExpression.Type.IS_DISTINCT_FROM) {
            return this.visitIsDistinctFrom(node, context);
        }
        TypedByteCodeNode left = (TypedByteCodeNode)this.process((Node)node.getLeft(), context);
        if (left.getType() == Void.TYPE) {
            return left;
        }
        TypedByteCodeNode right = (TypedByteCodeNode)this.process((Node)node.getRight(), context);
        if (right.getType() == Void.TYPE) {
            return right;
        }
        Class<?> type = this.getType(left, right);
        switch (node.getType()) {
            case EQUAL: {
                function = "equal";
                break;
            }
            case NOT_EQUAL: {
                function = "notEqual";
                break;
            }
            case LESS_THAN: {
                Preconditions.checkArgument((type != Boolean.TYPE ? 1 : 0) != 0, (String)"not yet implemented: %s(%s, %s)", (Object[])new Object[]{node.getType(), left.getType(), right.getType()});
                function = "lessThan";
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                Preconditions.checkArgument((type != Boolean.TYPE ? 1 : 0) != 0, (String)"not yet implemented: %s(%s, %s)", (Object[])new Object[]{node.getType(), left.getType(), right.getType()});
                function = "lessThanOrEqual";
                break;
            }
            case GREATER_THAN: {
                Preconditions.checkArgument((type != Boolean.TYPE ? 1 : 0) != 0, (String)"not yet implemented: %s(%s, %s)", (Object[])new Object[]{node.getType(), left.getType(), right.getType()});
                function = "greaterThan";
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                Preconditions.checkArgument((type != Boolean.TYPE ? 1 : 0) != 0, (String)"not yet implemented: %s(%s, %s)", (Object[])new Object[]{node.getType(), left.getType(), right.getType()});
                function = "greaterThanOrEqual";
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("not yet implemented: %s(%s, %s)", node.getType(), left.getType(), right.getType()));
            }
        }
        LabelNode end = new LabelNode("end");
        Block block = new Block(context).comment(node.toString());
        block.append(this.coerceToType(context, left, type).getNode());
        block.append(this.ifWasNullPopAndGoto(context, end, Boolean.TYPE, left.getType()));
        block.append(this.coerceToType(context, right, type).getNode());
        block.append(this.ifWasNullPopAndGoto(context, end, Boolean.TYPE, type, right.getType()));
        block.invokeStatic(Operations.class, function, Boolean.TYPE, type, type);
        return TypedByteCodeNode.typedByteCodeNode(block.visitLabel(end), Boolean.TYPE);
    }

    private TypedByteCodeNode visitIsDistinctFrom(ComparisonExpression node, CompilerContext context) {
        TypedByteCodeNode left = (TypedByteCodeNode)this.process((Node)node.getLeft(), context);
        TypedByteCodeNode right = (TypedByteCodeNode)this.process((Node)node.getRight(), context);
        Class<?> type = this.getType(left, right);
        if (type == Void.TYPE) {
            return TypedByteCodeNode.typedByteCodeNode(Constant.loadBoolean(false), Boolean.TYPE);
        }
        Block block = new Block(context).comment(node.toString()).comment("left").append(this.coerceToType(context, left, type).getNode()).getVariable("wasNull").comment("clear was null").putVariable("wasNull", false).comment("right").append(this.coerceToType(context, right, type).getNode()).getVariable("wasNull").comment("clear was null").putVariable("wasNull", false).invokeStatic(Operations.class, "isDistinctFrom", Boolean.TYPE, type, Boolean.TYPE, type, Boolean.TYPE);
        return TypedByteCodeNode.typedByteCodeNode(block, Boolean.TYPE);
    }

    protected TypedByteCodeNode visitBetweenPredicate(BetweenPredicate node, CompilerContext context) {
        TypedByteCodeNode value = (TypedByteCodeNode)this.process((Node)node.getValue(), context);
        if (value.getType() == Void.TYPE) {
            return value;
        }
        TypedByteCodeNode min = (TypedByteCodeNode)this.process((Node)node.getMin(), context);
        if (min.getType() == Void.TYPE) {
            return min;
        }
        TypedByteCodeNode max = (TypedByteCodeNode)this.process((Node)node.getMax(), context);
        if (max.getType() == Void.TYPE) {
            return max;
        }
        Class<?> type = this.getType(value, min, max);
        LabelNode end = new LabelNode("end");
        Block block = new Block(context).comment(node.toString());
        block.append(this.coerceToType(context, value, type).getNode());
        block.append(this.ifWasNullPopAndGoto(context, end, Boolean.TYPE, type));
        block.append(this.coerceToType(context, min, type).getNode());
        block.append(this.ifWasNullPopAndGoto(context, end, Boolean.TYPE, type, type));
        block.append(this.coerceToType(context, max, type).getNode());
        block.append(this.ifWasNullPopAndGoto(context, end, Boolean.TYPE, type, type, type));
        block.invokeStatic(Operations.class, "between", Boolean.TYPE, type, type, type);
        return TypedByteCodeNode.typedByteCodeNode(block.visitLabel(end), Boolean.TYPE);
    }

    protected TypedByteCodeNode visitIsNotNullPredicate(IsNotNullPredicate node, CompilerContext context) {
        TypedByteCodeNode value = (TypedByteCodeNode)this.process((Node)node.getValue(), context);
        if (value.getType() == Void.TYPE) {
            return TypedByteCodeNode.typedByteCodeNode(Constant.loadBoolean(false), Boolean.TYPE);
        }
        Block block = new Block(context).comment(node.toString()).append(value.getNode()).pop(value.getType()).getVariable("wasNull").invokeStatic(Operations.class, "not", Boolean.TYPE, Boolean.TYPE);
        block.putVariable("wasNull", false);
        return TypedByteCodeNode.typedByteCodeNode(block, Boolean.TYPE);
    }

    protected TypedByteCodeNode visitIsNullPredicate(IsNullPredicate node, CompilerContext context) {
        TypedByteCodeNode value = (TypedByteCodeNode)this.process((Node)node.getValue(), context);
        if (value.getType() == Void.TYPE) {
            return TypedByteCodeNode.typedByteCodeNode(Constant.loadBoolean(true), Boolean.TYPE);
        }
        Block block = new Block(context).comment(node.toString()).append(value.getNode()).pop(value.getType()).getVariable("wasNull");
        block.putVariable("wasNull", false);
        return TypedByteCodeNode.typedByteCodeNode(block, Boolean.TYPE);
    }

    protected TypedByteCodeNode visitIfExpression(IfExpression node, CompilerContext context) {
        TypedByteCodeNode conditionValue = (TypedByteCodeNode)this.process((Node)node.getCondition(), context);
        TypedByteCodeNode trueValue = (TypedByteCodeNode)this.process((Node)node.getTrueValue(), context);
        TypedByteCodeNode falseValue = (TypedByteCodeNode)this.process((Node)node.getFalseValue().or((Object)new NullLiteral()), context);
        if (conditionValue.getType() == Void.TYPE) {
            return falseValue;
        }
        Preconditions.checkState((conditionValue.getType() == Boolean.TYPE ? 1 : 0) != 0);
        Block condition = new Block(context).comment(node.toString()).append(conditionValue.getNode()).comment("... and condition value was not null").getVariable("wasNull").invokeStatic(Operations.class, "not", Boolean.TYPE, Boolean.TYPE).invokeStatic(Operations.class, "and", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE).putVariable("wasNull", false);
        Class<?> type = this.getType(trueValue, falseValue);
        if (type == Void.TYPE) {
            return trueValue;
        }
        trueValue = this.coerceToType(context, trueValue, type);
        falseValue = this.coerceToType(context, falseValue, type);
        return TypedByteCodeNode.typedByteCodeNode(new IfStatement(context, condition, trueValue.getNode(), falseValue.getNode()), type);
    }

    protected TypedByteCodeNode visitSearchedCaseExpression(SearchedCaseExpression node, final CompilerContext context) {
        TypedByteCodeNode elseValue = node.getDefaultValue() != null ? (TypedByteCodeNode)this.process((Node)node.getDefaultValue(), context) : (TypedByteCodeNode)this.process((Node)new NullLiteral(), context);
        ImmutableList whenClauses = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)node.getWhenClauses(), (Function)new Function<WhenClause, TypedWhenClause>(){

            public TypedWhenClause apply(WhenClause whenClause) {
                return new TypedWhenClause(context, whenClause);
            }
        }));
        Class<?> type = this.getType((Iterable<TypedByteCodeNode>)ImmutableList.builder().addAll(Iterables.transform((Iterable)whenClauses, ByteCodeExpressionVisitor.whenValueGetter())).add((Object)elseValue).build());
        elseValue = this.coerceToType(context, elseValue, type);
        for (TypedWhenClause whenClause : Lists.reverse(new ArrayList(whenClauses))) {
            if (whenClause.condition.getType() == Void.TYPE) continue;
            Preconditions.checkState((whenClause.condition.getType() == Boolean.TYPE ? 1 : 0) != 0);
            Block condition = new Block(context).append(whenClause.condition.getNode()).comment("... and condition value was not null").getVariable("wasNull").invokeStatic(Operations.class, "not", Boolean.TYPE, Boolean.TYPE).invokeStatic(Operations.class, "and", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE).putVariable("wasNull", false);
            elseValue = TypedByteCodeNode.typedByteCodeNode(new IfStatement(context, condition, this.coerceToType(context, whenClause.value, type).getNode(), elseValue.getNode()), type);
        }
        return elseValue;
    }

    protected TypedByteCodeNode visitSimpleCaseExpression(SimpleCaseExpression node, final CompilerContext context) {
        TypedByteCodeNode value = (TypedByteCodeNode)this.process((Node)node.getOperand(), context);
        TypedByteCodeNode elseValue = node.getDefaultValue() != null ? (TypedByteCodeNode)this.process((Node)node.getDefaultValue(), context) : (TypedByteCodeNode)this.process((Node)new NullLiteral(), context);
        ImmutableList whenClauses = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)node.getWhenClauses(), (Function)new Function<WhenClause, TypedWhenClause>(){

            public TypedWhenClause apply(WhenClause whenClause) {
                return new TypedWhenClause(context, whenClause);
            }
        }));
        Class<?> valueType = this.getType((Iterable<TypedByteCodeNode>)ImmutableList.builder().addAll(Iterables.transform((Iterable)whenClauses, ByteCodeExpressionVisitor.whenConditionGetter())).add((Object)value).build());
        Class<?> resultType = this.getType((Iterable<TypedByteCodeNode>)ImmutableList.builder().addAll(Iterables.transform((Iterable)whenClauses, ByteCodeExpressionVisitor.whenValueGetter())).add((Object)elseValue).build());
        if (value.getType() == Void.TYPE) {
            return this.coerceToType(context, elseValue, resultType);
        }
        LabelNode nullValue = new LabelNode("nullCondition");
        Variable tempVariable = context.createTempVariable(valueType);
        Block block = new Block(context).append(this.coerceToType(context, value, valueType).getNode()).append(this.ifWasNullClearPopAndGoto(context, nullValue, Void.TYPE, valueType)).putVariable(tempVariable.getLocalVariableDefinition());
        elseValue = TypedByteCodeNode.typedByteCodeNode(new Block(context).visitLabel(nullValue).append(this.coerceToType(context, elseValue, resultType).getNode()), resultType);
        for (TypedWhenClause whenClause : Lists.reverse(new ArrayList(whenClauses))) {
            LabelNode nullCondition = new LabelNode("nullCondition");
            Block condition = new Block(context).append(this.coerceToType(context, whenClause.condition, valueType).getNode()).append(this.ifWasNullPopAndGoto(context, nullCondition, Boolean.TYPE, valueType)).getVariable(tempVariable.getLocalVariableDefinition()).invokeStatic(Operations.class, "equal", Boolean.TYPE, valueType, valueType).visitLabel(nullCondition).putVariable("wasNull", false);
            elseValue = TypedByteCodeNode.typedByteCodeNode(new IfStatement(context, String.format("when %s", whenClause), condition, this.coerceToType(context, whenClause.value, resultType).getNode(), elseValue.getNode()), resultType);
        }
        return TypedByteCodeNode.typedByteCodeNode(block.append(elseValue.getNode()), resultType);
    }

    protected TypedByteCodeNode visitNullIfExpression(NullIfExpression node, CompilerContext context) {
        TypedByteCodeNode first = (TypedByteCodeNode)this.process((Node)node.getFirst(), context);
        TypedByteCodeNode second = (TypedByteCodeNode)this.process((Node)node.getSecond(), context);
        if (first.getType() == Void.TYPE) {
            return first;
        }
        Class<?> comparisonType = this.getType(first, second);
        LabelNode notMatch = new LabelNode("notMatch");
        Block block = new Block(context).comment(node.toString()).append(first.getNode()).append(this.ifWasNullPopAndGoto(context, notMatch, Void.TYPE, new Class[0])).append(this.coerceToType(context, TypedByteCodeNode.typedByteCodeNode(new Block(context).dup(first.getType()), first.getType()), comparisonType).getNode()).append(this.coerceToType(context, second, comparisonType).getNode()).append(this.ifWasNullClearPopAndGoto(context, notMatch, Void.TYPE, comparisonType, comparisonType));
        Block conditionBlock = new Block(context).invokeStatic(Operations.class, "equal", Boolean.TYPE, comparisonType, comparisonType);
        Block trueBlock = new Block(context).putVariable("wasNull", true).pop(first.getType()).pushJavaDefault(first.getType());
        block.append(new IfStatement(context, conditionBlock, trueBlock, notMatch));
        return TypedByteCodeNode.typedByteCodeNode(block, first.getType());
    }

    protected TypedByteCodeNode visitCoalesceExpression(CoalesceExpression node, CompilerContext context) {
        ArrayList<TypedByteCodeNode> operands = new ArrayList<TypedByteCodeNode>();
        for (Expression expression : node.getOperands()) {
            operands.add((TypedByteCodeNode)this.process((Node)expression, context));
        }
        Class<?> type = this.getType(operands);
        TypedByteCodeNode nullValue = this.coerceToType(context, (TypedByteCodeNode)this.process((Node)new NullLiteral(), context), type);
        for (TypedByteCodeNode operand : Lists.reverse(operands)) {
            Block condition = new Block(context).append(this.coerceToType(context, operand, type).getNode()).getVariable("wasNull");
            Block nullBlock = new Block(context).pop(type).putVariable("wasNull", false).append(nullValue.getNode());
            nullValue = TypedByteCodeNode.typedByteCodeNode(new IfStatement(context, condition, nullBlock, OpCodes.NOP), type);
        }
        return TypedByteCodeNode.typedByteCodeNode(nullValue.getNode(), type);
    }

    protected TypedByteCodeNode visitInPredicate(InPredicate node, CompilerContext context) {
        Block switchBlock;
        Expression valueListExpression = node.getValueList();
        if (!(valueListExpression instanceof InListExpression)) {
            throw new UnsupportedOperationException("Compilation of IN subquery is not supported yet");
        }
        TypedByteCodeNode value = (TypedByteCodeNode)this.process((Node)node.getValue(), context);
        if (value.getType() == Void.TYPE) {
            return value;
        }
        ImmutableList.Builder values = ImmutableList.builder();
        InListExpression valueList = (InListExpression)valueListExpression;
        for (Expression test : valueList.getValues()) {
            TypedByteCodeNode testNode = (TypedByteCodeNode)this.process((Node)test, context);
            values.add((Object)testNode);
        }
        Class<?> type = this.getType((Iterable<TypedByteCodeNode>)ImmutableList.builder().add((Object)value).addAll((Iterable)values.build()).build());
        ImmutableListMultimap.Builder hashBucketsBuilder = ImmutableListMultimap.builder();
        ImmutableList.Builder defaultBucket = ImmutableList.builder();
        ImmutableSet.Builder constantValuesBuilder = ImmutableSet.builder();
        for (TypedByteCodeNode testNode : values.build()) {
            if (testNode.getNode() instanceof Constant) {
                int hashCode;
                Constant constant = (Constant)testNode.getNode();
                Object testValue = constant.getValue();
                constantValuesBuilder.add(testValue);
                if (type == Boolean.TYPE) {
                    hashCode = Operations.hashCode(((Number)testValue).intValue() != 0);
                } else if (type == Long.TYPE) {
                    hashCode = Operations.hashCode((Long)testValue);
                } else if (type == Double.TYPE) {
                    hashCode = Operations.hashCode(((Number)testValue).doubleValue());
                } else if (type == Slice.class) {
                    hashCode = Operations.hashCode((Slice)testValue);
                } else {
                    throw new IllegalStateException("Error processing in statement: unsupported type " + testValue.getClass().getSimpleName());
                }
                hashBucketsBuilder.put((Object)hashCode, (Object)this.coerceToType(context, testNode, type));
                continue;
            }
            defaultBucket.add((Object)this.coerceToType(context, testNode, type));
        }
        ImmutableListMultimap hashBuckets = hashBucketsBuilder.build();
        ImmutableSet constantValues = constantValuesBuilder.build();
        LabelNode end = new LabelNode("end");
        LabelNode match = new LabelNode("match");
        LabelNode noMatch = new LabelNode("noMatch");
        LabelNode defaultLabel = new LabelNode("default");
        if (constantValues.size() < 1000) {
            Block switchCaseBlocks = new Block(context);
            LookupSwitch.LookupSwitchBuilder switchBuilder = LookupSwitch.lookupSwitchBuilder();
            for (Map.Entry bucket : hashBuckets.asMap().entrySet()) {
                LabelNode label = new LabelNode("inHash" + bucket.getKey());
                switchBuilder.addCase((Integer)bucket.getKey(), label);
                Collection testValues = (Collection)bucket.getValue();
                Block caseBlock = this.buildInCase(context, type, label, match, defaultLabel, testValues, false);
                switchCaseBlocks.append(caseBlock.setDescription("case " + bucket.getKey()));
            }
            switchBuilder.defaultCase(defaultLabel);
            switchBlock = new Block(context).comment("lookupSwitch(hashCode(<stackValue>))").dup(type).invokeStatic(Operations.class, "hashCode", Integer.TYPE, type).append(switchBuilder.build()).append(switchCaseBlocks);
        } else {
            FunctionBinding functionBinding = this.bootstrapFunctionBinder.bindFunction("in", this.getSessionByteCode, (List<TypedByteCodeNode>)ImmutableList.of(), new InFunctionBinder(type, (ImmutableSet<Object>)constantValues));
            switchBlock = new Block(context).comment("inListSet.contains(<stackValue>)").append(new IfStatement(context, new Block(context).dup(type).invokeDynamic(functionBinding.getName(), functionBinding.getCallSite().type(), functionBinding.getBindingId()), JumpInstruction.jump(match), OpCodes.NOP));
        }
        Block defaultCaseBlock = this.buildInCase(context, type, defaultLabel, match, noMatch, (Collection<TypedByteCodeNode>)defaultBucket.build(), true).setDescription("default");
        Block block = new Block(context).comment(node.toString()).append(this.coerceToType(context, value, type).getNode()).append(this.ifWasNullPopAndGoto(context, end, Boolean.TYPE, type)).append(switchBlock).append(defaultCaseBlock);
        Block matchBlock = new Block(context).setDescription("match").visitLabel(match).pop(type).putVariable("wasNull", false).push(true).gotoLabel(end);
        block.append(matchBlock);
        Block noMatchBlock = new Block(context).setDescription("noMatch").visitLabel(noMatch).pop(type).push(false).gotoLabel(end);
        block.append(noMatchBlock);
        block.visitLabel(end);
        return TypedByteCodeNode.typedByteCodeNode(block, Boolean.TYPE);
    }

    private Block buildInCase(CompilerContext context, Class<?> type, LabelNode caseLabel, LabelNode matchLabel, LabelNode noMatchLabel, Collection<TypedByteCodeNode> testValues, boolean checkForNulls) {
        Variable caseWasNull = null;
        if (checkForNulls) {
            caseWasNull = context.createTempVariable(Boolean.TYPE);
        }
        Block caseBlock = new Block(context).visitLabel(caseLabel);
        if (checkForNulls) {
            caseBlock.putVariable(caseWasNull.getLocalVariableDefinition(), false);
        }
        LabelNode elseLabel = new LabelNode("else");
        Block elseBlock = new Block(context).visitLabel(elseLabel);
        if (checkForNulls) {
            elseBlock.getVariable(caseWasNull.getLocalVariableDefinition()).putVariable("wasNull");
        }
        elseBlock.gotoLabel(noMatchLabel);
        ByteCodeNode elseNode = elseBlock;
        for (TypedByteCodeNode testNode : testValues) {
            LabelNode testLabel = new LabelNode("test");
            IfStatement.IfStatementBuilder test = IfStatement.ifStatementBuilder(context);
            Block condition = new Block(context).visitLabel(testLabel).dup(type).append(this.coerceToType(context, testNode, type).getNode());
            if (checkForNulls) {
                condition.getVariable("wasNull").putVariable(caseWasNull.getLocalVariableDefinition()).append(this.ifWasNullPopAndGoto(context, elseLabel, Void.TYPE, type, type));
            }
            condition.invokeStatic(Operations.class, "equal", Boolean.TYPE, type, type);
            test.condition(condition);
            test.ifTrue(new Block(context).gotoLabel(matchLabel));
            test.ifFalse(elseNode);
            elseNode = test.build();
            elseLabel = testLabel;
        }
        caseBlock.append(elseNode);
        return caseBlock;
    }

    protected TypedByteCodeNode visitExpression(Expression node, CompilerContext context) {
        throw new UnsupportedOperationException(String.format("Compilation of %s not supported yet", node.getClass().getSimpleName()));
    }

    private ByteCodeNode ifWasNullPopAndGoto(CompilerContext context, LabelNode label, Class<?> returnType, Class<?> ... stackArgsToPop) {
        return this.handleNullValue(context, label, returnType, (List<? extends Class<?>>)ImmutableList.copyOf((Object[])stackArgsToPop), false);
    }

    private ByteCodeNode ifWasNullPopAndGoto(CompilerContext context, LabelNode label, Class<?> returnType, Iterable<? extends Class<?>> stackArgsToPop) {
        return this.handleNullValue(context, label, returnType, (List<? extends Class<?>>)ImmutableList.copyOf(stackArgsToPop), false);
    }

    private ByteCodeNode ifWasNullClearPopAndGoto(CompilerContext context, LabelNode label, Class<?> returnType, Class<?> ... stackArgsToPop) {
        return this.handleNullValue(context, label, returnType, (List<? extends Class<?>>)ImmutableList.copyOf((Object[])stackArgsToPop), true);
    }

    private ByteCodeNode handleNullValue(CompilerContext context, LabelNode label, Class<?> returnType, List<? extends Class<?>> stackArgsToPop, boolean clearNullFlag) {
        Block nullCheck = new Block(context).setDescription("ifWasNullGoto").getVariable("wasNull");
        String clearComment = null;
        if (clearNullFlag) {
            nullCheck.putVariable("wasNull", false);
            clearComment = "clear wasNull";
        }
        Block isNull = new Block(context);
        for (Class<?> parameterType : stackArgsToPop) {
            isNull.pop(parameterType);
        }
        isNull.pushJavaDefault(returnType);
        String loadDefaultComment = null;
        if (returnType != Void.TYPE) {
            loadDefaultComment = String.format("loadJavaDefault(%s)", returnType.getName());
        }
        isNull.gotoLabel(label);
        String popComment = null;
        if (!stackArgsToPop.isEmpty()) {
            popComment = String.format("pop(%s)", Joiner.on((String)", ").join(stackArgsToPop));
        }
        String comment = String.format("if wasNull then %s", Joiner.on((String)", ").skipNulls().join((Object)clearComment, (Object)popComment, new Object[]{loadDefaultComment, "goto " + label.getLabel()}));
        return new IfStatement(context, comment, nullCheck, isNull, OpCodes.NOP);
    }

    private TypedByteCodeNode coerceToType(CompilerContext context, TypedByteCodeNode node, Class<?> type) {
        if (node.getType() == Void.TYPE) {
            return TypedByteCodeNode.typedByteCodeNode(new Block(context).append(node.getNode()).pushJavaDefault(type), type);
        }
        if (node.getType() == Long.TYPE && type == Double.TYPE) {
            return TypedByteCodeNode.typedByteCodeNode(new Block(context).append(node.getNode()).append(OpCodes.L2D), type);
        }
        return node;
    }

    private Class<?> getType(TypedByteCodeNode ... nodes) {
        return this.getType((Iterable<TypedByteCodeNode>)ImmutableList.copyOf((Object[])nodes));
    }

    private Class<?> getType(Iterable<TypedByteCodeNode> nodes) {
        Set<Class<?>> types = IterableTransformer.on(nodes).transform(ByteCodeExpressionVisitor.nodeTypeGetter()).select(Predicates.not((Predicate)Predicates.equalTo(Void.TYPE))).set();
        if (types.isEmpty()) {
            return Void.TYPE;
        }
        if (types.equals(ImmutableSet.of(Double.TYPE, Long.TYPE))) {
            return Double.TYPE;
        }
        Preconditions.checkState((types.size() == 1 ? 1 : 0) != 0, (String)"Expected only one type but found %s", (Object[])new Object[]{types});
        return (Class)Iterables.getOnlyElement(types);
    }

    private static boolean isNumber(Class<?> type) {
        return type == Long.TYPE || type == Double.TYPE;
    }

    private static Function<TypedByteCodeNode, Class<?>> nodeTypeGetter() {
        return new Function<TypedByteCodeNode, Class<?>>(){

            public Class<?> apply(TypedByteCodeNode node) {
                return node.getType();
            }
        };
    }

    private static Function<TypedWhenClause, TypedByteCodeNode> whenConditionGetter() {
        return new Function<TypedWhenClause, TypedByteCodeNode>(){

            public TypedByteCodeNode apply(TypedWhenClause when) {
                return when.condition;
            }
        };
    }

    private static Function<TypedWhenClause, TypedByteCodeNode> whenValueGetter() {
        return new Function<TypedWhenClause, TypedByteCodeNode>(){

            public TypedByteCodeNode apply(TypedWhenClause when) {
                return when.value;
            }
        };
    }

    private class TypedWhenClause {
        private final TypedByteCodeNode condition;
        private final TypedByteCodeNode value;

        private TypedWhenClause(CompilerContext context, WhenClause whenClause) {
            this.condition = (TypedByteCodeNode)ByteCodeExpressionVisitor.this.process((Node)whenClause.getOperand(), context);
            this.value = (TypedByteCodeNode)ByteCodeExpressionVisitor.this.process((Node)whenClause.getResult(), context);
        }
    }

    public static class InFunctionBinder
    implements FunctionBinder {
        private static final MethodHandle inMethod;
        private final Class<?> valueType;
        private final ImmutableSet<Object> constantValues;

        public InFunctionBinder(Class<?> valueType, ImmutableSet<Object> constantValues) {
            this.valueType = valueType;
            this.constantValues = constantValues;
        }

        @Override
        public FunctionBinding bindFunction(long bindingId, String name, ByteCodeNode getSessionByteCode, List<TypedByteCodeNode> arguments) {
            MethodHandle methodHandle = inMethod.bindTo(this.constantValues);
            methodHandle = methodHandle.asType(MethodType.methodType(Boolean.TYPE, this.valueType));
            return new FunctionBinding(bindingId, name, new ConstantCallSite(methodHandle), arguments, false);
        }

        public static boolean in(ImmutableSet<?> set, Object value) {
            return set.contains(value);
        }

        static {
            try {
                inMethod = MethodHandles.lookup().findStatic(InFunctionBinder.class, "in", MethodType.methodType(Boolean.TYPE, ImmutableSet.class, Object.class));
            }
            catch (ReflectiveOperationException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

