/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.gen.FunctionBinder;
import com.facebook.presto.sql.gen.FunctionBinding;
import com.facebook.presto.sql.gen.TypedByteCodeNode;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.airlift.slice.Slice;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class BootstrapFunctionBinder {
    private static final AtomicLong NEXT_BINDING_ID = new AtomicLong();
    private final Metadata metadata;
    private final ConcurrentMap<Long, FunctionBinding> functionBindings = new ConcurrentHashMap<Long, FunctionBinding>();

    public BootstrapFunctionBinder(Metadata metadata) {
        this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
    }

    public FunctionBinding bindFunction(QualifiedName name, ByteCodeNode getSessionByteCode, List<TypedByteCodeNode> arguments) {
        List argumentTypes = Lists.transform(arguments, BootstrapFunctionBinder.toTupleType());
        FunctionInfo function = this.metadata.getFunction(name, argumentTypes);
        Preconditions.checkArgument((function != null ? 1 : 0) != 0, (String)"Unknown function %s%s", (Object[])new Object[]{name, argumentTypes});
        FunctionBinding functionBinding = this.bindFunction(name.toString(), getSessionByteCode, arguments, function.getFunctionBinder());
        return functionBinding;
    }

    public FunctionBinding bindFunction(String name, ByteCodeNode getSessionByteCode, List<TypedByteCodeNode> arguments, FunctionBinder defaultFunctionBinder) {
        FunctionBinding functionBinding = defaultFunctionBinder.bindFunction(NEXT_BINDING_ID.getAndIncrement(), name, getSessionByteCode, arguments);
        this.functionBindings.put(functionBinding.getBindingId(), functionBinding);
        return functionBinding;
    }

    public CallSite bootstrap(String name, MethodType type, long bindingId) {
        FunctionBinding functionBinding = (FunctionBinding)this.functionBindings.get(bindingId);
        Preconditions.checkArgument((functionBinding != null ? 1 : 0) != 0, (String)"Binding %s for function %s%s not found", (Object[])new Object[]{bindingId, name, type.parameterList()});
        return functionBinding.getCallSite();
    }

    public static Function<TypedByteCodeNode, Type> toTupleType() {
        return new Function<TypedByteCodeNode, Type>(){

            public Type apply(TypedByteCodeNode node) {
                Class<?> type = node.getType();
                if (type == Boolean.TYPE) {
                    return Type.BOOLEAN;
                }
                if (type == Long.TYPE) {
                    return Type.BIGINT;
                }
                if (type == Double.TYPE) {
                    return Type.DOUBLE;
                }
                if (type == String.class) {
                    return Type.VARCHAR;
                }
                if (type == Slice.class) {
                    return Type.VARCHAR;
                }
                throw new UnsupportedOperationException("Unsupported function type " + type);
            }
        };
    }
}

