/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TableMetadata;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.AggregateExtractor;
import com.facebook.presto.sql.analyzer.AggregationAnalyzer;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.AnalysisContext;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.EquiJoinClause;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.FieldOrExpression;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.sql.analyzer.StatementAnalyzer;
import com.facebook.presto.sql.analyzer.TupleDescriptor;
import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.analyzer.WindowFunctionExtractor;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.NoOpSymbolResolver;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolResolver;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DefaultExpressionTraversalVisitor;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Except;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Intersect;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.JoinCriteria;
import com.facebook.presto.sql.tree.JoinOn;
import com.facebook.presto.sql.tree.JoinUsing;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.NaturalJoin;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.Union;
import com.facebook.presto.sql.tree.Window;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class TupleAnalyzer
extends DefaultTraversalVisitor<TupleDescriptor, AnalysisContext> {
    private final Analysis analysis;
    private final Session session;
    private final Metadata metadata;

    public TupleAnalyzer(Analysis analysis, Session session, Metadata metadata) {
        Preconditions.checkNotNull((Object)analysis, (Object)"analysis is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        this.analysis = analysis;
        this.session = session;
        this.metadata = metadata;
    }

    protected TupleDescriptor visitTable(Table table, AnalysisContext context) {
        Object name;
        Query query;
        if (!table.getName().getPrefix().isPresent() && (query = context.getNamedQuery((String)(name = table.getName().getSuffix()))) != null) {
            this.analysis.registerNamedQuery(table, query);
            TupleDescriptor queryDescriptor = this.analysis.getOutputDescriptor((Node)query);
            ImmutableList.Builder fields = ImmutableList.builder();
            for (Field field : queryDescriptor.getFields()) {
                fields.add((Object)Field.newQualified(QualifiedName.of((String)name, (String[])new String[0]), field.getName(), field.getType()));
            }
            TupleDescriptor descriptor = new TupleDescriptor((List<Field>)fields.build());
            this.analysis.setOutputDescriptor((Node)table, descriptor);
            return descriptor;
        }
        name = MetadataUtil.createQualifiedTableName(this.session, table.getName());
        Optional<TableHandle> tableHandle = this.metadata.getTableHandle((QualifiedTableName)name);
        if (!tableHandle.isPresent()) {
            throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)table, "Table %s does not exist", name);
        }
        TableMetadata tableMetadata = this.metadata.getTableMetadata((TableHandle)tableHandle.get());
        Map<String, ColumnHandle> columns = this.metadata.getColumnHandles((TableHandle)tableHandle.get());
        ImmutableList.Builder fields = ImmutableList.builder();
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            Field field = Field.newQualified(table.getName(), (Optional<String>)Optional.of((Object)column.getName()), Type.fromRaw(column.getType()));
            fields.add((Object)field);
            this.analysis.setColumn(field, columns.get(column.getName()));
        }
        this.analysis.registerTable(table, (TableHandle)tableHandle.get());
        TupleDescriptor descriptor = new TupleDescriptor((List<Field>)fields.build());
        this.analysis.setOutputDescriptor((Node)table, descriptor);
        return descriptor;
    }

    protected TupleDescriptor visitAliasedRelation(AliasedRelation relation, AnalysisContext context) {
        int totalColumns;
        TupleDescriptor child = (TupleDescriptor)this.process((Node)relation.getRelation(), context);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (relation.getColumnNames() != null && (totalColumns = child.getFields().size()) != relation.getColumnNames().size()) {
            throw new SemanticException(SemanticErrorCode.MISMATCHED_COLUMN_ALIASES, (Node)relation, "Column alias list has %s entries but '%s' has %s columns available", relation.getColumnNames().size(), relation.getAlias(), totalColumns);
        }
        for (int i = 0; i < child.getFields().size(); ++i) {
            Field field = child.getFields().get(i);
            Optional columnAlias = field.getName();
            if (relation.getColumnNames() != null) {
                columnAlias = Optional.of(relation.getColumnNames().get(i));
            }
            builder.add((Object)Field.newQualified(QualifiedName.of((String)relation.getAlias(), (String[])new String[0]), (Optional<String>)columnAlias, field.getType()));
        }
        TupleDescriptor descriptor = new TupleDescriptor((List<Field>)builder.build());
        this.analysis.setOutputDescriptor((Node)relation, descriptor);
        return descriptor;
    }

    protected TupleDescriptor visitSampledRelation(final SampledRelation relation, AnalysisContext context) {
        ExpressionInterpreter samplePercentageEval = ExpressionInterpreter.expressionOptimizer(relation.getSamplePercentage(), this.metadata, this.session);
        Object samplePercentageObject = samplePercentageEval.optimize(new SymbolResolver(){

            @Override
            public Object getValue(Symbol symbol) {
                throw new SemanticException(SemanticErrorCode.NON_NUMERIC_SAMPLE_PERCENTAGE, (Node)relation.getSamplePercentage(), "Sample percentage cannot contain column references", new Object[0]);
            }
        });
        if (!(samplePercentageObject instanceof Number)) {
            throw new SemanticException(SemanticErrorCode.NON_NUMERIC_SAMPLE_PERCENTAGE, (Node)relation.getSamplePercentage(), "Sample percentage should evaluate to a numeric expression", new Object[0]);
        }
        double samplePercentageValue = ((Number)samplePercentageObject).doubleValue();
        if (samplePercentageValue < 0.0 || samplePercentageValue > 100.0) {
            throw new SemanticException(SemanticErrorCode.SAMPLE_PERCENTAGE_OUT_OF_RANGE, (Node)relation.getSamplePercentage(), "Sample percentage must be between 0 and 100", new Object[0]);
        }
        TupleDescriptor descriptor = (TupleDescriptor)this.process((Node)relation.getRelation(), context);
        this.analysis.setOutputDescriptor((Node)relation, descriptor);
        this.analysis.setSampleRatio(relation, samplePercentageValue / 100.0);
        return descriptor;
    }

    protected TupleDescriptor visitTableSubquery(TableSubquery node, AnalysisContext context) {
        StatementAnalyzer analyzer = new StatementAnalyzer(this.analysis, this.metadata, this.session, (Optional<QueryExplainer>)Optional.absent());
        TupleDescriptor descriptor = (TupleDescriptor)analyzer.process((Node)node.getQuery(), context);
        this.analysis.setOutputDescriptor((Node)node, descriptor);
        return descriptor;
    }

    protected TupleDescriptor visitQuerySpecification(QuerySpecification node, AnalysisContext parentContext) {
        AnalysisContext context = new AnalysisContext(parentContext);
        TupleDescriptor tupleDescriptor = this.analyzeFrom(node, context);
        this.analyzeWhere(node, tupleDescriptor, context);
        List<FieldOrExpression> outputExpressions = this.analyzeSelect(node, tupleDescriptor, context);
        List<FieldOrExpression> groupByExpressions = this.analyzeGroupBy(node, tupleDescriptor, context, outputExpressions);
        List<FieldOrExpression> orderByExpressions = this.analyzeOrderBy(node, tupleDescriptor, context, outputExpressions);
        this.analyzeHaving(node, tupleDescriptor, context);
        this.analyzeAggregations(node, tupleDescriptor, groupByExpressions, outputExpressions, orderByExpressions);
        this.analyzeWindowFunctions(node, outputExpressions, orderByExpressions);
        TupleDescriptor descriptor = this.computeOutputDescriptor(node, tupleDescriptor);
        this.analysis.setOutputDescriptor((Node)node, descriptor);
        return descriptor;
    }

    protected TupleDescriptor visitUnion(Union node, AnalysisContext context) {
        Preconditions.checkState((node.getRelations().size() >= 2 ? 1 : 0) != 0);
        TupleAnalyzer analyzer = new TupleAnalyzer(this.analysis, this.session, this.metadata);
        TupleDescriptor outputDescriptor = (TupleDescriptor)analyzer.process((Node)node.getRelations().get(0), context);
        for (Relation relation : Iterables.skip((Iterable)node.getRelations(), (int)1)) {
            TupleDescriptor descriptor = (TupleDescriptor)analyzer.process((Node)relation, context);
            if (Iterables.elementsEqual((Iterable)Iterables.transform(outputDescriptor.getFields(), Field.typeGetter()), (Iterable)Iterables.transform(descriptor.getFields(), Field.typeGetter()))) continue;
            throw new SemanticException(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, (Node)node, "Union query terms have mismatched columns", new Object[0]);
        }
        this.analysis.setOutputDescriptor((Node)node, outputDescriptor);
        return outputDescriptor;
    }

    protected TupleDescriptor visitIntersect(Intersect node, AnalysisContext context) {
        throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "INTERSECT not yet implemented", new Object[0]);
    }

    protected TupleDescriptor visitExcept(Except node, AnalysisContext context) {
        throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "EXCEPT not yet implemented", new Object[0]);
    }

    protected TupleDescriptor visitJoin(Join node, AnalysisContext context) {
        if (!EnumSet.of(Join.Type.INNER, Join.Type.LEFT, Join.Type.RIGHT).contains(node.getType())) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Only inner, left, and right joins are supported", new Object[0]);
        }
        JoinCriteria criteria = node.getCriteria();
        if (criteria instanceof NaturalJoin) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Natural join not supported", new Object[0]);
        }
        TupleDescriptor left = (TupleDescriptor)this.process((Node)node.getLeft(), context);
        TupleDescriptor right = (TupleDescriptor)this.process((Node)node.getRight(), context);
        Sets.SetView duplicateAliases = Sets.intersection(left.getRelationAliases(), right.getRelationAliases());
        if (!duplicateAliases.isEmpty()) {
            throw new SemanticException(SemanticErrorCode.DUPLICATE_RELATION, (Node)node, "Relations appear more than once: %s", duplicateAliases);
        }
        ImmutableList outputFields = ImmutableList.builder().addAll(left.getFields()).addAll(right.getFields()).build();
        TupleDescriptor output = new TupleDescriptor((List<Field>)outputFields);
        if (criteria instanceof JoinUsing) {
            List columns = ((JoinUsing)criteria).getColumns();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String column : columns) {
                QualifiedNameReference leftExpression = new QualifiedNameReference(QualifiedName.of((String)column, (String[])new String[0]));
                QualifiedNameReference rightExpression = new QualifiedNameReference(QualifiedName.of((String)column, (String[])new String[0]));
                Analyzer.ExpressionAnalysis leftExpressionAnalysis = Analyzer.analyzeExpression(this.session, this.metadata, left, this.analysis, context, (Expression)leftExpression);
                Analyzer.ExpressionAnalysis rightExpressionAnalysis = Analyzer.analyzeExpression(this.session, this.metadata, right, this.analysis, context, (Expression)rightExpression);
                Preconditions.checkState((boolean)leftExpressionAnalysis.getSubqueryInPredicates().isEmpty(), (Object)"INVARIANT");
                Preconditions.checkState((boolean)rightExpressionAnalysis.getSubqueryInPredicates().isEmpty(), (Object)"INVARIANT");
                builder.add((Object)new EquiJoinClause((Expression)leftExpression, (Expression)rightExpression));
            }
            this.analysis.setEquijoinCriteria(node, (List<EquiJoinClause>)builder.build());
        } else if (criteria instanceof JoinOn) {
            Expression expression = ((JoinOn)criteria).getExpression();
            ExpressionAnalyzer analyzer = new ExpressionAnalyzer(this.analysis, this.session, this.metadata);
            analyzer.analyze(expression, output, context);
            Analyzer.verifyNoAggregatesOrWindowFunctions(this.metadata, expression, "JOIN");
            Object optimizedExpression = ExpressionInterpreter.expressionOptimizer(expression, this.metadata, this.session).optimize(NoOpSymbolResolver.INSTANCE);
            if (!(optimizedExpression instanceof Expression)) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Joins on constant expressions (i.e., cross joins) not supported", new Object[0]);
            }
            ImmutableList.Builder clauses = ImmutableList.builder();
            for (Expression conjunct : ExpressionUtils.extractConjuncts((Expression)optimizedExpression)) {
                Expression rightExpression;
                Expression leftExpression;
                if (!(conjunct instanceof ComparisonExpression)) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Non-equi joins not supported: %s", conjunct);
                }
                ComparisonExpression comparison = (ComparisonExpression)conjunct;
                if (comparison.getType() != ComparisonExpression.Type.EQUAL) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Non-equi joins not supported: %s", conjunct);
                }
                Set<QualifiedName> firstDependencies = DependencyExtractor.extract(comparison.getLeft());
                Set<QualifiedName> secondDependencies = DependencyExtractor.extract(comparison.getRight());
                if (Iterables.all(firstDependencies, left.canResolvePredicate()) && Iterables.all(secondDependencies, right.canResolvePredicate())) {
                    leftExpression = comparison.getLeft();
                    rightExpression = comparison.getRight();
                } else if (Iterables.all(firstDependencies, right.canResolvePredicate()) && Iterables.all(secondDependencies, left.canResolvePredicate())) {
                    leftExpression = comparison.getRight();
                    rightExpression = comparison.getLeft();
                } else {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Non-equi joins not supported: %s", conjunct);
                }
                Analyzer.ExpressionAnalysis leftExpressionAnalysis = Analyzer.analyzeExpression(this.session, this.metadata, left, this.analysis, context, leftExpression);
                Analyzer.ExpressionAnalysis rightExpressionAnalysis = Analyzer.analyzeExpression(this.session, this.metadata, right, this.analysis, context, rightExpression);
                this.analysis.addJoinInPredicates(node, new Analysis.JoinInPredicates(leftExpressionAnalysis.getSubqueryInPredicates(), rightExpressionAnalysis.getSubqueryInPredicates()));
                clauses.add((Object)new EquiJoinClause(leftExpression, rightExpression));
            }
            this.analysis.setEquijoinCriteria(node, (List<EquiJoinClause>)clauses.build());
        } else {
            throw new UnsupportedOperationException("unsupported join criteria: " + criteria.getClass().getName());
        }
        this.analysis.setOutputDescriptor((Node)node, output);
        return output;
    }

    private void analyzeWindowFunctions(QuerySpecification node, List<FieldOrExpression> outputExpressions, List<FieldOrExpression> orderByExpressions) {
        WindowFunctionExtractor extractor = new WindowFunctionExtractor();
        for (FieldOrExpression fieldOrExpression : Iterables.concat(outputExpressions, orderByExpressions)) {
            if (!fieldOrExpression.isExpression()) continue;
            extractor.process((Node)fieldOrExpression.getExpression(), null);
        }
        List<FunctionCall> windowFunctions = extractor.getWindowFunctions();
        for (FunctionCall windowFunction : windowFunctions) {
            Window window = (Window)windowFunction.getWindow().get();
            WindowFunctionExtractor nestedExtractor = new WindowFunctionExtractor();
            for (Expression argument : windowFunction.getArguments()) {
                nestedExtractor.process((Node)argument, null);
            }
            for (Expression expression : window.getPartitionBy()) {
                nestedExtractor.process((Node)expression, null);
            }
            for (SortItem sortItem : window.getOrderBy()) {
                nestedExtractor.process((Node)sortItem.getSortKey(), null);
            }
            if (window.getFrame().isPresent()) {
                nestedExtractor.process((Node)window.getFrame().get(), null);
            }
            if (!nestedExtractor.getWindowFunctions().isEmpty()) {
                throw new SemanticException(SemanticErrorCode.NESTED_WINDOW, (Node)node, "Cannot nest window functions inside window function '%s': %s", windowFunction, extractor.getWindowFunctions());
            }
            if (windowFunction.isDistinct()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "DISTINCT in window function parameters not yet supported: %s", windowFunction);
            }
            if (window.getFrame().isPresent()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Window frames not yet supported", new Object[0]);
            }
            List argumentTypes = Lists.transform((List)windowFunction.getArguments(), (Function)new Function<Expression, Type>(){

                public Type apply(Expression input) {
                    return TupleAnalyzer.this.analysis.getType(input);
                }
            });
            FunctionInfo info = this.metadata.getFunction(windowFunction.getName(), argumentTypes);
            if (info.isWindow()) continue;
            throw new SemanticException(SemanticErrorCode.MUST_BE_WINDOW_FUNCTION, (Node)node, "Not a window function: %s", windowFunction.getName());
        }
        this.analysis.setWindowFunctions(node, windowFunctions);
    }

    private void analyzeHaving(QuerySpecification node, TupleDescriptor tupleDescriptor, AnalysisContext context) {
        if (node.getHaving().isPresent()) {
            Expression predicate = (Expression)node.getHaving().get();
            Analyzer.ExpressionAnalysis expressionAnalysis = Analyzer.analyzeExpression(this.session, this.metadata, tupleDescriptor, this.analysis, context, predicate);
            this.analysis.addInPredicates(node, expressionAnalysis.getSubqueryInPredicates());
            if (expressionAnalysis.getType() != Type.BOOLEAN && expressionAnalysis.getType() != Type.NULL) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)predicate, "HAVING clause must evaluate to a boolean: actual type %s", new Object[]{expressionAnalysis.getType()});
            }
            this.analysis.setHaving(node, predicate);
        }
    }

    private List<FieldOrExpression> analyzeOrderBy(QuerySpecification node, TupleDescriptor tupleDescriptor, AnalysisContext context, List<FieldOrExpression> outputExpressions) {
        List items = node.getOrderBy();
        ImmutableList.Builder orderByExpressionsBuilder = ImmutableList.builder();
        if (!items.isEmpty()) {
            ImmutableMultimap.Builder byAliasBuilder = ImmutableMultimap.builder();
            for (SelectItem item : node.getSelect().getSelectItems()) {
                Optional alias;
                if (!(item instanceof SingleColumn) || !(alias = ((SingleColumn)item).getAlias()).isPresent()) continue;
                byAliasBuilder.put((Object)QualifiedName.of((String)((String)alias.get()), (String[])new String[0]), (Object)((SingleColumn)item).getExpression());
            }
            ImmutableMultimap byAlias = byAliasBuilder.build();
            for (SortItem item : items) {
                Expression expression = item.getSortKey();
                FieldOrExpression orderByExpression = null;
                if (expression instanceof QualifiedNameReference && !((QualifiedNameReference)expression).getName().getPrefix().isPresent()) {
                    QualifiedName name = ((QualifiedNameReference)expression).getName();
                    Collection expressions = byAlias.get((Object)name);
                    if (expressions.size() > 1) {
                        throw new SemanticException(SemanticErrorCode.AMBIGUOUS_ATTRIBUTE, (Node)expression, "'%s' in ORDER BY is ambiguous", name.getSuffix());
                    }
                    if (expressions.size() == 1) {
                        orderByExpression = new FieldOrExpression((Expression)Iterables.getOnlyElement((Iterable)expressions));
                    }
                } else if (expression instanceof LongLiteral) {
                    long ordinal = ((LongLiteral)expression).getValue();
                    if (ordinal < 1L || ordinal > (long)outputExpressions.size()) {
                        throw new SemanticException(SemanticErrorCode.INVALID_ORDINAL, (Node)expression, "ORDER BY position %s is not in select list", ordinal);
                    }
                    orderByExpression = outputExpressions.get((int)(ordinal - 1L));
                }
                if (orderByExpression == null) {
                    orderByExpression = new FieldOrExpression(expression);
                }
                if (orderByExpression.isExpression()) {
                    Analyzer.ExpressionAnalysis expressionAnalysis = Analyzer.analyzeExpression(this.session, this.metadata, tupleDescriptor, this.analysis, context, orderByExpression.getExpression());
                    this.analysis.addInPredicates(node, expressionAnalysis.getSubqueryInPredicates());
                }
                orderByExpressionsBuilder.add((Object)orderByExpression);
            }
        }
        ImmutableList orderByExpressions = orderByExpressionsBuilder.build();
        this.analysis.setOrderByExpressions((Node)node, (List<FieldOrExpression>)orderByExpressions);
        if (node.getSelect().isDistinct() && !outputExpressions.containsAll((Collection<?>)orderByExpressions)) {
            throw new SemanticException(SemanticErrorCode.ORDER_BY_MUST_BE_IN_SELECT, (Node)node.getSelect(), "For SELECT DISTINCT, ORDER BY expressions must appear in select list", new Object[0]);
        }
        return orderByExpressions;
    }

    private List<FieldOrExpression> analyzeGroupBy(QuerySpecification node, TupleDescriptor tupleDescriptor, AnalysisContext context, List<FieldOrExpression> outputExpressions) {
        ImmutableList.Builder groupByExpressionsBuilder = ImmutableList.builder();
        if (!node.getGroupBy().isEmpty()) {
            for (Expression expression : node.getGroupBy()) {
                FieldOrExpression groupByExpression;
                if (expression instanceof LongLiteral) {
                    long ordinal = ((LongLiteral)expression).getValue();
                    if (ordinal < 1L || ordinal > (long)outputExpressions.size()) {
                        throw new SemanticException(SemanticErrorCode.INVALID_ORDINAL, (Node)expression, "GROUP BY position %s is not in select list", ordinal);
                    }
                    groupByExpression = outputExpressions.get((int)(ordinal - 1L));
                } else {
                    Analyzer.ExpressionAnalysis expressionAnalysis = Analyzer.analyzeExpression(this.session, this.metadata, tupleDescriptor, this.analysis, context, expression);
                    this.analysis.addInPredicates(node, expressionAnalysis.getSubqueryInPredicates());
                    groupByExpression = new FieldOrExpression(expression);
                }
                if (groupByExpression.isExpression()) {
                    Analyzer.verifyNoAggregatesOrWindowFunctions(this.metadata, groupByExpression.getExpression(), "GROUP BY");
                }
                groupByExpressionsBuilder.add((Object)groupByExpression);
            }
        }
        ImmutableList groupByExpressions = groupByExpressionsBuilder.build();
        this.analysis.setGroupByExpressions(node, (List<FieldOrExpression>)groupByExpressions);
        return groupByExpressions;
    }

    private TupleDescriptor computeOutputDescriptor(QuerySpecification node, TupleDescriptor inputTupleDescriptor) {
        ImmutableList.Builder outputFields = ImmutableList.builder();
        for (SelectItem item : node.getSelect().getSelectItems()) {
            if (item instanceof AllColumns) {
                Optional starPrefix = ((AllColumns)item).getPrefix();
                for (Field field : inputTupleDescriptor.resolveFieldsWithPrefix((Optional<QualifiedName>)starPrefix)) {
                    outputFields.add((Object)Field.newUnqualified(field.getName(), field.getType()));
                }
                continue;
            }
            if (item instanceof SingleColumn) {
                SingleColumn column = (SingleColumn)item;
                Optional alias = column.getAlias();
                if (!alias.isPresent() && column.getExpression() instanceof QualifiedNameReference) {
                    alias = Optional.of((Object)((QualifiedNameReference)column.getExpression()).getName().getSuffix());
                }
                outputFields.add((Object)Field.newUnqualified((Optional<String>)alias, this.analysis.getType(column.getExpression())));
                continue;
            }
            throw new IllegalArgumentException("Unsupported SelectItem type: " + item.getClass().getName());
        }
        return new TupleDescriptor((List<Field>)outputFields.build());
    }

    private List<FieldOrExpression> analyzeSelect(QuerySpecification node, TupleDescriptor tupleDescriptor, AnalysisContext context) {
        ImmutableList.Builder outputExpressionBuilder = ImmutableList.builder();
        for (SelectItem item : node.getSelect().getSelectItems()) {
            if (item instanceof AllColumns) {
                Optional starPrefix = ((AllColumns)item).getPrefix();
                List<Integer> fields = tupleDescriptor.resolveFieldIndexesWithPrefix((Optional<QualifiedName>)starPrefix);
                if (fields.isEmpty()) {
                    if (starPrefix.isPresent()) {
                        throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)item, "Table '%s' not found", starPrefix.get());
                    }
                    throw new SemanticException(SemanticErrorCode.WILDCARD_WITHOUT_FROM, (Node)item, "SELECT * not allowed in queries without FROM clause", new Object[0]);
                }
                for (int fieldIndex : fields) {
                    outputExpressionBuilder.add((Object)new FieldOrExpression(fieldIndex));
                }
                continue;
            }
            if (item instanceof SingleColumn) {
                SingleColumn column = (SingleColumn)item;
                Analyzer.ExpressionAnalysis expressionAnalysis = Analyzer.analyzeExpression(this.session, this.metadata, tupleDescriptor, this.analysis, context, column.getExpression());
                this.analysis.addInPredicates(node, expressionAnalysis.getSubqueryInPredicates());
                outputExpressionBuilder.add((Object)new FieldOrExpression(column.getExpression()));
                continue;
            }
            throw new IllegalArgumentException("Unsupported SelectItem type: " + item.getClass().getName());
        }
        ImmutableList result = outputExpressionBuilder.build();
        this.analysis.setOutputExpressions((Node)node, (List<FieldOrExpression>)result);
        return result;
    }

    private void analyzeWhere(QuerySpecification node, TupleDescriptor tupleDescriptor, AnalysisContext context) {
        if (node.getWhere().isPresent()) {
            Expression predicate = (Expression)node.getWhere().get();
            Analyzer.verifyNoAggregatesOrWindowFunctions(this.metadata, predicate, "WHERE");
            Analyzer.ExpressionAnalysis expressionAnalysis = Analyzer.analyzeExpression(this.session, this.metadata, tupleDescriptor, this.analysis, context, predicate);
            this.analysis.addInPredicates(node, expressionAnalysis.getSubqueryInPredicates());
            if (expressionAnalysis.getType() != Type.BOOLEAN && expressionAnalysis.getType() != Type.NULL) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)predicate, "WHERE clause must evaluate to a boolean: actual type %s", new Object[]{expressionAnalysis.getType()});
            }
            this.analysis.setWhere(node, predicate);
        }
    }

    private TupleDescriptor analyzeFrom(QuerySpecification node, AnalysisContext context) {
        TupleDescriptor fromDescriptor = new TupleDescriptor(new Field[0]);
        if (node.getFrom() != null && !node.getFrom().isEmpty()) {
            TupleAnalyzer analyzer = new TupleAnalyzer(this.analysis, this.session, this.metadata);
            if (node.getFrom().size() != 1) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Cross joins not yet supported", new Object[0]);
            }
            fromDescriptor = (TupleDescriptor)analyzer.process((Node)Iterables.getOnlyElement((Iterable)node.getFrom()), context);
        }
        return fromDescriptor;
    }

    private void analyzeAggregations(QuerySpecification node, TupleDescriptor tupleDescriptor, List<FieldOrExpression> groupByExpressions, List<FieldOrExpression> outputExpressions, List<FieldOrExpression> orderByExpressions) {
        List<FunctionCall> aggregates = this.extractAggregates(node);
        if (!aggregates.isEmpty() || !groupByExpressions.isEmpty()) {
            if (Iterables.any(aggregates, (Predicate)FunctionCall.distinctPredicate())) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "DISTINCT in aggregation parameters not yet supported", new Object[0]);
            }
            for (FieldOrExpression fieldOrExpression : Iterables.concat(outputExpressions, orderByExpressions)) {
                this.verifyAggregations(node, groupByExpressions, tupleDescriptor, fieldOrExpression);
            }
            if (node.getHaving().isPresent()) {
                this.verifyAggregations(node, groupByExpressions, tupleDescriptor, new FieldOrExpression((Expression)node.getHaving().get()));
            }
        }
    }

    private List<FunctionCall> extractAggregates(QuerySpecification node) {
        AggregateExtractor extractor = new AggregateExtractor(this.metadata);
        for (SelectItem item : node.getSelect().getSelectItems()) {
            if (!(item instanceof SingleColumn)) continue;
            ((SingleColumn)item).getExpression().accept((AstVisitor)extractor, null);
        }
        for (SelectItem item : node.getOrderBy()) {
            item.getSortKey().accept((AstVisitor)extractor, null);
        }
        if (node.getHaving().isPresent()) {
            ((Expression)node.getHaving().get()).accept((AstVisitor)extractor, null);
        }
        List<FunctionCall> aggregates = extractor.getAggregates();
        this.analysis.setAggregates(node, aggregates);
        return aggregates;
    }

    private void verifyAggregations(QuerySpecification node, List<FieldOrExpression> groupByExpressions, TupleDescriptor tupleDescriptor, FieldOrExpression fieldOrExpression) {
        AggregationAnalyzer analyzer = new AggregationAnalyzer(groupByExpressions, this.metadata, tupleDescriptor);
        if (fieldOrExpression.isExpression()) {
            analyzer.analyze(fieldOrExpression.getExpression());
        } else {
            int fieldIndex = fieldOrExpression.getFieldIndex();
            if (!analyzer.analyze(fieldIndex)) {
                Field field = tupleDescriptor.getFields().get(fieldIndex);
                if (field.getRelationAlias().isPresent()) {
                    if (field.getName().isPresent()) {
                        throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)node, "Column '%s.%s' not in GROUP BY clause", field.getRelationAlias().get(), field.getName().get());
                    }
                    throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)node, "Columns from '%s' not in GROUP BY clause", field.getRelationAlias().get());
                }
                if (field.getName().isPresent()) {
                    throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)node, "Column '%s' not in GROUP BY clause", field.getName().get());
                }
                throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)node, "Some columns from FROM clause not in GROUP BY clause", new Object[0]);
            }
        }
    }

    public static class DependencyExtractor {
        public static Set<QualifiedName> extract(Expression expression) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            Visitor visitor = new Visitor();
            visitor.process((Node)expression, builder);
            return builder.build();
        }

        private static class Visitor
        extends DefaultExpressionTraversalVisitor<Void, ImmutableSet.Builder<QualifiedName>> {
            private Visitor() {
            }

            protected Void visitQualifiedNameReference(QualifiedNameReference node, ImmutableSet.Builder<QualifiedName> builder) {
                builder.add((Object)node.getName());
                return null;
            }
        }
    }
}

