/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;

public class Field {
    private final Optional<QualifiedName> relationAlias;
    private final Optional<String> name;
    private final Type type;

    public static Field newUnqualified(String name, Type type) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull((Object)((Object)type), (Object)"type is null");
        return new Field((Optional<QualifiedName>)Optional.absent(), (Optional<String>)Optional.of((Object)name), type);
    }

    public static Field newUnqualified(Optional<String> name, Type type) {
        Preconditions.checkNotNull(name, (Object)"name is null");
        Preconditions.checkNotNull((Object)((Object)type), (Object)"type is null");
        return new Field((Optional<QualifiedName>)Optional.absent(), name, type);
    }

    public static Field newQualified(QualifiedName relationAlias, Optional<String> name, Type type) {
        Preconditions.checkNotNull((Object)relationAlias, (Object)"relationAlias is null");
        Preconditions.checkNotNull(name, (Object)"name is null");
        Preconditions.checkNotNull((Object)((Object)type), (Object)"type is null");
        return new Field((Optional<QualifiedName>)Optional.of((Object)relationAlias), name, type);
    }

    private Field(Optional<QualifiedName> relationAlias, Optional<String> name, Type type) {
        Preconditions.checkNotNull(relationAlias, (Object)"relationAlias is null");
        Preconditions.checkNotNull(name, (Object)"name is null");
        Preconditions.checkNotNull((Object)((Object)type), (Object)"type is null");
        this.relationAlias = relationAlias;
        this.name = name;
        this.type = type;
    }

    public Optional<QualifiedName> getRelationAlias() {
        return this.relationAlias;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public static Function<Field, Type> typeGetter() {
        return new Function<Field, Type>(){

            public Type apply(Field field) {
                return field.getType();
            }
        };
    }

    public boolean matchesPrefix(Optional<QualifiedName> prefix) {
        return !prefix.isPresent() || this.relationAlias.isPresent() && ((QualifiedName)this.relationAlias.get()).hasSuffix((QualifiedName)prefix.get());
    }

    public boolean canResolve(QualifiedName name) {
        if (!this.name.isPresent()) {
            return false;
        }
        return this.matchesPrefix((Optional<QualifiedName>)name.getPrefix()) && ((String)this.name.get()).equalsIgnoreCase(name.getSuffix());
    }

    public static Function<Field, Optional<QualifiedName>> relationAliasGetter() {
        return new Function<Field, Optional<QualifiedName>>(){

            public Optional<QualifiedName> apply(Field input) {
                return input.getRelationAlias();
            }
        };
    }

    public static Predicate<Field> canResolvePredicate(final QualifiedName name) {
        return new Predicate<Field>(){

            public boolean apply(Field input) {
                return input.canResolve(name);
            }
        };
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.relationAlias.isPresent()) {
            result.append(this.relationAlias.get()).append(".");
        }
        result.append((String)this.name.or((Object)"<anonymous>")).append(":").append((Object)this.type);
        return result.toString();
    }
}

