/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.analyzer.AggregateExtractor;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.AnalysisContext;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.sql.analyzer.StatementAnalyzer;
import com.facebook.presto.sql.analyzer.TupleDescriptor;
import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.analyzer.WindowFunctionExtractor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Set;

public class Analyzer {
    private final Metadata metadata;
    private final Session session;
    private final Optional<QueryExplainer> queryExplainer;

    public Analyzer(Session session, Metadata metadata, Optional<QueryExplainer> queryExplainer) {
        this.session = (Session)Preconditions.checkNotNull((Object)session, (Object)"session is null");
        this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        this.queryExplainer = (Optional)Preconditions.checkNotNull(queryExplainer, (Object)"query explainer is null");
    }

    public Analysis analyze(Statement statement) {
        Analysis analysis = new Analysis();
        StatementAnalyzer analyzer = new StatementAnalyzer(analysis, this.metadata, this.session, this.queryExplainer);
        TupleDescriptor outputDescriptor = (TupleDescriptor)analyzer.process((Node)statement, new AnalysisContext());
        analysis.setOutputDescriptor(outputDescriptor);
        return analysis;
    }

    static void verifyNoAggregatesOrWindowFunctions(Metadata metadata, Expression predicate, String clause) {
        AggregateExtractor extractor = new AggregateExtractor(metadata);
        extractor.process((Node)predicate, null);
        WindowFunctionExtractor windowExtractor = new WindowFunctionExtractor();
        windowExtractor.process((Node)predicate, null);
        ImmutableList found = ImmutableList.copyOf((Iterable)Iterables.concat(extractor.getAggregates(), windowExtractor.getWindowFunctions()));
        if (!found.isEmpty()) {
            throw new SemanticException(SemanticErrorCode.CANNOT_HAVE_AGGREGATIONS_OR_WINDOWS, (Node)predicate, "%s clause cannot contain aggregations or window functions: %s", clause, found);
        }
    }

    static ExpressionAnalysis analyzeExpression(Session session, Metadata metadata, TupleDescriptor tupleDescriptor, Analysis analysis, AnalysisContext context, Expression expression) {
        ExpressionAnalyzer analyzer = new ExpressionAnalyzer(analysis, session, metadata);
        Type type = analyzer.analyze(expression, tupleDescriptor, context);
        analysis.addFunctionInfos(analyzer.getResolvedFunctions());
        IdentityHashMap<Expression, Type> subExpressions = analyzer.getSubExpressionTypes();
        analysis.addTypes(subExpressions);
        for (Expression subExpression : subExpressions.keySet()) {
            analysis.addResolvedNames(subExpression, analyzer.getResolvedNames());
        }
        Set<InPredicate> subqueryInPredicates = analyzer.getSubqueryInPredicates();
        return new ExpressionAnalysis(type, subqueryInPredicates);
    }

    public static class ExpressionAnalysis {
        private final Type type;
        private final Set<InPredicate> subqueryInPredicates;

        public ExpressionAnalysis(Type type, Set<InPredicate> subqueryInPredicates) {
            this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type is null"));
            this.subqueryInPredicates = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(subqueryInPredicates, (Object)"subqueryInPredicates is null")));
        }

        public Type getType() {
            return this.type;
        }

        public Set<InPredicate> getSubqueryInPredicates() {
            return this.subqueryInPredicates;
        }
    }
}

