/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.tree.Query;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;

public class AnalysisContext {
    private final AnalysisContext parent;
    private final Map<String, Query> namedQueries = new HashMap<String, Query>();

    public AnalysisContext(AnalysisContext parent) {
        this.parent = parent;
    }

    public AnalysisContext() {
        this.parent = null;
    }

    public void addNamedQuery(String name, Query query) {
        Preconditions.checkState((!this.namedQueries.containsKey(name) ? 1 : 0) != 0, (String)"Named query already registered: %s", (Object[])new Object[]{name});
        this.namedQueries.put(name, query);
    }

    public Query getNamedQuery(String name) {
        Query result = this.namedQueries.get(name);
        if (result == null && this.parent != null) {
            return this.parent.getNamedQuery(name);
        }
        return result;
    }

    public boolean isNamedQueryDeclared(String name) {
        return this.namedQueries.containsKey(name);
    }
}

