/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.sql.analyzer.EquiJoinClause;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.FieldOrExpression;
import com.facebook.presto.sql.analyzer.TupleDescriptor;
import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.Table;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Analysis {
    private Query query;
    private final IdentityHashMap<Table, Query> namedQueries = new IdentityHashMap();
    private TupleDescriptor outputDescriptor;
    private final IdentityHashMap<Node, TupleDescriptor> outputDescriptors = new IdentityHashMap();
    private final IdentityHashMap<Expression, Map<QualifiedName, Integer>> resolvedNames = new IdentityHashMap();
    private final IdentityHashMap<QuerySpecification, List<FunctionCall>> aggregates = new IdentityHashMap();
    private final IdentityHashMap<QuerySpecification, List<FieldOrExpression>> groupByExpressions = new IdentityHashMap();
    private final IdentityHashMap<QuerySpecification, Expression> where = new IdentityHashMap();
    private final IdentityHashMap<QuerySpecification, Expression> having = new IdentityHashMap();
    private final IdentityHashMap<Node, List<FieldOrExpression>> orderByExpressions = new IdentityHashMap();
    private final IdentityHashMap<Node, List<FieldOrExpression>> outputExpressions = new IdentityHashMap();
    private final IdentityHashMap<QuerySpecification, List<FunctionCall>> windowFunctions = new IdentityHashMap();
    private final IdentityHashMap<Join, List<EquiJoinClause>> joins = new IdentityHashMap();
    private final SetMultimap<Node, InPredicate> inPredicates = HashMultimap.create();
    private final IdentityHashMap<Join, JoinInPredicates> joinInPredicates = new IdentityHashMap();
    private final IdentityHashMap<Table, TableHandle> tables = new IdentityHashMap();
    private final IdentityHashMap<Expression, Type> types = new IdentityHashMap();
    private final IdentityHashMap<FunctionCall, FunctionInfo> functionInfo = new IdentityHashMap();
    private final IdentityHashMap<Field, ColumnHandle> columns = new IdentityHashMap();
    private final IdentityHashMap<SampledRelation, Double> sampleRatios = new IdentityHashMap();
    private QualifiedTableName destination;
    private Optional<Integer> refreshInterval;
    private boolean refresh;

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void addResolvedNames(Expression expression, Map<QualifiedName, Integer> mappings) {
        this.resolvedNames.put(expression, mappings);
    }

    public Map<QualifiedName, Integer> getResolvedNames(Expression expression) {
        return this.resolvedNames.get(expression);
    }

    public void setAggregates(QuerySpecification node, List<FunctionCall> aggregates) {
        this.aggregates.put(node, aggregates);
    }

    public List<FunctionCall> getAggregates(QuerySpecification query) {
        return this.aggregates.get(query);
    }

    public Type getType(Expression expression) {
        Preconditions.checkArgument((boolean)this.types.containsKey(expression), (String)"Expression not analyzed: %s", (Object[])new Object[]{expression});
        return this.types.get(expression);
    }

    public void setGroupByExpressions(QuerySpecification node, List<FieldOrExpression> expressions) {
        this.groupByExpressions.put(node, expressions);
    }

    public List<FieldOrExpression> getGroupByExpressions(QuerySpecification node) {
        return this.groupByExpressions.get(node);
    }

    public void setWhere(QuerySpecification node, Expression expression) {
        this.where.put(node, expression);
    }

    public Expression getWhere(QuerySpecification node) {
        return this.where.get(node);
    }

    public void setOrderByExpressions(Node node, List<FieldOrExpression> items) {
        this.orderByExpressions.put(node, items);
    }

    public List<FieldOrExpression> getOrderByExpressions(Node node) {
        return this.orderByExpressions.get(node);
    }

    public void setOutputExpressions(Node node, List<FieldOrExpression> expressions) {
        this.outputExpressions.put(node, expressions);
    }

    public List<FieldOrExpression> getOutputExpressions(Node node) {
        return this.outputExpressions.get(node);
    }

    public void setHaving(QuerySpecification node, Expression expression) {
        this.having.put(node, expression);
    }

    public void setEquijoinCriteria(Join node, List<EquiJoinClause> clauses) {
        this.joins.put(node, clauses);
    }

    public List<EquiJoinClause> getJoinCriteria(Join join) {
        return this.joins.get(join);
    }

    public void addInPredicates(Query node, Set<InPredicate> inPredicates) {
        this.inPredicates.putAll((Object)node, inPredicates);
    }

    public void addInPredicates(QuerySpecification node, Set<InPredicate> inPredicates) {
        this.inPredicates.putAll((Object)node, inPredicates);
    }

    public Set<InPredicate> getInPredicates(Query node) {
        return this.inPredicates.get((Object)node);
    }

    public Set<InPredicate> getInPredicates(QuerySpecification node) {
        return this.inPredicates.get((Object)node);
    }

    public void addJoinInPredicates(Join node, JoinInPredicates joinInPredicates) {
        this.joinInPredicates.put(node, joinInPredicates);
    }

    public JoinInPredicates getJoinInPredicates(Join node) {
        return this.joinInPredicates.get(node);
    }

    public void setWindowFunctions(QuerySpecification node, List<FunctionCall> functions) {
        this.windowFunctions.put(node, functions);
    }

    public Map<QuerySpecification, List<FunctionCall>> getWindowFunctions() {
        return this.windowFunctions;
    }

    public List<FunctionCall> getWindowFunctions(QuerySpecification query) {
        return this.windowFunctions.get(query);
    }

    public void setOutputDescriptor(TupleDescriptor descriptor) {
        this.outputDescriptor = descriptor;
    }

    public TupleDescriptor getOutputDescriptor() {
        return this.outputDescriptor;
    }

    public void setOutputDescriptor(Node node, TupleDescriptor descriptor) {
        this.outputDescriptors.put(node, descriptor);
    }

    public TupleDescriptor getOutputDescriptor(Node node) {
        Preconditions.checkState((boolean)this.outputDescriptors.containsKey(node), (String)"Output descriptor missing for %s. Broken analysis?", (Object[])new Object[]{node});
        return this.outputDescriptors.get(node);
    }

    public TableHandle getTableHandle(Table table) {
        return this.tables.get(table);
    }

    public void registerTable(Table table, TableHandle handle) {
        this.tables.put(table, handle);
    }

    public FunctionInfo getFunctionInfo(FunctionCall function) {
        return this.functionInfo.get(function);
    }

    public void addFunctionInfos(IdentityHashMap<FunctionCall, FunctionInfo> infos) {
        this.functionInfo.putAll(infos);
    }

    public void addTypes(IdentityHashMap<Expression, Type> types) {
        this.types.putAll(types);
    }

    public Expression getHaving(QuerySpecification query) {
        return this.having.get(query);
    }

    public void setColumn(Field field, ColumnHandle handle) {
        this.columns.put(field, handle);
    }

    public ColumnHandle getColumn(Field field) {
        return this.columns.get(field);
    }

    public void setDestination(QualifiedTableName destination) {
        this.destination = destination;
    }

    public QualifiedTableName getDestination() {
        return this.destination;
    }

    public Optional<Integer> getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setDoRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public boolean isDoRefresh() {
        return this.refresh;
    }

    public void setRefreshInterval(Optional<Integer> refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public Query getNamedQuery(Table table) {
        return this.namedQueries.get(table);
    }

    public void registerNamedQuery(Table tableReference, Query query) {
        Preconditions.checkNotNull((Object)tableReference, (Object)"tableReference is null");
        Preconditions.checkNotNull((Object)query, (Object)"query is null");
        this.namedQueries.put(tableReference, query);
    }

    public void setSampleRatio(SampledRelation relation, double ratio) {
        this.sampleRatios.put(relation, ratio);
    }

    public double getSampleRatio(SampledRelation relation) {
        Preconditions.checkState((boolean)this.sampleRatios.containsKey(relation), (String)"Sample ratio missing for %s. Broken analysis?", (Object[])new Object[]{relation});
        return this.sampleRatios.get(relation);
    }

    public static class JoinInPredicates {
        private final Set<InPredicate> leftInPredicates;
        private final Set<InPredicate> rightInPredicates;

        public JoinInPredicates(Set<InPredicate> leftInPredicates, Set<InPredicate> rightInPredicates) {
            this.leftInPredicates = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(leftInPredicates, (Object)"leftInPredicates is null")));
            this.rightInPredicates = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(rightInPredicates, (Object)"rightInPredicates is null")));
        }

        public Set<InPredicate> getLeftInPredicates() {
            return this.leftInPredicates;
        }

        public Set<InPredicate> getRightInPredicates() {
            return this.rightInPredicates;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.leftInPredicates, this.rightInPredicates});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            JoinInPredicates other = (JoinInPredicates)obj;
            return Objects.equal(this.leftInPredicates, other.leftInPredicates) && Objects.equal(this.rightInPredicates, other.rightInPredicates);
        }
    }
}

