/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.execution.DataSource;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.Partition;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.split.ExpressionUtil;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.LookupSymbolResolver;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class SplitManager {
    private static final Logger log = Logger.get(SplitManager.class);
    private final Metadata metadata;
    private final Set<ConnectorSplitManager> splitManagers = Sets.newSetFromMap(new ConcurrentHashMap());

    @Inject
    public SplitManager(Metadata metadata, Set<ConnectorSplitManager> splitManagers) {
        this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        this.splitManagers.addAll(splitManagers);
    }

    public void addConnectorSplitManager(ConnectorSplitManager connectorSplitManager) {
        this.splitManagers.add(connectorSplitManager);
    }

    public DataSource getSplits(Session session, TableHandle handle, Expression predicate, Expression upstreamHint, Predicate<Partition> partitionPredicate, Map<Symbol, ColumnHandle> mappings) {
        List<Partition> partitions = this.getPartitions(session, handle, ExpressionUtils.and(predicate, upstreamHint), partitionPredicate, mappings);
        ConnectorSplitManager connectorSplitManager = this.getConnectorSplitManager(handle);
        String connectorId = connectorSplitManager.getConnectorId();
        return new DataSource(connectorId, connectorSplitManager.getPartitionSplits(handle, partitions));
    }

    private List<Partition> getPartitions(Session session, TableHandle table, Expression predicate, Predicate<Partition> partitionPredicate, Map<Symbol, ColumnHandle> mappings) {
        Stopwatch partitionTimer = new Stopwatch();
        partitionTimer.start();
        ImmutableBiMap symbolToColumn = ImmutableBiMap.copyOf(mappings);
        Object partitions = this.getCandidatePartitions(table, predicate, (Map<Symbol, ColumnHandle>)symbolToColumn);
        log.debug("Partition retrieval, table %s (%d partitions): %dms", new Object[]{table, partitions.size(), partitionTimer.elapsed(TimeUnit.MILLISECONDS)});
        partitions = ImmutableList.copyOf((Iterable)Iterables.filter(partitions, partitionPredicate));
        log.debug("Partition filter, table %s (%d partitions): %dms", new Object[]{table, partitions.size(), partitionTimer.elapsed(TimeUnit.MILLISECONDS)});
        partitions = this.prunePartitions(session, (List<Partition>)partitions, predicate, (Map<ColumnHandle, Symbol>)symbolToColumn.inverse());
        log.debug("Partition pruning, table %s (%d partitions): %dms", new Object[]{table, partitions.size(), partitionTimer.elapsed(TimeUnit.MILLISECONDS)});
        return partitions;
    }

    private List<Partition> getCandidatePartitions(TableHandle table, Expression predicate, Map<Symbol, ColumnHandle> symbolToColumnName) {
        Optional<Map<ColumnHandle, Object>> bindings = ExpressionUtil.extractConstantValues(predicate, symbolToColumnName);
        if (!bindings.isPresent()) {
            return ImmutableList.of();
        }
        return this.getPartitions(table, bindings);
    }

    public List<Partition> getPartitions(TableHandle table, Optional<Map<ColumnHandle, Object>> bindings) {
        Preconditions.checkNotNull((Object)table, (Object)"table is null");
        return this.getConnectorSplitManager(table).getPartitions(table, (Map)bindings.or((Object)ImmutableMap.of()));
    }

    private List<Partition> prunePartitions(Session session, List<Partition> partitions, Expression predicate, Map<ColumnHandle, Symbol> columnToSymbol) {
        ImmutableList.Builder partitionBuilder = ImmutableList.builder();
        for (Partition partition : partitions) {
            if (this.shouldPrunePartition(session, partition, predicate, columnToSymbol)) continue;
            partitionBuilder.add((Object)partition);
        }
        return partitionBuilder.build();
    }

    private boolean shouldPrunePartition(Session session, Partition partition, Expression predicate, Map<ColumnHandle, Symbol> columnToSymbol) {
        ImmutableMap.Builder assignments = ImmutableMap.builder();
        for (Map.Entry entry : partition.getKeys().entrySet()) {
            ColumnHandle columnHandle = (ColumnHandle)entry.getKey();
            if (!columnToSymbol.containsKey(columnHandle)) continue;
            Symbol symbol = columnToSymbol.get(columnHandle);
            assignments.put((Object)symbol, entry.getValue());
        }
        LookupSymbolResolver inputs = new LookupSymbolResolver((Map<Symbol, Object>)assignments.build());
        for (Expression expression : ExpressionUtils.extractConjuncts(predicate)) {
            ExpressionInterpreter optimizer = ExpressionInterpreter.expressionOptimizer(expression, this.metadata, session);
            Object optimized = optimizer.optimize(inputs);
            if (!Boolean.FALSE.equals(optimized) && optimized != null) continue;
            return true;
        }
        return false;
    }

    private ConnectorSplitManager getConnectorSplitManager(TableHandle handle) {
        for (ConnectorSplitManager connectorSplitManager : this.splitManagers) {
            if (!connectorSplitManager.canHandle(handle)) continue;
            return connectorSplitManager;
        }
        throw new IllegalArgumentException("No split manager for " + handle);
    }
}

