/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Split;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class NativeSplit
implements Split {
    private final long shardId;
    private final List<HostAddress> addresses;

    @JsonCreator
    public NativeSplit(@JsonProperty(value="shardId") long shardId, @JsonProperty(value="addresses") List<HostAddress> addresses) {
        Preconditions.checkArgument((shardId >= 0L ? 1 : 0) != 0, (Object)"shard id must be at least zero");
        this.shardId = shardId;
        Preconditions.checkNotNull(addresses, (Object)"addresses is null");
        this.addresses = ImmutableList.copyOf(addresses);
    }

    @JsonProperty
    public boolean isRemotelyAccessible() {
        return false;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    @JsonProperty
    public long getShardId() {
        return this.shardId;
    }

    public Object getInfo() {
        return this;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("shardId", this.shardId).add("hosts", this.addresses).toString();
    }
}

