/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.block.BlockIterable;
import com.facebook.presto.metadata.LocalStorageManager;
import com.facebook.presto.metadata.NativeColumnHandle;
import com.facebook.presto.operator.AlignmentOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Split;
import com.facebook.presto.split.ConnectorDataStreamProvider;
import com.facebook.presto.split.NativeSplit;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;

public class NativeDataStreamProvider
implements ConnectorDataStreamProvider {
    private final LocalStorageManager storageManager;

    @Inject
    public NativeDataStreamProvider(LocalStorageManager storageManager) {
        this.storageManager = (LocalStorageManager)Preconditions.checkNotNull((Object)storageManager, (Object)"storageManager is null");
    }

    @Override
    public boolean canHandle(Split split) {
        return split instanceof NativeSplit;
    }

    @Override
    public Operator createNewDataStream(OperatorContext operatorContext, Split split, List<ColumnHandle> columns) {
        return new AlignmentOperator(operatorContext, this.createChannels(split, columns));
    }

    private List<BlockIterable> createChannels(Split split, List<ColumnHandle> columns) {
        Preconditions.checkNotNull((Object)split, (Object)"split is null");
        Preconditions.checkArgument((boolean)(split instanceof NativeSplit), (String)"Split must be of type NativeType, not %s", (Object[])new Object[]{split.getClass().getName()});
        Preconditions.checkNotNull(columns, (Object)"columns is null");
        Preconditions.checkArgument((!columns.isEmpty() ? 1 : 0) != 0, (Object)"must provide at least one column");
        NativeSplit nativeSplit = (NativeSplit)split;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ColumnHandle column : columns) {
            Preconditions.checkArgument((boolean)(column instanceof NativeColumnHandle), (String)"column must be native, not %s", (Object[])new Object[]{column});
            builder.add((Object)this.storageManager.getBlocks(nativeSplit.getShardId(), column));
        }
        return builder.build();
    }
}

