/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class MappedRecordSet
implements RecordSet {
    private final RecordSet delegate;
    private final List<Integer> userToSystemFieldIndex;
    private final List<ColumnType> columnTypes;

    public MappedRecordSet(RecordSet delegate, List<Integer> userToSystemFieldIndex) {
        this.delegate = delegate;
        this.userToSystemFieldIndex = userToSystemFieldIndex;
        List delegateColumnTypes = delegate.getColumnTypes();
        ImmutableList.Builder columnTypes = ImmutableList.builder();
        for (int systemField : userToSystemFieldIndex) {
            Preconditions.checkArgument((systemField >= 0 && systemField < delegateColumnTypes.size() ? 1 : 0) != 0, (String)"Invalid system field %s", (Object[])new Object[]{systemField});
            columnTypes.add(delegateColumnTypes.get(systemField));
        }
        this.columnTypes = columnTypes.build();
    }

    public List<ColumnType> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new MappedRecordCursor(this.delegate.cursor(), this.userToSystemFieldIndex);
    }

    private static class MappedRecordCursor
    implements RecordCursor {
        private final RecordCursor delegate;
        private final List<Integer> userToSystemFieldIndex;

        private MappedRecordCursor(RecordCursor delegate, List<Integer> userToSystemFieldIndex) {
            this.delegate = delegate;
            this.userToSystemFieldIndex = ImmutableList.copyOf(userToSystemFieldIndex);
        }

        public long getTotalBytes() {
            return this.delegate.getTotalBytes();
        }

        public long getCompletedBytes() {
            return this.delegate.getCompletedBytes();
        }

        public ColumnType getType(int field) {
            return this.delegate.getType(field);
        }

        public boolean advanceNextPosition() {
            return this.delegate.advanceNextPosition();
        }

        public boolean getBoolean(int field) {
            return this.delegate.getBoolean(this.userFieldToSystemField(field));
        }

        public long getLong(int field) {
            return this.delegate.getLong(this.userFieldToSystemField(field));
        }

        public double getDouble(int field) {
            return this.delegate.getDouble(this.userFieldToSystemField(field));
        }

        public byte[] getString(int field) {
            return this.delegate.getString(this.userFieldToSystemField(field));
        }

        public boolean isNull(int field) {
            return this.delegate.isNull(this.userFieldToSystemField(field));
        }

        public void close() {
            this.delegate.close();
        }

        private int userFieldToSystemField(int field) {
            Preconditions.checkArgument((field >= 0 ? 1 : 0) != 0, (Object)"field is negative");
            Preconditions.checkArgument((field < this.userToSystemFieldIndex.size() ? 1 : 0) != 0);
            return this.userToSystemFieldIndex.get(field);
        }
    }
}

