/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.block.Block;
import com.facebook.presto.operator.Page;
import com.facebook.presto.serde.BlockEncoding;
import com.facebook.presto.serde.BlockEncodings;
import com.facebook.presto.serde.PagesWriter;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.io.InputSupplier;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;

public final class PagesSerde {
    private PagesSerde() {
    }

    public static PagesWriter createPagesWriter(final SliceOutput sliceOutput) {
        Preconditions.checkNotNull((Object)sliceOutput, (Object)"sliceOutput is null");
        return new PagesWriter(){
            private BlockEncoding[] blockEncodings;

            @Override
            public PagesWriter append(Page page) {
                int i;
                Block[] blocks;
                Preconditions.checkNotNull((Object)page, (Object)"page is null");
                if (this.blockEncodings == null) {
                    blocks = page.getBlocks();
                    this.blockEncodings = new BlockEncoding[blocks.length];
                    sliceOutput.writeInt(blocks.length);
                    for (i = 0; i < blocks.length; ++i) {
                        BlockEncoding blockEncoding;
                        Block block = blocks[i];
                        this.blockEncodings[i] = blockEncoding = block.getEncoding();
                        BlockEncodings.writeBlockEncoding(sliceOutput, blockEncoding);
                    }
                }
                sliceOutput.writeInt(page.getPositionCount());
                blocks = page.getBlocks();
                for (i = 0; i < blocks.length; ++i) {
                    this.blockEncodings[i].writeBlock(sliceOutput, blocks[i]);
                }
                return this;
            }
        };
    }

    public static void writePages(SliceOutput sliceOutput, Page ... pages) {
        PagesSerde.writePages(sliceOutput, Arrays.asList(pages).iterator());
    }

    public static void writePages(SliceOutput sliceOutput, Iterable<Page> pages) {
        PagesSerde.writePages(sliceOutput, pages.iterator());
    }

    public static void writePages(SliceOutput sliceOutput, Iterator<Page> pages) {
        PagesWriter pagesWriter = PagesSerde.createPagesWriter(sliceOutput);
        while (pages.hasNext()) {
            pagesWriter.append(pages.next());
        }
    }

    public Iterable<Page> readPages(final InputSupplier<SliceInput> sliceInputSupplier) {
        Preconditions.checkNotNull(sliceInputSupplier, (Object)"sliceInputSupplier is null");
        return new Iterable<Page>(){

            @Override
            public Iterator<Page> iterator() {
                try {
                    return PagesSerde.readPages((SliceInput)sliceInputSupplier.getInput());
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        };
    }

    public static Iterator<Page> readPages(SliceInput sliceInput) {
        Preconditions.checkNotNull((Object)sliceInput, (Object)"sliceInput is null");
        return new PagesReader(sliceInput);
    }

    private static class PagesReader
    extends AbstractIterator<Page> {
        private final BlockEncoding[] blockEncodings;
        private final SliceInput sliceInput;

        public PagesReader(SliceInput sliceInput) {
            this.sliceInput = sliceInput;
            int channelCount = sliceInput.readInt();
            this.blockEncodings = new BlockEncoding[channelCount];
            for (int i = 0; i < this.blockEncodings.length; ++i) {
                this.blockEncodings[i] = BlockEncodings.readBlockEncoding(sliceInput);
            }
        }

        protected Page computeNext() {
            if (!this.sliceInput.isReadable()) {
                return (Page)this.endOfData();
            }
            int positions = this.sliceInput.readInt();
            Block[] blocks = new Block[this.blockEncodings.length];
            for (int i = 0; i < blocks.length; ++i) {
                blocks[i] = this.blockEncodings[i].readBlock(this.sliceInput);
            }
            Page page = new Page(positions, blocks);
            return page;
        }
    }
}

