/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.serde.DictionaryEncoder;
import com.facebook.presto.serde.Encoder;
import com.facebook.presto.serde.RunLengthEncoder;
import com.facebook.presto.serde.SnappyEncoder;
import com.facebook.presto.serde.UncompressedEncoder;
import com.google.common.base.Preconditions;
import io.airlift.slice.SliceOutput;

public enum BlocksFileEncoding {
    RAW("raw"){

        @Override
        public Encoder createBlocksWriter(SliceOutput sliceOutput) {
            return new UncompressedEncoder(sliceOutput);
        }
    }
    ,
    RLE("rle"){

        @Override
        public Encoder createBlocksWriter(SliceOutput sliceOutput) {
            return new RunLengthEncoder(sliceOutput);
        }
    }
    ,
    DIC_RAW("dic-raw"){

        @Override
        public Encoder createBlocksWriter(SliceOutput sliceOutput) {
            return new DictionaryEncoder(new UncompressedEncoder(sliceOutput));
        }
    }
    ,
    DIC_RLE("dic-rle"){

        @Override
        public Encoder createBlocksWriter(SliceOutput sliceOutput) {
            return new DictionaryEncoder(new RunLengthEncoder(sliceOutput));
        }
    }
    ,
    SNAPPY("snappy"){

        @Override
        public Encoder createBlocksWriter(SliceOutput sliceOutput) {
            return new SnappyEncoder(sliceOutput);
        }
    };

    private final String name;

    private BlocksFileEncoding(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
    }

    public String getName() {
        return this.name;
    }

    public abstract Encoder createBlocksWriter(SliceOutput var1);
}

