/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.operator.window.WindowFunction;
import com.facebook.presto.tuple.TupleInfo;

public class PercentRankFunction
implements WindowFunction {
    private long totalCount;
    private long rank;
    private long count;

    @Override
    public TupleInfo getTupleInfo() {
        return TupleInfo.SINGLE_DOUBLE;
    }

    @Override
    public void reset(int partitionRowCount) {
        this.totalCount = partitionRowCount;
        this.rank = 0L;
        this.count = 1L;
    }

    @Override
    public void processRow(BlockBuilder output, boolean newPeerGroup, int peerGroupCount) {
        if (this.totalCount == 1L) {
            output.append(0.0);
            return;
        }
        if (newPeerGroup) {
            this.rank += this.count;
            this.count = 1L;
        } else {
            ++this.count;
        }
        output.append((double)(this.rank - 1L) / (double)(this.totalCount - 1L));
    }
}

