/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.Description;
import com.facebook.presto.operator.scalar.ScalarFunction;
import com.google.common.primitives.Doubles;
import java.util.concurrent.ThreadLocalRandom;

public final class MathFunctions {
    private MathFunctions() {
    }

    @Description(value="absolute value")
    @ScalarFunction
    public static long abs(long num) {
        return Math.abs(num);
    }

    @Description(value="absolute value")
    @ScalarFunction
    public static double abs(double num) {
        return Math.abs(num);
    }

    @Description(value="arc cosine")
    @ScalarFunction
    public static double acos(double num) {
        return Math.acos(num);
    }

    @Description(value="arc sine")
    @ScalarFunction
    public static double asin(double num) {
        return Math.asin(num);
    }

    @Description(value="arc tangent")
    @ScalarFunction
    public static double atan(double num) {
        return Math.atan(num);
    }

    @Description(value="arc tangent of given fraction")
    @ScalarFunction
    public static double atan2(double num1, double num2) {
        return Math.atan2(num1, num2);
    }

    @Description(value="cube root")
    @ScalarFunction
    public static double cbrt(double num) {
        return Math.cbrt(num);
    }

    @Description(value="round up to nearest integer")
    @ScalarFunction(alias={"ceil"})
    public static long ceiling(long num) {
        return num;
    }

    @Description(value="round up to nearest integer")
    @ScalarFunction(alias={"ceil"})
    public static double ceiling(double num) {
        return Math.ceil(num);
    }

    @Description(value="cosine")
    @ScalarFunction
    public static double cos(double num) {
        return Math.cos(num);
    }

    @Description(value="hyperbolic cosine")
    @ScalarFunction
    public static double cosh(double num) {
        return Math.cosh(num);
    }

    @Description(value="Euler's number")
    @ScalarFunction
    public static double e() {
        return Math.E;
    }

    @Description(value="Euler's number raised to the given power")
    @ScalarFunction
    public static double exp(double num) {
        return Math.exp(num);
    }

    @Description(value="round down to nearest integer")
    @ScalarFunction
    public static long floor(long num) {
        return num;
    }

    @Description(value="round down to nearest integer")
    @ScalarFunction
    public static double floor(double num) {
        return Math.floor(num);
    }

    @Description(value="natural logarithm")
    @ScalarFunction
    public static double ln(double num) {
        return Math.log(num);
    }

    @Description(value="logarithm to base 2")
    @ScalarFunction
    public static double log2(double num) {
        return Math.log(num) / Math.log(2.0);
    }

    @Description(value="logarithm to base 10")
    @ScalarFunction
    public static double log10(double num) {
        return Math.log10(num);
    }

    @Description(value="logarithm to given base")
    @ScalarFunction
    public static double log(double num, double base) {
        return Math.log(num) / Math.log(base);
    }

    @Description(value="remainder of given quotient")
    @ScalarFunction
    public static long mod(long num1, long num2) {
        return num1 % num2;
    }

    @Description(value="remainder of given quotient")
    @ScalarFunction
    public static double mod(double num1, double num2) {
        return num1 % num2;
    }

    @Description(value="the constant Pi")
    @ScalarFunction
    public static double pi() {
        return Math.PI;
    }

    @Description(value="value raised to the power of exponent")
    @ScalarFunction
    public static double pow(double num, double exponent) {
        return Math.pow(num, exponent);
    }

    @Description(value="a pseudo-random value")
    @ScalarFunction(alias={"rand"}, deterministic=false)
    public static double random() {
        return ThreadLocalRandom.current().nextDouble();
    }

    @Description(value="round to nearest integer")
    @ScalarFunction
    public static long round(long num) {
        return MathFunctions.round(num, 0L);
    }

    @Description(value="round to nearest integer")
    @ScalarFunction
    public static long round(long num, long decimals) {
        return num;
    }

    @Description(value="round to nearest integer")
    @ScalarFunction
    public static double round(double num) {
        return MathFunctions.round(num, 0L);
    }

    @Description(value="round to given number of decimal places")
    @ScalarFunction
    public static double round(double num, long decimals) {
        if (num == 0.0) {
            return 0.0;
        }
        if (num < 0.0) {
            return -MathFunctions.round(-num, decimals);
        }
        double factor = Math.pow(10.0, decimals);
        return Math.floor(num * factor + 0.5) / factor;
    }

    @Description(value="sine")
    @ScalarFunction
    public static double sin(double num) {
        return Math.sin(num);
    }

    @Description(value="square root")
    @ScalarFunction
    public static double sqrt(double num) {
        return Math.sqrt(num);
    }

    @Description(value="tangent")
    @ScalarFunction
    public static double tan(double num) {
        return Math.tan(num);
    }

    @Description(value="hyperbolic tangent")
    @ScalarFunction
    public static double tanh(double num) {
        return Math.tanh(num);
    }

    @Description(value="test if value is not-a-number")
    @ScalarFunction(value="is_nan")
    public static boolean isNaN(double num) {
        return Double.isNaN(num);
    }

    @Description(value="test if value is finite")
    @ScalarFunction
    public static boolean isFinite(double num) {
        return Doubles.isFinite((double)num);
    }

    @Description(value="test if value is infinite")
    @ScalarFunction
    public static boolean isInfinite(double num) {
        return Double.isInfinite(num);
    }

    @Description(value="constant representing not-a-number")
    @ScalarFunction(value="nan")
    public static double NaN() {
        return Double.NaN;
    }

    @Description(value="Infinity")
    @ScalarFunction
    public static double infinity() {
        return Double.POSITIVE_INFINITY;
    }
}

