/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.instruction.Constant;
import com.facebook.presto.operator.scalar.JsonExtract;
import com.facebook.presto.operator.scalar.ScalarFunction;
import com.facebook.presto.sql.gen.DefaultFunctionBinder;
import com.facebook.presto.sql.gen.FunctionBinder;
import com.facebook.presto.sql.gen.FunctionBinding;
import com.facebook.presto.sql.gen.TypedByteCodeNode;
import com.facebook.presto.util.ThreadLocalCache;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Doubles;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public final class JsonFunctions {
    private static final String JSON_EXTRACT_SCALAR_FUNCTION_NAME = "json_extract_scalar";
    private static final String JSON_EXTRACT_FUNCTION_NAME = "json_extract";
    private static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);

    private JsonFunctions() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @ScalarFunction
    public static Long jsonArrayLength(Slice json) {
        try (JsonParser parser = JSON_FACTORY.createJsonParser((InputStream)json.getInput());){
            if (parser.nextToken() != JsonToken.START_ARRAY) {
                Long l = null;
                return l;
            }
            long length = 0L;
            while (true) {
                JsonToken token;
                if ((token = parser.nextToken()) == null) {
                    Long l = null;
                    return l;
                }
                if (token == JsonToken.END_ARRAY) {
                    Long l = length;
                    return l;
                }
                parser.skipChildren();
                ++length;
                continue;
                break;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @ScalarFunction
    public static Boolean jsonArrayContains(Slice json, boolean value) {
        try (JsonParser parser = JSON_FACTORY.createJsonParser((InputStream)json.getInput());){
            if (parser.nextToken() != JsonToken.START_ARRAY) {
                Boolean bl = null;
                return bl;
            }
            while (true) {
                JsonToken token;
                if ((token = parser.nextToken()) == null) {
                    Boolean bl = null;
                    return bl;
                }
                if (token == JsonToken.END_ARRAY) {
                    Boolean bl = false;
                    return bl;
                }
                parser.skipChildren();
                if (token == JsonToken.VALUE_TRUE && value || token == JsonToken.VALUE_FALSE && !value) {
                    Boolean bl = true;
                    return bl;
                }
                continue;
                break;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @ScalarFunction
    public static Boolean jsonArrayContains(Slice json, long value) {
        try (JsonParser parser = JSON_FACTORY.createJsonParser((InputStream)json.getInput());){
            if (parser.nextToken() != JsonToken.START_ARRAY) {
                Boolean bl = null;
                return bl;
            }
            while (true) {
                JsonToken token;
                if ((token = parser.nextToken()) == null) {
                    Boolean bl = null;
                    return bl;
                }
                if (token == JsonToken.END_ARRAY) {
                    Boolean bl = false;
                    return bl;
                }
                parser.skipChildren();
                if (token == JsonToken.VALUE_NUMBER_INT && (parser.getNumberType() == JsonParser.NumberType.INT || parser.getNumberType() == JsonParser.NumberType.LONG) && parser.getLongValue() == value) {
                    Boolean bl = true;
                    return bl;
                }
                continue;
                break;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @ScalarFunction
    public static Boolean jsonArrayContains(Slice json, double value) {
        if (!Doubles.isFinite((double)value)) {
            return false;
        }
        try (JsonParser parser = JSON_FACTORY.createJsonParser((InputStream)json.getInput());){
            if (parser.nextToken() != JsonToken.START_ARRAY) {
                Boolean bl = null;
                return bl;
            }
            while (true) {
                JsonToken token;
                if ((token = parser.nextToken()) == null) {
                    Boolean bl = null;
                    return bl;
                }
                if (token == JsonToken.END_ARRAY) {
                    Boolean bl = false;
                    return bl;
                }
                parser.skipChildren();
                if (token == JsonToken.VALUE_NUMBER_FLOAT && parser.getDoubleValue() == value && Doubles.isFinite((double)parser.getDoubleValue())) {
                    Boolean bl = true;
                    return bl;
                }
                continue;
                break;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @ScalarFunction
    public static Boolean jsonArrayContains(Slice json, Slice value) {
        String valueString = value.toString(Charsets.UTF_8);
        try (JsonParser parser = JSON_FACTORY.createJsonParser((InputStream)json.getInput());){
            if (parser.nextToken() != JsonToken.START_ARRAY) {
                Boolean bl = null;
                return bl;
            }
            while (true) {
                JsonToken token;
                if ((token = parser.nextToken()) == null) {
                    Boolean bl = null;
                    return bl;
                }
                if (token == JsonToken.END_ARRAY) {
                    Boolean bl = false;
                    return bl;
                }
                parser.skipChildren();
                if (token == JsonToken.VALUE_STRING && valueString.equals(parser.getValueAsString())) {
                    Boolean bl = true;
                    return bl;
                }
                continue;
                break;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    @ScalarFunction(value="json_extract_scalar", functionBinder=JsonFunctionBinder.class)
    public static Slice jsonExtractScalar(Slice json, Slice jsonPath) {
        try {
            return JsonExtract.extractScalar(json, jsonPath);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @ScalarFunction(value="json_extract", functionBinder=JsonFunctionBinder.class)
    public static Slice jsonExtract(Slice json, Slice jsonPath) {
        try {
            return JsonExtract.extractJson(json, jsonPath);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static class JsonFunctionBinder
    implements FunctionBinder {
        private static final MethodHandle constantJsonExtract;
        private static final MethodHandle dynamicJsonExtract;

        @Override
        public FunctionBinding bindFunction(long bindingId, String name, ByteCodeNode getSessionByteCode, List<TypedByteCodeNode> arguments) {
            MethodHandle methodHandle;
            TypedByteCodeNode patternNode = arguments.get(1);
            if (patternNode.getNode() instanceof Constant) {
                JsonExtract.JsonExtractor jsonExtractor;
                Slice patternSlice = (Slice)((Constant)patternNode.getNode()).getValue();
                String pattern = patternSlice.toString(Charsets.UTF_8);
                switch (name) {
                    case "json_extract_scalar": {
                        jsonExtractor = JsonExtract.generateExtractor(pattern, true);
                        break;
                    }
                    case "json_extract": {
                        jsonExtractor = JsonExtract.generateExtractor(pattern, false);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported method " + name);
                    }
                }
                methodHandle = MethodHandles.insertArguments(constantJsonExtract, 1, jsonExtractor);
                arguments = new ArrayList<TypedByteCodeNode>((Collection<TypedByteCodeNode>)arguments);
                arguments.remove(1);
                arguments = ImmutableList.copyOf(arguments);
            } else {
                JsonExtract.JsonExtractCache cache;
                switch (name) {
                    case "json_extract_scalar": {
                        cache = new JsonExtract.JsonExtractCache(20, true);
                        break;
                    }
                    case "json_extract": {
                        cache = new JsonExtract.JsonExtractCache(20, false);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported method " + name);
                    }
                }
                methodHandle = dynamicJsonExtract.bindTo(cache);
            }
            return DefaultFunctionBinder.bindConstantArguments(bindingId, name, getSessionByteCode, arguments, methodHandle, true);
        }

        static {
            try {
                constantJsonExtract = MethodHandles.lookup().findStatic(JsonExtract.class, "extract", MethodType.methodType(Slice.class, Slice.class, JsonExtract.JsonExtractor.class));
                dynamicJsonExtract = MethodHandles.lookup().findStatic(JsonExtract.class, "extract", MethodType.methodType(Slice.class, ThreadLocalCache.class, Slice.class, Slice.class));
            }
            catch (ReflectiveOperationException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

