/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.aggregation.FixedWidthAggregationFunction;
import com.facebook.presto.tuple.TupleInfo;
import io.airlift.slice.Slice;

public class LongSumAggregation
implements FixedWidthAggregationFunction {
    public static final LongSumAggregation LONG_SUM = new LongSumAggregation();

    @Override
    public int getFixedSize() {
        return TupleInfo.SINGLE_LONG.getFixedSize();
    }

    @Override
    public TupleInfo getFinalTupleInfo() {
        return TupleInfo.SINGLE_LONG;
    }

    @Override
    public TupleInfo getIntermediateTupleInfo() {
        return TupleInfo.SINGLE_LONG;
    }

    @Override
    public void initialize(Slice valueSlice, int valueOffset) {
        TupleInfo.SINGLE_LONG.setNull(valueSlice, valueOffset, 0);
    }

    @Override
    public void addInput(BlockCursor cursor, int field, Slice valueSlice, int valueOffset) {
        if (cursor.isNull(field)) {
            return;
        }
        TupleInfo.SINGLE_LONG.setNotNull(valueSlice, valueOffset, 0);
        long currentValue = TupleInfo.SINGLE_LONG.getLong(valueSlice, valueOffset, 0);
        long newValue = cursor.getLong(field);
        TupleInfo.SINGLE_LONG.setLong(valueSlice, valueOffset, 0, currentValue + newValue);
    }

    @Override
    public void addInput(int positionCount, Block block, int field, Slice valueSlice, int valueOffset) {
        boolean hasNonNull = !TupleInfo.SINGLE_LONG.isNull(valueSlice, valueOffset);
        long sum = TupleInfo.SINGLE_LONG.getLong(valueSlice, valueOffset, 0);
        BlockCursor cursor = block.cursor();
        while (cursor.advanceNextPosition()) {
            if (cursor.isNull(field)) continue;
            hasNonNull = true;
            sum += cursor.getLong(field);
        }
        if (hasNonNull) {
            TupleInfo.SINGLE_LONG.setNotNull(valueSlice, valueOffset, 0);
            TupleInfo.SINGLE_LONG.setLong(valueSlice, valueOffset, 0, sum);
        }
    }

    @Override
    public void addIntermediate(BlockCursor cursor, int field, Slice valueSlice, int valueOffset) {
        this.addInput(cursor, field, valueSlice, valueOffset);
    }

    @Override
    public void evaluateIntermediate(Slice valueSlice, int valueOffset, BlockBuilder output) {
        this.evaluateFinal(valueSlice, valueOffset, output);
    }

    @Override
    public void evaluateFinal(Slice valueSlice, int valueOffset, BlockBuilder output) {
        if (!TupleInfo.SINGLE_LONG.isNull(valueSlice, valueOffset, 0)) {
            long currentValue = TupleInfo.SINGLE_LONG.getLong(valueSlice, valueOffset, 0);
            output.append(currentValue);
        } else {
            output.appendNull();
        }
    }
}

