/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.aggregation.FixedWidthAggregationFunction;
import com.facebook.presto.tuple.TupleInfo;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public class LongAverageAggregation
implements FixedWidthAggregationFunction {
    public static final LongAverageAggregation LONG_AVERAGE = new LongAverageAggregation();
    private static final TupleInfo TUPLE_INFO = new TupleInfo(TupleInfo.Type.FIXED_INT_64, TupleInfo.Type.DOUBLE);

    @Override
    public int getFixedSize() {
        return TUPLE_INFO.getFixedSize();
    }

    @Override
    public TupleInfo getFinalTupleInfo() {
        return TupleInfo.SINGLE_DOUBLE;
    }

    @Override
    public TupleInfo getIntermediateTupleInfo() {
        return TupleInfo.SINGLE_VARBINARY;
    }

    @Override
    public void initialize(Slice valueSlice, int valueOffset) {
        TUPLE_INFO.setNull(valueSlice, valueOffset, 0);
    }

    @Override
    public void addInput(BlockCursor cursor, int field, Slice valueSlice, int valueOffset) {
        if (cursor.isNull(field)) {
            return;
        }
        TUPLE_INFO.setNotNull(valueSlice, valueOffset, 0);
        TUPLE_INFO.setLong(valueSlice, valueOffset, 0, TUPLE_INFO.getLong(valueSlice, valueOffset, 0) + 1L);
        long newValue = cursor.getLong(field);
        TUPLE_INFO.setDouble(valueSlice, valueOffset, 1, TUPLE_INFO.getDouble(valueSlice, valueOffset, 1) + (double)newValue);
    }

    @Override
    public void addInput(int positionCount, Block block, int field, Slice valueSlice, int valueOffset) {
        boolean hasNonNull = !TUPLE_INFO.isNull(valueSlice, valueOffset);
        long count = TUPLE_INFO.getLong(valueSlice, valueOffset, 0);
        double sum = TUPLE_INFO.getDouble(valueSlice, valueOffset, 1);
        BlockCursor cursor = block.cursor();
        while (cursor.advanceNextPosition()) {
            if (cursor.isNull(field)) continue;
            hasNonNull = true;
            ++count;
            sum += (double)cursor.getLong(field);
        }
        if (hasNonNull) {
            TUPLE_INFO.setNotNull(valueSlice, valueOffset, 0);
            TUPLE_INFO.setLong(valueSlice, valueOffset, 0, count);
            TUPLE_INFO.setDouble(valueSlice, valueOffset, 1, sum);
        }
    }

    @Override
    public void addIntermediate(BlockCursor cursor, int field, Slice valueSlice, int valueOffset) {
        if (cursor.isNull(field)) {
            return;
        }
        TUPLE_INFO.setNotNull(valueSlice, valueOffset, 0);
        Slice value = cursor.getSlice(field);
        long count = value.getLong(0);
        double sum = value.getDouble(8);
        TUPLE_INFO.setLong(valueSlice, valueOffset, 0, TUPLE_INFO.getLong(valueSlice, valueOffset, 0) + count);
        TUPLE_INFO.setDouble(valueSlice, valueOffset, 1, TUPLE_INFO.getDouble(valueSlice, valueOffset, 1) + sum);
    }

    @Override
    public void evaluateIntermediate(Slice valueSlice, int valueOffset, BlockBuilder output) {
        if (!TUPLE_INFO.isNull(valueSlice, valueOffset, 0)) {
            Slice value = Slices.allocate((int)16);
            value.setLong(0, TUPLE_INFO.getLong(valueSlice, valueOffset, 0));
            value.setDouble(8, TUPLE_INFO.getDouble(valueSlice, valueOffset, 1));
            output.append(value);
        } else {
            output.appendNull();
        }
    }

    @Override
    public void evaluateFinal(Slice valueSlice, int valueOffset, BlockBuilder output) {
        if (!TUPLE_INFO.isNull(valueSlice, valueOffset, 0)) {
            long count = TUPLE_INFO.getLong(valueSlice, valueOffset, 0);
            double sum = TUPLE_INFO.getDouble(valueSlice, valueOffset, 1);
            output.append(sum / (double)count);
        } else {
            output.appendNull();
        }
    }
}

