/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.aggregation.FixedWidthAggregationFunction;
import com.facebook.presto.tuple.TupleInfo;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public class LongApproximateAverageAggregation
implements FixedWidthAggregationFunction {
    public static final LongApproximateAverageAggregation LONG_APPROX_AVERAGE = new LongApproximateAverageAggregation();
    static final TupleInfo APPROX_AVG_CONTEXT_INFO = new TupleInfo(TupleInfo.Type.FIXED_INT_64, TupleInfo.Type.DOUBLE, TupleInfo.Type.DOUBLE);

    @Override
    public int getFixedSize() {
        return APPROX_AVG_CONTEXT_INFO.getFixedSize();
    }

    @Override
    public TupleInfo getFinalTupleInfo() {
        return TupleInfo.SINGLE_VARBINARY;
    }

    @Override
    public TupleInfo getIntermediateTupleInfo() {
        return TupleInfo.SINGLE_VARBINARY;
    }

    @Override
    public void initialize(Slice valueSlice, int valueOffset) {
        APPROX_AVG_CONTEXT_INFO.setNull(valueSlice, valueOffset, 0);
        APPROX_AVG_CONTEXT_INFO.setNotNull(valueSlice, valueOffset, 1);
        APPROX_AVG_CONTEXT_INFO.setDouble(valueSlice, valueOffset, 1, 0.0);
        APPROX_AVG_CONTEXT_INFO.setNotNull(valueSlice, valueOffset, 2);
        APPROX_AVG_CONTEXT_INFO.setDouble(valueSlice, valueOffset, 2, 0.0);
    }

    @Override
    public void addInput(BlockCursor cursor, int field, Slice valueSlice, int valueOffset) {
        boolean hasValue;
        boolean bl = hasValue = !APPROX_AVG_CONTEXT_INFO.isNull(valueSlice, valueOffset, 0);
        if (cursor.isNull(field)) {
            return;
        }
        long count = hasValue ? APPROX_AVG_CONTEXT_INFO.getLong(valueSlice, valueOffset, 0) : 0L;
        double mean = APPROX_AVG_CONTEXT_INFO.getDouble(valueSlice, valueOffset, 1);
        double m2 = APPROX_AVG_CONTEXT_INFO.getDouble(valueSlice, valueOffset, 2);
        double x = cursor.getLong(field);
        double delta = x - mean;
        m2 += delta * (x - (mean += delta / (double)(++count)));
        if (!hasValue) {
            APPROX_AVG_CONTEXT_INFO.setNotNull(valueSlice, valueOffset, 0);
        }
        APPROX_AVG_CONTEXT_INFO.setLong(valueSlice, valueOffset, 0, count);
        APPROX_AVG_CONTEXT_INFO.setDouble(valueSlice, valueOffset, 1, mean);
        APPROX_AVG_CONTEXT_INFO.setDouble(valueSlice, valueOffset, 2, m2);
    }

    @Override
    public void addInput(int positionCount, Block block, int field, Slice valueSlice, int valueOffset) {
        boolean hasValue = !APPROX_AVG_CONTEXT_INFO.isNull(valueSlice, valueOffset, 0);
        long count = hasValue ? APPROX_AVG_CONTEXT_INFO.getLong(valueSlice, valueOffset, 0) : 0L;
        double mean = APPROX_AVG_CONTEXT_INFO.getDouble(valueSlice, valueOffset, 1);
        double m2 = APPROX_AVG_CONTEXT_INFO.getDouble(valueSlice, valueOffset, 2);
        BlockCursor cursor = block.cursor();
        while (cursor.advanceNextPosition()) {
            if (cursor.isNull(field)) continue;
            hasValue = true;
            double x = cursor.getLong(field);
            double delta = x - mean;
            m2 += delta * (x - (mean += delta / (double)(++count)));
        }
        if (hasValue) {
            APPROX_AVG_CONTEXT_INFO.setNotNull(valueSlice, valueOffset, 0);
            APPROX_AVG_CONTEXT_INFO.setLong(valueSlice, valueOffset, 0, count);
            APPROX_AVG_CONTEXT_INFO.setDouble(valueSlice, valueOffset, 1, mean);
            APPROX_AVG_CONTEXT_INFO.setDouble(valueSlice, valueOffset, 2, m2);
        }
    }

    @Override
    public void addIntermediate(BlockCursor cursor, int field, Slice valueSlice, int valueOffset) {
        double totalM2;
        double totalMean;
        long totalCount;
        if (cursor.isNull(field)) {
            return;
        }
        Slice otherVariance = cursor.getSlice(field);
        long otherCount = APPROX_AVG_CONTEXT_INFO.getLong(otherVariance, 0);
        double otherMean = APPROX_AVG_CONTEXT_INFO.getDouble(otherVariance, 1);
        double otherM2 = APPROX_AVG_CONTEXT_INFO.getDouble(otherVariance, 2);
        if (APPROX_AVG_CONTEXT_INFO.isNull(valueSlice, valueOffset, 0)) {
            totalCount = otherCount;
            totalMean = otherMean;
            totalM2 = otherM2;
        } else {
            long count = APPROX_AVG_CONTEXT_INFO.getLong(valueSlice, valueOffset, 0);
            double mean = APPROX_AVG_CONTEXT_INFO.getDouble(valueSlice, valueOffset, 1);
            double m2 = APPROX_AVG_CONTEXT_INFO.getDouble(valueSlice, valueOffset, 2);
            double delta = otherMean - mean;
            totalCount = count + otherCount;
            totalMean = ((double)count * mean + (double)otherCount * otherMean) / (double)totalCount;
            totalM2 = m2 + otherM2 + delta * delta * (double)(count * otherCount) / (double)totalCount;
        }
        APPROX_AVG_CONTEXT_INFO.setNotNull(valueSlice, valueOffset, 0);
        APPROX_AVG_CONTEXT_INFO.setLong(valueSlice, valueOffset, 0, totalCount);
        APPROX_AVG_CONTEXT_INFO.setDouble(valueSlice, valueOffset, 1, totalMean);
        APPROX_AVG_CONTEXT_INFO.setDouble(valueSlice, valueOffset, 2, totalM2);
    }

    @Override
    public void evaluateIntermediate(Slice valueSlice, int valueOffset, BlockBuilder output) {
        boolean isEmpty = APPROX_AVG_CONTEXT_INFO.isNull(valueSlice, valueOffset, 0);
        if (isEmpty) {
            output.appendNull();
            return;
        }
        long count = APPROX_AVG_CONTEXT_INFO.getLong(valueSlice, valueOffset, 0);
        double mean = APPROX_AVG_CONTEXT_INFO.getDouble(valueSlice, valueOffset, 1);
        double m2 = APPROX_AVG_CONTEXT_INFO.getDouble(valueSlice, valueOffset, 2);
        Slice intermediateValue = Slices.allocate((int)APPROX_AVG_CONTEXT_INFO.getFixedSize());
        APPROX_AVG_CONTEXT_INFO.setNotNull(intermediateValue, 0);
        APPROX_AVG_CONTEXT_INFO.setLong(intermediateValue, 0, count);
        APPROX_AVG_CONTEXT_INFO.setDouble(intermediateValue, 1, mean);
        APPROX_AVG_CONTEXT_INFO.setDouble(intermediateValue, 2, m2);
        output.append(intermediateValue);
    }

    @Override
    public void evaluateFinal(Slice valueSlice, int valueOffset, BlockBuilder output) {
        if (!APPROX_AVG_CONTEXT_INFO.isNull(valueSlice, valueOffset, 0)) {
            long count = APPROX_AVG_CONTEXT_INFO.getLong(valueSlice, valueOffset, 0);
            double mean = APPROX_AVG_CONTEXT_INFO.getDouble(valueSlice, valueOffset, 1);
            double m2 = APPROX_AVG_CONTEXT_INFO.getDouble(valueSlice, valueOffset, 2);
            double variance = m2 / (double)count;
            double zScore = 2.575;
            StringBuilder sb = new StringBuilder();
            sb.append(mean);
            sb.append(" +/- ");
            sb.append(zScore * Math.sqrt(variance / (double)count));
            output.append(sb.toString());
        } else {
            output.appendNull();
        }
    }
}

