/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.aggregation.FixedWidthAggregationFunction;
import com.facebook.presto.tuple.TupleInfo;
import io.airlift.slice.Slice;

public class DoubleMaxAggregation
implements FixedWidthAggregationFunction {
    public static final DoubleMaxAggregation DOUBLE_MAX = new DoubleMaxAggregation();

    @Override
    public int getFixedSize() {
        return TupleInfo.SINGLE_DOUBLE.getFixedSize();
    }

    @Override
    public TupleInfo getFinalTupleInfo() {
        return TupleInfo.SINGLE_DOUBLE;
    }

    @Override
    public TupleInfo getIntermediateTupleInfo() {
        return TupleInfo.SINGLE_DOUBLE;
    }

    @Override
    public void initialize(Slice valueSlice, int valueOffset) {
        TupleInfo.SINGLE_DOUBLE.setNull(valueSlice, valueOffset, 0);
        TupleInfo.SINGLE_DOUBLE.setDouble(valueSlice, valueOffset, 0, Double.NEGATIVE_INFINITY);
    }

    @Override
    public void addInput(BlockCursor cursor, int field, Slice valueSlice, int valueOffset) {
        if (cursor.isNull(field)) {
            return;
        }
        TupleInfo.SINGLE_DOUBLE.setNotNull(valueSlice, valueOffset, 0);
        double currentValue = TupleInfo.SINGLE_DOUBLE.getDouble(valueSlice, valueOffset, 0);
        double newValue = cursor.getDouble(field);
        TupleInfo.SINGLE_DOUBLE.setDouble(valueSlice, valueOffset, 0, Math.max(currentValue, newValue));
    }

    @Override
    public void addInput(int positionCount, Block block, int field, Slice valueSlice, int valueOffset) {
        boolean hasNonNull = !TupleInfo.SINGLE_DOUBLE.isNull(valueSlice, valueOffset);
        double max = TupleInfo.SINGLE_DOUBLE.getDouble(valueSlice, valueOffset, 0);
        BlockCursor cursor = block.cursor();
        while (cursor.advanceNextPosition()) {
            if (cursor.isNull(field)) continue;
            hasNonNull = true;
            max = Math.max(max, cursor.getDouble(field));
        }
        if (hasNonNull) {
            TupleInfo.SINGLE_DOUBLE.setNotNull(valueSlice, valueOffset, 0);
            TupleInfo.SINGLE_DOUBLE.setDouble(valueSlice, valueOffset, 0, max);
        }
    }

    @Override
    public void addIntermediate(BlockCursor cursor, int field, Slice valueSlice, int valueOffset) {
        this.addInput(cursor, field, valueSlice, valueOffset);
    }

    @Override
    public void evaluateIntermediate(Slice valueSlice, int valueOffset, BlockBuilder output) {
        this.evaluateFinal(valueSlice, valueOffset, output);
    }

    @Override
    public void evaluateFinal(Slice valueSlice, int valueOffset, BlockBuilder output) {
        if (!TupleInfo.SINGLE_DOUBLE.isNull(valueSlice, valueOffset, 0)) {
            double currentValue = TupleInfo.SINGLE_DOUBLE.getDouble(valueSlice, valueOffset, 0);
            output.append(currentValue);
        } else {
            output.appendNull();
        }
    }
}

