/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.aggregation.FixedWidthAggregationFunction;
import com.facebook.presto.operator.aggregation.HyperLogLog;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import io.airlift.slice.Slice;

public class ApproximateCountDistinctAggregation
implements FixedWidthAggregationFunction {
    public static final ApproximateCountDistinctAggregation LONG_INSTANCE = new ApproximateCountDistinctAggregation(new LongHasher());
    public static final ApproximateCountDistinctAggregation DOUBLE_INSTANCE = new ApproximateCountDistinctAggregation(new DoubleHasher());
    public static final ApproximateCountDistinctAggregation VARBINARY_INSTANCE = new ApproximateCountDistinctAggregation(new SliceHasher());
    private static final HyperLogLog ESTIMATOR = new HyperLogLog(2048);
    private final CursorHasher hasher;

    public ApproximateCountDistinctAggregation(CursorHasher hasher) {
        Preconditions.checkNotNull((Object)hasher, (Object)"hasher is null");
        this.hasher = hasher;
    }

    public double getStandardError() {
        return ESTIMATOR.getStandardError();
    }

    @Override
    public int getFixedSize() {
        return 1 + ESTIMATOR.getSizeInBytes();
    }

    @Override
    public TupleInfo getFinalTupleInfo() {
        return TupleInfo.SINGLE_LONG;
    }

    @Override
    public TupleInfo getIntermediateTupleInfo() {
        return TupleInfo.SINGLE_VARBINARY;
    }

    @Override
    public void initialize(Slice valueSlice, int valueOffset) {
    }

    @Override
    public void addInput(int positionCount, Block block, int field, Slice valueSlice, int valueOffset) {
        boolean hasValue = false;
        BlockCursor cursor = block.cursor();
        while (cursor.advanceNextPosition()) {
            if (cursor.isNull(field)) continue;
            hasValue = true;
            long hash = this.hasher.hash(cursor, field);
            ESTIMATOR.update(hash, valueSlice, valueOffset + 1);
        }
        if (hasValue) {
            this.setNotNull(valueSlice, valueOffset);
        }
    }

    @Override
    public void addInput(BlockCursor cursor, int field, Slice valueSlice, int valueOffset) {
        if (cursor.isNull(field)) {
            return;
        }
        long hash = this.hasher.hash(cursor, field);
        ESTIMATOR.update(hash, valueSlice, valueOffset + 1);
        this.setNotNull(valueSlice, valueOffset);
    }

    @Override
    public void addIntermediate(BlockCursor cursor, int field, Slice valueSlice, int valueOffset) {
        if (cursor.isNull(field)) {
            return;
        }
        Slice input = cursor.getSlice(field);
        ESTIMATOR.mergeInto(valueSlice, valueOffset + 1, input, 0);
        this.setNotNull(valueSlice, valueOffset);
    }

    @Override
    public void evaluateIntermediate(Slice valueSlice, int valueOffset, BlockBuilder output) {
        if (this.isNull(valueSlice, valueOffset)) {
            output.appendNull();
        } else {
            Slice intermediate = valueSlice.slice(valueOffset + 1, ESTIMATOR.getSizeInBytes());
            output.append(intermediate);
        }
    }

    @Override
    public void evaluateFinal(Slice valueSlice, int valueOffset, BlockBuilder output) {
        if (this.isNull(valueSlice, valueOffset)) {
            output.append(0L);
            return;
        }
        output.append(ESTIMATOR.estimate(valueSlice, valueOffset + 1));
    }

    private boolean isNull(Slice valueSlice, int offset) {
        return valueSlice.getByte(offset) == 0;
    }

    private void setNotNull(Slice valueSlice, int offset) {
        valueSlice.setByte(offset, 1);
    }

    public static class SliceHasher
    implements CursorHasher {
        private static final HashFunction HASH = Hashing.murmur3_128();

        @Override
        public long hash(BlockCursor cursor, int field) {
            Slice value = cursor.getSlice(field);
            return HASH.hashBytes(value.getBytes()).asLong();
        }
    }

    public static class LongHasher
    implements CursorHasher {
        private static final HashFunction HASH = Hashing.murmur3_128();

        @Override
        public long hash(BlockCursor cursor, int field) {
            long value = cursor.getLong(field);
            return HASH.hashLong(value).asLong();
        }
    }

    public static class DoubleHasher
    implements CursorHasher {
        private static final HashFunction HASH = Hashing.murmur3_128();

        @Override
        public long hash(BlockCursor cursor, int field) {
            double value = cursor.getDouble(field);
            return HASH.hashLong(Double.doubleToLongBits(value)).asLong();
        }
    }

    public static interface CursorHasher {
        public long hash(BlockCursor var1, int var2);
    }
}

