/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.operator.ProjectionFunction;
import com.facebook.presto.tuple.Tuple;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.tuple.TupleReadable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;

public class TopNOperator
implements Operator {
    private static final int MAX_INITIAL_PRIORITY_QUEUE_SIZE = 10000;
    private static final DataSize OVERHEAD_PER_TUPLE = new DataSize(100.0, DataSize.Unit.BYTE);
    private final OperatorContext operatorContext;
    private final int n;
    private final int keyChannelIndex;
    private final List<ProjectionFunction> projections;
    private final Ordering<TupleReadable> ordering;
    private final List<TupleInfo> tupleInfos;
    private final TopNMemoryManager memoryManager;
    private final boolean partial;
    private final PageBuilder pageBuilder;
    private TopNBuilder topNBuilder;
    private boolean finishing;
    private Iterator<KeyAndTuples> outputIterator;

    public TopNOperator(OperatorContext operatorContext, int n, int keyChannelIndex, List<ProjectionFunction> projections, Ordering<TupleReadable> ordering, boolean partial) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (Object)"n must be greater than zero");
        this.n = n;
        Preconditions.checkArgument((keyChannelIndex >= 0 ? 1 : 0) != 0, (Object)"keyChannelIndex must be at least zero");
        this.keyChannelIndex = keyChannelIndex;
        this.projections = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(projections, (Object)"projections is null")));
        Preconditions.checkArgument((!projections.isEmpty() ? 1 : 0) != 0, (Object)"projections is empty");
        this.ordering = ((Ordering)Preconditions.checkNotNull(ordering, (Object)"ordering is null")).reverse();
        this.partial = partial;
        this.memoryManager = new TopNMemoryManager((OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null"));
        this.tupleInfos = TopNOperator.toTupleInfos(projections);
        this.pageBuilder = new PageBuilder(this.getTupleInfos());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<TupleInfo> getTupleInfos() {
        return this.tupleInfos;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.topNBuilder == null && (this.outputIterator == null || !this.outputIterator.hasNext());
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && this.outputIterator == null && (this.topNBuilder == null || !this.topNBuilder.isFull());
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        if (this.topNBuilder == null) {
            this.topNBuilder = new TopNBuilder(this.n, this.keyChannelIndex, this.ordering, this.memoryManager);
        }
        Preconditions.checkState((!this.topNBuilder.isFull() ? 1 : 0) != 0, (Object)"Aggregation buffer is full");
        this.topNBuilder.processPage(page);
    }

    @Override
    public Page getOutput() {
        if (this.outputIterator == null || !this.outputIterator.hasNext()) {
            if (this.topNBuilder == null) {
                return null;
            }
            if (!this.finishing && !this.topNBuilder.isFull()) {
                return null;
            }
            Preconditions.checkState((this.finishing || this.partial ? 1 : 0) != 0, (String)"Task exceeded max memory size of %s", (Object[])new Object[]{this.memoryManager.getMaxMemorySize()});
            this.outputIterator = this.topNBuilder.build();
            this.topNBuilder = null;
        }
        this.pageBuilder.reset();
        while (!this.pageBuilder.isFull() && this.outputIterator.hasNext()) {
            KeyAndTuples next = this.outputIterator.next();
            for (int i = 0; i < this.projections.size(); ++i) {
                this.projections.get(i).project(next.getTuples(), this.pageBuilder.getBlockBuilder(i));
            }
        }
        Page page = this.pageBuilder.build();
        return page;
    }

    private static List<TupleInfo> toTupleInfos(List<ProjectionFunction> projections) {
        ImmutableList.Builder tupleInfos = ImmutableList.builder();
        for (ProjectionFunction projection : projections) {
            tupleInfos.add((Object)projection.getTupleInfo());
        }
        return tupleInfos.build();
    }

    private static class KeyAndTuples {
        private final Tuple key;
        private final Tuple[] tuples;

        private KeyAndTuples(Tuple key, Tuple[] tuples) {
            this.key = key;
            this.tuples = tuples;
        }

        public Tuple getKey() {
            return this.key;
        }

        public Tuple[] getTuples() {
            return this.tuples;
        }

        public static Comparator<KeyAndTuples> keyComparator(final Comparator<TupleReadable> tupleReadableComparator) {
            return new Comparator<KeyAndTuples>(){

                @Override
                public int compare(KeyAndTuples o1, KeyAndTuples o2) {
                    return tupleReadableComparator.compare(o1.getKey(), o2.getKey());
                }
            };
        }
    }

    private static class KeyAndPosition {
        private final Tuple key;
        private final int position;

        private KeyAndPosition(Tuple key, int position) {
            this.key = key;
            this.position = position;
        }

        public Tuple getKey() {
            return this.key;
        }

        public int getPosition() {
            return this.position;
        }

        public static Comparator<KeyAndPosition> keyComparator(final Comparator<TupleReadable> tupleReadableComparator) {
            return new Comparator<KeyAndPosition>(){

                @Override
                public int compare(KeyAndPosition o1, KeyAndPosition o2) {
                    return tupleReadableComparator.compare(o1.getKey(), o2.getKey());
                }
            };
        }

        public static Comparator<KeyAndPosition> positionComparator() {
            return new Comparator<KeyAndPosition>(){

                @Override
                public int compare(KeyAndPosition o1, KeyAndPosition o2) {
                    return Long.compare(o1.getPosition(), o2.getPosition());
                }
            };
        }
    }

    public static class TopNMemoryManager {
        private final OperatorContext operatorContext;
        private long currentMemoryReservation;

        public TopNMemoryManager(OperatorContext operatorContext) {
            this.operatorContext = operatorContext;
        }

        public boolean canUse(long memorySize) {
            long delta = (memorySize -= this.operatorContext.getOperatorPreAllocatedMemory().toBytes()) - this.currentMemoryReservation;
            if (delta <= 0L) {
                return false;
            }
            if (!this.operatorContext.reserveMemory(delta)) {
                return true;
            }
            this.currentMemoryReservation = Math.max(this.currentMemoryReservation, memorySize);
            return false;
        }

        public Object getMaxMemorySize() {
            return this.operatorContext.getMaxMemorySize();
        }
    }

    private static class TopNBuilder {
        private final int n;
        private final int keyChannelIndex;
        private final Ordering<TupleReadable> ordering;
        private final TopNMemoryManager memoryManager;
        private final PriorityQueue<KeyAndTuples> globalCandidates;
        private long memorySize;

        private TopNBuilder(int n, int keyChannelIndex, Ordering<TupleReadable> ordering, TopNMemoryManager memoryManager) {
            this.n = n;
            this.keyChannelIndex = keyChannelIndex;
            this.ordering = ordering;
            this.memoryManager = memoryManager;
            this.globalCandidates = new PriorityQueue<KeyAndTuples>(Math.min(n, 10000), KeyAndTuples.keyComparator(ordering));
        }

        public void processPage(Page page) {
            Iterable<KeyAndPosition> keyAndPositions = this.computePageCandidatePositions(this.globalCandidates, page);
            long sizeDelta = this.mergeWithGlobalCandidates(this.globalCandidates, page, keyAndPositions);
            this.memorySize += sizeDelta;
        }

        private long mergeWithGlobalCandidates(PriorityQueue<KeyAndTuples> globalCandidates, Page page, Iterable<KeyAndPosition> pageValueAndPositions) {
            long sizeDelta = 0L;
            List positionSorted = Ordering.from(KeyAndPosition.positionComparator()).sortedCopy(pageValueAndPositions);
            Block[] blocks = page.getBlocks();
            BlockCursor[] cursors = new BlockCursor[blocks.length];
            for (int i = 0; i < blocks.length; ++i) {
                cursors[i] = blocks[i].cursor();
            }
            for (KeyAndPosition keyAndPosition : positionSorted) {
                for (BlockCursor cursor : cursors) {
                    Preconditions.checkState((boolean)cursor.advanceToPosition(keyAndPosition.getPosition()));
                }
                if (globalCandidates.size() < this.n) {
                    Tuple[] tuples;
                    for (Tuple tuple : tuples = this.getTuples(keyAndPosition, cursors)) {
                        sizeDelta += (long)tuple.size();
                    }
                    sizeDelta += OVERHEAD_PER_TUPLE.toBytes();
                    globalCandidates.add(new KeyAndTuples(keyAndPosition.getKey(), tuples));
                    continue;
                }
                if (this.ordering.compare((Object)keyAndPosition.getKey(), (Object)globalCandidates.peek().getKey()) <= 0) continue;
                KeyAndTuples previous = (KeyAndTuples)globalCandidates.remove();
                for (Tuple tuple : previous.getTuples()) {
                    sizeDelta -= (long)tuple.size();
                }
                Tuple[] tuples = this.getTuples(keyAndPosition, cursors);
                globalCandidates.add(new KeyAndTuples(keyAndPosition.getKey(), tuples));
                for (Tuple tuple : tuples) {
                    sizeDelta += (long)tuple.size();
                }
                sizeDelta += (long)keyAndPosition.getKey().size();
            }
            return sizeDelta;
        }

        private Iterable<KeyAndPosition> computePageCandidatePositions(PriorityQueue<KeyAndTuples> globalCandidates, Page page) {
            PriorityQueue<KeyAndPosition> pageCandidates = new PriorityQueue<KeyAndPosition>(Math.min(this.n, 10000), KeyAndPosition.keyComparator(this.ordering));
            KeyAndTuples smallestGlobalCandidate = globalCandidates.peek();
            BlockCursor cursor = page.getBlock(this.keyChannelIndex).cursor();
            while (cursor.advanceNextPosition()) {
                if (globalCandidates.size() >= this.n && this.ordering.compare((Object)cursor, (Object)smallestGlobalCandidate.getKey()) <= 0) continue;
                if (pageCandidates.size() < this.n) {
                    pageCandidates.add(new KeyAndPosition(cursor.getTuple(), cursor.getPosition()));
                    continue;
                }
                if (this.ordering.compare((Object)cursor, (Object)pageCandidates.peek().getKey()) <= 0) continue;
                pageCandidates.remove();
                pageCandidates.add(new KeyAndPosition(cursor.getTuple(), cursor.getPosition()));
            }
            return pageCandidates;
        }

        private Tuple[] getTuples(KeyAndPosition keyAndPosition, BlockCursor[] cursors) {
            Tuple[] tuples = new Tuple[cursors.length];
            for (int channel = 0; channel < cursors.length; ++channel) {
                tuples[channel] = channel == this.keyChannelIndex ? keyAndPosition.getKey() : cursors[channel].getTuple();
            }
            return tuples;
        }

        private boolean isFull() {
            return this.memoryManager.canUse(this.memorySize);
        }

        public Iterator<KeyAndTuples> build() {
            ImmutableList.Builder minSortedGlobalCandidates = ImmutableList.builder();
            while (!this.globalCandidates.isEmpty()) {
                minSortedGlobalCandidates.add(this.globalCandidates.remove());
            }
            return minSortedGlobalCandidates.build().reverse().iterator();
        }
    }

    public static class TopNOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final int n;
        private final int keyChannelIndex;
        private final List<ProjectionFunction> projections;
        private final Ordering<TupleReadable> ordering;
        private final boolean partial;
        private final List<TupleInfo> tupleInfos;
        private boolean closed;

        public TopNOperatorFactory(int operatorId, int n, int keyChannelIndex, List<ProjectionFunction> projections, Ordering<TupleReadable> ordering, boolean partial) {
            this.operatorId = operatorId;
            this.n = n;
            this.keyChannelIndex = keyChannelIndex;
            this.projections = projections;
            this.ordering = ordering;
            this.partial = partial;
            this.tupleInfos = TopNOperator.toTupleInfos(projections);
        }

        @Override
        public List<TupleInfo> getTupleInfos() {
            return this.tupleInfos;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, TopNOperator.class.getSimpleName());
            return new TopNOperator(operatorContext, this.n, this.keyChannelIndex, this.projections, this.ordering, this.partial);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

