/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.operator.ProjectionFunction;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.sql.tree.Input;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.tuple.TupleReadable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class ProjectionFunctions {
    public static ProjectionFunction singleColumn(TupleInfo.Type columnType, int channelIndex, int fieldIndex) {
        return new SingleColumnProjection(columnType, channelIndex, fieldIndex);
    }

    public static ProjectionFunction singleColumn(TupleInfo.Type columnType, Input input) {
        return new SingleColumnProjection(columnType, input.getChannel(), input.getField());
    }

    public static List<TupleInfo> toTupleInfos(List<ProjectionFunction> projections) {
        ImmutableList.Builder tupleInfos = ImmutableList.builder();
        for (ProjectionFunction projection : projections) {
            tupleInfos.add((Object)projection.getTupleInfo());
        }
        return tupleInfos.build();
    }

    public static ProjectionFunction concat(ProjectionFunction ... projectionFunctions) {
        return ProjectionFunctions.concat((Iterable<ProjectionFunction>)ImmutableList.copyOf((Object[])projectionFunctions));
    }

    public static ProjectionFunction concat(Iterable<ProjectionFunction> projections) {
        return new ConcatProjection(projections);
    }

    private static class ConcatProjection
    implements ProjectionFunction {
        private final List<ProjectionFunction> projections;
        private final TupleInfo tupleInfo;

        private ConcatProjection(Iterable<ProjectionFunction> projections) {
            this.projections = ImmutableList.copyOf(projections);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ProjectionFunction projection : projections) {
                builder.addAll(projection.getTupleInfo().getTypes());
            }
            this.tupleInfo = new TupleInfo((List<TupleInfo.Type>)builder.build());
        }

        @Override
        public TupleInfo getTupleInfo() {
            return this.tupleInfo;
        }

        @Override
        public void project(TupleReadable[] cursors, BlockBuilder output) {
            for (ProjectionFunction projection : this.projections) {
                projection.project(cursors, output);
            }
        }

        @Override
        public void project(RecordCursor cursor, BlockBuilder output) {
            for (ProjectionFunction projection : this.projections) {
                projection.project(cursor, output);
            }
        }
    }

    private static class SingleColumnProjection
    implements ProjectionFunction {
        private final TupleInfo.Type columnType;
        private final int channelIndex;
        private final int fieldIndex;
        private final TupleInfo info;

        public SingleColumnProjection(TupleInfo.Type columnType, int channelIndex, int fieldIndex) {
            Preconditions.checkNotNull((Object)columnType, (Object)"columnType is null");
            Preconditions.checkArgument((channelIndex >= 0 ? 1 : 0) != 0, (Object)"channelIndex is negative");
            Preconditions.checkArgument((fieldIndex >= 0 ? 1 : 0) != 0, (Object)"fieldIndex is negative");
            this.columnType = columnType;
            this.channelIndex = channelIndex;
            this.fieldIndex = fieldIndex;
            this.info = new TupleInfo(columnType);
        }

        @Override
        public TupleInfo getTupleInfo() {
            return this.info;
        }

        @Override
        public void project(TupleReadable[] cursors, BlockBuilder output) {
            if (!cursors[this.channelIndex].isNull(this.fieldIndex)) {
                switch (this.columnType) {
                    case BOOLEAN: {
                        output.append(cursors[this.channelIndex].getBoolean(this.fieldIndex));
                        return;
                    }
                    case FIXED_INT_64: {
                        output.append(cursors[this.channelIndex].getLong(this.fieldIndex));
                        return;
                    }
                    case VARIABLE_BINARY: {
                        output.append(cursors[this.channelIndex].getSlice(this.fieldIndex));
                        return;
                    }
                    case DOUBLE: {
                        output.append(cursors[this.channelIndex].getDouble(this.fieldIndex));
                        return;
                    }
                }
                throw new IllegalStateException("Unsupported type info " + this.info);
            }
            output.appendNull();
        }

        @Override
        public void project(RecordCursor cursor, BlockBuilder output) {
            Preconditions.checkArgument((this.fieldIndex == 0 ? 1 : 0) != 0, (Object)"field must be 0 for a record cursor projection");
            if (cursor.isNull(this.channelIndex)) {
                output.appendNull();
            } else {
                switch (this.columnType) {
                    case BOOLEAN: {
                        output.append(cursor.getBoolean(this.channelIndex));
                        break;
                    }
                    case FIXED_INT_64: {
                        output.append(cursor.getLong(this.channelIndex));
                        break;
                    }
                    case VARIABLE_BINARY: {
                        output.append(cursor.getString(this.channelIndex));
                        break;
                    }
                    case DOUBLE: {
                        output.append(cursor.getDouble(this.channelIndex));
                    }
                }
            }
        }
    }
}

