/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.uncompressed.UncompressedBlock;
import com.facebook.presto.operator.ChannelIndex;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.Page;
import com.facebook.presto.tuple.TupleInfo;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Swapper;
import it.unimi.dsi.fastutil.ints.AbstractIntComparator;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.util.List;

public class PagesIndex
implements Swapper {
    private final ChannelIndex[] indexes;
    private final List<TupleInfo> tupleInfos;
    private final OperatorContext operatorContext;
    private int positionCount;
    private long estimatedSize;

    public PagesIndex(List<TupleInfo> tupleInfos, int expectedPositions, OperatorContext operatorContext) {
        this.tupleInfos = tupleInfos;
        this.operatorContext = operatorContext;
        this.indexes = new ChannelIndex[tupleInfos.size()];
        for (int channel = 0; channel < this.indexes.length; ++channel) {
            this.indexes[channel] = new ChannelIndex(expectedPositions, tupleInfos.get(channel));
        }
    }

    public List<TupleInfo> getTupleInfos() {
        return this.tupleInfos;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public void addPage(Page page) {
        this.positionCount += page.getPositionCount();
        Block[] blocks = page.getBlocks();
        for (int channel = 0; channel < this.indexes.length; ++channel) {
            this.indexes[channel].indexBlock((UncompressedBlock)blocks[channel]);
        }
        this.estimatedSize = this.operatorContext.setMemoryReservation(this.calculateEstimatedSize());
    }

    public DataSize getEstimatedSize() {
        return new DataSize((double)this.estimatedSize, DataSize.Unit.BYTE);
    }

    private long calculateEstimatedSize() {
        long size = 0L;
        for (ChannelIndex channelIndex : this.indexes) {
            size += channelIndex.getEstimatedSize().toBytes();
        }
        return size;
    }

    public TupleInfo getTupleInfo(int channel) {
        return this.indexes[channel].getTupleInfo();
    }

    public ChannelIndex getIndex(int channel) {
        return this.indexes[channel];
    }

    public void swap(int a, int b) {
        for (ChannelIndex index : this.indexes) {
            index.swap(a, b);
        }
    }

    public void appendTupleTo(int channel, int position, BlockBuilder output) {
        this.indexes[channel].appendTo(position, output);
    }

    public void sort(int orderByChannel, int[] sortFields, boolean[] sortOrder) {
        ChannelIndex index = this.indexes[orderByChannel];
        MultiSliceFieldOrderedTupleComparator comparator = new MultiSliceFieldOrderedTupleComparator(sortFields, sortOrder, index);
        Arrays.quickSort((int)0, (int)this.indexes[0].getValueAddresses().size(), (IntComparator)comparator, (Swapper)this);
    }

    public static class MultiSliceFieldOrderedTupleComparator
    extends AbstractIntComparator {
        private final TupleInfo tupleInfo;
        private final long[] sliceAddresses;
        private final Slice[] slices;
        private final TupleInfo.Type[] types;
        private final int[] sortFields;
        private final boolean[] sortOrder;

        public MultiSliceFieldOrderedTupleComparator(int[] sortFields, boolean[] sortOrder, ChannelIndex index) {
            this(sortFields, sortOrder, index.getTupleInfo(), index.getValueAddresses().elements(), (Slice[])index.getSlices().elements());
        }

        public MultiSliceFieldOrderedTupleComparator(int[] sortFields, boolean[] sortOrder, TupleInfo tupleInfo, long[] sliceAddresses, Slice ... slices) {
            this.sortFields = sortFields;
            this.sortOrder = sortOrder;
            this.tupleInfo = tupleInfo;
            this.sliceAddresses = sliceAddresses;
            this.slices = slices;
            List<TupleInfo.Type> types = tupleInfo.getTypes();
            this.types = types.toArray(new TupleInfo.Type[types.size()]);
        }

        public int compare(int leftPosition, int rightPosition) {
            long leftSliceAddress = this.sliceAddresses[leftPosition];
            Slice leftSlice = this.slices[(int)(leftSliceAddress >> 32)];
            int leftOffset = (int)leftSliceAddress;
            long rightSliceAddress = this.sliceAddresses[rightPosition];
            Slice rightSlice = this.slices[(int)(rightSliceAddress >> 32)];
            int rightOffset = (int)rightSliceAddress;
            for (int i = 0; i < this.sortFields.length; ++i) {
                int comparison;
                int field = this.sortFields[i];
                TupleInfo.Type type = this.types[field];
                switch (type) {
                    case BOOLEAN: {
                        comparison = Boolean.compare(this.tupleInfo.getBoolean(leftSlice, leftOffset, field), this.tupleInfo.getBoolean(rightSlice, rightOffset, field));
                        break;
                    }
                    case FIXED_INT_64: {
                        comparison = Long.compare(this.tupleInfo.getLong(leftSlice, leftOffset, field), this.tupleInfo.getLong(rightSlice, rightOffset, field));
                        break;
                    }
                    case DOUBLE: {
                        comparison = Double.compare(this.tupleInfo.getDouble(leftSlice, leftOffset, field), this.tupleInfo.getDouble(rightSlice, rightOffset, field));
                        break;
                    }
                    case VARIABLE_BINARY: {
                        comparison = this.tupleInfo.getSlice(leftSlice, leftOffset, field).compareTo(this.tupleInfo.getSlice(rightSlice, rightOffset, field));
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("unimplemented type: " + type));
                    }
                }
                if (comparison == 0) continue;
                return this.sortOrder[i] ? comparison : -comparison;
            }
            return 0;
        }
    }
}

