/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.operator.Page;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SliceOutput;
import io.airlift.units.DataSize;
import java.util.List;

public class PageBuilder {
    public static final DataSize DEFAULT_MAX_PAGE_SIZE = new DataSize(1.0, DataSize.Unit.MEGABYTE);
    private final BlockBuilder[] blockBuilders;
    private final long maxSizeInBytes;
    private final int maxBlockSize;
    private int declaredPositions;

    public PageBuilder(List<TupleInfo> tupleInfos) {
        this(tupleInfos, DEFAULT_MAX_PAGE_SIZE);
    }

    public PageBuilder(List<TupleInfo> tupleInfos, DataSize maxSize) {
        this.maxBlockSize = !tupleInfos.isEmpty() ? (int)(maxSize.toBytes() / (long)tupleInfos.size()) : 0;
        this.blockBuilders = new BlockBuilder[tupleInfos.size()];
        for (int i = 0; i < this.blockBuilders.length; ++i) {
            this.blockBuilders[i] = new BlockBuilder(tupleInfos.get(i), this.maxBlockSize, (SliceOutput)new DynamicSliceOutput((int)((double)this.maxBlockSize * 1.5)));
        }
        this.maxSizeInBytes = ((DataSize)Preconditions.checkNotNull((Object)maxSize, (Object)"maxSize is null")).toBytes();
    }

    public void reset() {
        this.declaredPositions = 0;
        if (this.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.blockBuilders.length; ++i) {
            BlockBuilder blockBuilder = this.blockBuilders[i];
            int estimatedSize = (int)((double)blockBuilder.size() * 1.5);
            this.blockBuilders[i] = new BlockBuilder(blockBuilder.getTupleInfo(), this.maxBlockSize, (SliceOutput)new DynamicSliceOutput(estimatedSize));
        }
    }

    public BlockBuilder getBlockBuilder(int channel) {
        return this.blockBuilders[channel];
    }

    public void declarePosition() {
        ++this.declaredPositions;
    }

    public boolean isFull() {
        if (this.declaredPositions == Integer.MAX_VALUE) {
            return true;
        }
        long sizeInBytes = 0L;
        for (BlockBuilder blockBuilder : this.blockBuilders) {
            if (blockBuilder.isFull()) {
                return true;
            }
            if ((sizeInBytes += (long)blockBuilder.size()) <= this.maxSizeInBytes) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.blockBuilders.length == 0 ? this.declaredPositions == 0 : this.blockBuilders[0].isEmpty();
    }

    public long getSize() {
        long sizeInBytes = 0L;
        for (BlockBuilder blockBuilder : this.blockBuilders) {
            sizeInBytes += (long)blockBuilder.size();
        }
        return sizeInBytes;
    }

    public Page build() {
        if (this.blockBuilders.length == 0) {
            return new Page(this.declaredPositions, new Block[0]);
        }
        Block[] blocks = new Block[this.blockBuilders.length];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = this.blockBuilders[i].build();
        }
        return new Page(blocks);
    }
}

