/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.block.uncompressed.UncompressedBlock;
import com.facebook.presto.operator.ChannelSet;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.HashBuilderOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.SetBuilderOperator;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.util.MoreFutures;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.Slices;
import java.util.List;

public class HashSemiJoinOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final int probeJoinChannel;
    private final List<TupleInfo> tupleInfos;
    private final ListenableFuture<ChannelSet> channelSetFuture;
    private ChannelSet channelSet;
    private Page outputPage;
    private boolean finishing;

    public HashSemiJoinOperator(OperatorContext operatorContext, SetBuilderOperator.SetSupplier channelSetFuture, List<TupleInfo> probeTupleInfos, int probeJoinChannel) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        Preconditions.checkNotNull((Object)channelSetFuture, (Object)"hashProvider is null");
        Preconditions.checkNotNull(probeTupleInfos, (Object)"probeTupleInfos is null");
        Preconditions.checkArgument((probeJoinChannel >= 0 ? 1 : 0) != 0, (Object)"probeJoinChannel is negative");
        Preconditions.checkArgument((probeTupleInfos.get(probeJoinChannel).getFieldCount() == 1 ? 1 : 0) != 0, (Object)"Semi join currently only support simple types");
        this.channelSetFuture = channelSetFuture.getChannelSet();
        this.probeJoinChannel = probeJoinChannel;
        this.tupleInfos = ImmutableList.builder().addAll(probeTupleInfos).add((Object)TupleInfo.SINGLE_BOOLEAN).build();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<TupleInfo> getTupleInfos() {
        return this.tupleInfos;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.outputPage == null;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.channelSetFuture;
    }

    @Override
    public boolean needsInput() {
        if (this.finishing || this.outputPage != null) {
            return false;
        }
        if (this.channelSet == null) {
            this.channelSet = MoreFutures.tryGetUnchecked(this.channelSetFuture);
        }
        return this.channelSet != null;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is finishing");
        Preconditions.checkState((this.channelSet != null ? 1 : 0) != 0, (Object)"Set has not been built yet");
        Preconditions.checkState((this.outputPage == null ? 1 : 0) != 0, (Object)"Operator still has pending output");
        UncompressedBlock probeJoinBlock = (UncompressedBlock)page.getBlock(this.probeJoinChannel);
        this.channelSet.setLookupSlice(probeJoinBlock.getSlice());
        int blockSize = page.getPositionCount() * TupleInfo.SINGLE_BOOLEAN.getFixedSize();
        BlockBuilder blockBuilder = new BlockBuilder(TupleInfo.SINGLE_BOOLEAN, blockSize, Slices.allocate((int)blockSize).getOutput());
        BlockCursor probeJoinCursor = probeJoinBlock.cursor();
        for (int position = 0; position < page.getPositionCount(); ++position) {
            Preconditions.checkState((boolean)probeJoinCursor.advanceNextPosition());
            if (probeJoinCursor.isNull(0)) {
                blockBuilder.appendNull();
                continue;
            }
            boolean contains = this.channelSet.contains(probeJoinCursor);
            if (!contains && this.channelSet.containsNull()) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.append(contains);
        }
        Block[] sourceBlocks = page.getBlocks();
        Block[] outputBlocks = new Block[sourceBlocks.length + 1];
        System.arraycopy(sourceBlocks, 0, outputBlocks, 0, sourceBlocks.length);
        outputBlocks[sourceBlocks.length] = blockBuilder.build();
        this.outputPage = new Page(outputBlocks);
    }

    @Override
    public Page getOutput() {
        Page result = this.outputPage;
        this.outputPage = null;
        return result;
    }

    public static class HashSemiJoinOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final SetBuilderOperator.SetSupplier setSupplier;
        private final List<TupleInfo> probeTupleInfos;
        private final int probeJoinChannel;
        private final List<TupleInfo> tupleInfos;
        private boolean closed;

        public HashSemiJoinOperatorFactory(int operatorId, SetBuilderOperator.SetSupplier setSupplier, List<TupleInfo> probeTupleInfos, int probeJoinChannel) {
            this.operatorId = operatorId;
            this.setSupplier = setSupplier;
            this.probeTupleInfos = probeTupleInfos;
            Preconditions.checkArgument((probeJoinChannel >= 0 ? 1 : 0) != 0, (Object)"probeJoinChannel is negative");
            this.probeJoinChannel = probeJoinChannel;
            this.tupleInfos = ImmutableList.builder().addAll(probeTupleInfos).add((Object)TupleInfo.SINGLE_BOOLEAN).build();
        }

        @Override
        public List<TupleInfo> getTupleInfos() {
            return this.tupleInfos;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, HashBuilderOperator.class.getSimpleName());
            return new HashSemiJoinOperator(operatorContext, this.setSupplier, this.probeTupleInfos, this.probeJoinChannel);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

