/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.block.uncompressed.UncompressedBlock;
import com.facebook.presto.operator.AggregationFunctionDefinition;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.FixedWidthAggregationFunction;
import com.facebook.presto.operator.aggregation.VariableWidthAggregationFunction;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.tree.Input;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import it.unimi.dsi.fastutil.longs.Long2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.longs.LongHash;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HashAggregationOperator
implements Operator {
    private static final int LOOKUP_SLICE_INDEX = -1;
    private final OperatorContext operatorContext;
    private final TupleInfo groupByTupleInfo;
    private final int groupByChannel;
    private final AggregationNode.Step step;
    private final List<AggregationFunctionDefinition> functionDefinitions;
    private final int expectedGroups;
    private final List<TupleInfo> tupleInfos;
    private final HashMemoryManager memoryManager;
    private GroupByHashAggregationBuilder aggregationBuilder;
    private Iterator<Page> outputIterator;
    private boolean finishing;

    public HashAggregationOperator(OperatorContext operatorContext, TupleInfo groupByTupleInfo, int groupByChannel, AggregationNode.Step step, List<AggregationFunctionDefinition> functionDefinitions, int expectedGroups) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        Preconditions.checkArgument((groupByChannel >= 0 ? 1 : 0) != 0, (Object)"groupByChannel is negative");
        Preconditions.checkNotNull((Object)((Object)step), (Object)"step is null");
        Preconditions.checkNotNull(functionDefinitions, (Object)"functionDefinitions is null");
        Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.groupByTupleInfo = groupByTupleInfo;
        this.groupByChannel = groupByChannel;
        this.functionDefinitions = ImmutableList.copyOf(functionDefinitions);
        this.step = step;
        this.expectedGroups = expectedGroups;
        this.memoryManager = new HashMemoryManager(operatorContext);
        this.tupleInfos = HashAggregationOperator.toTupleInfos(groupByTupleInfo, step, functionDefinitions);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<TupleInfo> getTupleInfos() {
        return this.tupleInfos;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.aggregationBuilder == null && (this.outputIterator == null || !this.outputIterator.hasNext());
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && this.outputIterator == null && (this.aggregationBuilder == null || !this.aggregationBuilder.isFull());
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        if (this.aggregationBuilder == null) {
            this.aggregationBuilder = new GroupByHashAggregationBuilder(this.functionDefinitions, this.step, this.expectedGroups, this.groupByChannel, this.groupByTupleInfo, this.memoryManager);
        } else {
            Preconditions.checkState((!this.aggregationBuilder.isFull() ? 1 : 0) != 0, (Object)"Aggregation buffer is full");
        }
        this.aggregationBuilder.processPage(page);
    }

    @Override
    public Page getOutput() {
        if (this.outputIterator == null || !this.outputIterator.hasNext()) {
            if (this.aggregationBuilder == null) {
                return null;
            }
            if (!this.finishing && !this.aggregationBuilder.isFull()) {
                return null;
            }
            Preconditions.checkState((this.finishing || this.step == AggregationNode.Step.PARTIAL ? 1 : 0) != 0, (String)"Task exceeded max memory size of %s", (Object[])new Object[]{this.memoryManager.getMaxMemorySize()});
            this.outputIterator = this.aggregationBuilder.build();
            this.aggregationBuilder = null;
            if (!this.outputIterator.hasNext()) {
                return null;
            }
        }
        return this.outputIterator.next();
    }

    private static List<TupleInfo> toTupleInfos(TupleInfo groupByTupleInfo, AggregationNode.Step step, List<AggregationFunctionDefinition> functionDefinitions) {
        ImmutableList.Builder tupleInfos = ImmutableList.builder();
        tupleInfos.add((Object)groupByTupleInfo);
        for (AggregationFunctionDefinition functionDefinition : functionDefinitions) {
            if (step != AggregationNode.Step.PARTIAL) {
                tupleInfos.add((Object)functionDefinition.getFunction().getFinalTupleInfo());
                continue;
            }
            tupleInfos.add((Object)functionDefinition.getFunction().getIntermediateTupleInfo());
        }
        return tupleInfos.build();
    }

    private static Aggregator createAggregator(AggregationFunctionDefinition functionDefinition, AggregationNode.Step step, int expectedGroups) {
        AggregationFunction function = functionDefinition.getFunction();
        if (function instanceof VariableWidthAggregationFunction) {
            return new VariableWidthAggregator((VariableWidthAggregationFunction)functionDefinition.getFunction(), functionDefinition.getInputs(), step, expectedGroups);
        }
        Input input = null;
        if (!functionDefinition.getInputs().isEmpty()) {
            input = (Input)Iterables.getOnlyElement(functionDefinition.getInputs());
        }
        return new FixedWidthAggregator((FixedWidthAggregationFunction)functionDefinition.getFunction(), input, step);
    }

    public static class SliceHashStrategy
    implements LongHash.Strategy {
        private final TupleInfo tupleInfo;
        private final List<Slice> slices;
        private Slice lookupSlice;
        private long memorySize;

        public SliceHashStrategy(TupleInfo tupleInfo) {
            this.tupleInfo = tupleInfo;
            this.slices = ObjectArrayList.wrap((Object[])new Slice[1024], (int)0);
        }

        public long getEstimatedSize() {
            return this.memorySize;
        }

        public void setLookupSlice(Slice lookupSlice) {
            this.lookupSlice = lookupSlice;
        }

        public void addSlice(Slice slice) {
            this.memorySize += (long)slice.length();
            this.slices.add(slice);
        }

        public int hashCode(long sliceAddress) {
            Slice slice = this.getSliceForSyntheticAddress(sliceAddress);
            int offset = (int)sliceAddress;
            int length = this.tupleInfo.size(slice, offset);
            int hashCode = slice.hashCode(offset, length);
            return hashCode;
        }

        public boolean equals(long leftSliceAddress, long rightSliceAddress) {
            Slice leftSlice = this.getSliceForSyntheticAddress(leftSliceAddress);
            int leftOffset = SyntheticAddress.decodeSliceOffset(leftSliceAddress);
            int leftLength = this.tupleInfo.size(leftSlice, leftOffset);
            Slice rightSlice = this.getSliceForSyntheticAddress(rightSliceAddress);
            int rightOffset = SyntheticAddress.decodeSliceOffset(rightSliceAddress);
            int rightLength = this.tupleInfo.size(rightSlice, rightOffset);
            return leftSlice.equals(leftOffset, leftLength, rightSlice, rightOffset, rightLength);
        }

        private Slice getSliceForSyntheticAddress(long sliceAddress) {
            int sliceIndex = SyntheticAddress.decodeSliceIndex(sliceAddress);
            Slice slice = sliceIndex == -1 ? this.lookupSlice : this.slices.get(sliceIndex);
            return slice;
        }
    }

    private static class VariableWidthAggregator<T>
    implements Aggregator {
        private final VariableWidthAggregationFunction<T> function;
        private final List<Input> inputs;
        private final AggregationNode.Step step;
        private final ObjectArrayList<T> intermediateValues;
        private long totalElementSizeInBytes;
        private final BlockCursor[] blockCursors;
        private final int[] fields;

        private VariableWidthAggregator(VariableWidthAggregationFunction<T> function, List<Input> inputs, AggregationNode.Step step, int expectedGroups) {
            this.function = function;
            this.inputs = inputs;
            this.step = step;
            this.intermediateValues = new ObjectArrayList(expectedGroups);
            this.blockCursors = new BlockCursor[inputs.size()];
            this.fields = new int[inputs.size()];
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = inputs.get(i).getField();
            }
        }

        @Override
        public long getEstimatedSize() {
            return SizeOf.sizeOf((Object[])this.intermediateValues.elements()) + this.totalElementSizeInBytes;
        }

        @Override
        public TupleInfo getTupleInfo() {
            if (this.step == AggregationNode.Step.PARTIAL) {
                return this.function.getIntermediateTupleInfo();
            }
            return this.function.getFinalTupleInfo();
        }

        @Override
        public void initialize(int position) {
            Preconditions.checkState((position == this.intermediateValues.size() ? 1 : 0) != 0, (Object)"expected array to grow by 1");
            this.intermediateValues.add(this.function.initialize());
        }

        @Override
        public void addValue(BlockCursor[] cursors, int position) {
            for (int i = 0; i < this.blockCursors.length; ++i) {
                this.blockCursors[i] = cursors[this.inputs.get(i).getChannel()];
            }
            Object oldValue = this.intermediateValues.get(position);
            long oldSize = 0L;
            if (oldValue != null) {
                oldSize = this.function.estimateSizeInBytes(oldValue);
            }
            Object newValue = this.step == AggregationNode.Step.FINAL ? this.function.addIntermediate(this.blockCursors, this.fields, oldValue) : this.function.addInput(this.blockCursors, this.fields, oldValue);
            this.intermediateValues.set(position, newValue);
            long newSize = 0L;
            if (newValue != null) {
                newSize = this.function.estimateSizeInBytes(newValue);
            }
            this.totalElementSizeInBytes += newSize - oldSize;
        }

        @Override
        public void evaluate(int position, BlockBuilder output) {
            Object value = this.intermediateValues.get(position);
            if (this.step == AggregationNode.Step.PARTIAL) {
                this.function.evaluateIntermediate(value, output);
            } else {
                this.function.evaluateFinal(value, output);
            }
        }
    }

    private static class FixedWidthAggregator
    implements Aggregator {
        private final FixedWidthAggregationFunction function;
        private final Input input;
        private final AggregationNode.Step step;
        private final int fixedWidthSize;
        private final int sliceSize;
        private final List<Slice> slices = new ArrayList<Slice>();
        private int currentMaxPosition;

        private FixedWidthAggregator(FixedWidthAggregationFunction function, Input input, AggregationNode.Step step) {
            this.function = function;
            this.input = input;
            this.step = step;
            this.fixedWidthSize = this.function.getFixedSize();
            this.sliceSize = (int)(BlockBuilder.DEFAULT_MAX_BLOCK_SIZE.toBytes() / (long)this.fixedWidthSize) * this.fixedWidthSize;
            Slice slice = Slices.allocate((int)this.sliceSize);
            this.slices.add(slice);
            this.currentMaxPosition = this.sliceSize / this.fixedWidthSize;
        }

        @Override
        public long getEstimatedSize() {
            return this.slices.size() * this.sliceSize;
        }

        @Override
        public TupleInfo getTupleInfo() {
            if (this.step == AggregationNode.Step.PARTIAL) {
                return this.function.getIntermediateTupleInfo();
            }
            return this.function.getFinalTupleInfo();
        }

        @Override
        public void initialize(int position) {
            while (position >= this.currentMaxPosition) {
                Slice slice = Slices.allocate((int)this.sliceSize);
                this.slices.add(slice);
                this.currentMaxPosition += this.sliceSize / this.fixedWidthSize;
            }
            int globalOffset = position * this.fixedWidthSize;
            int sliceIndex = globalOffset / this.sliceSize;
            Slice slice = this.slices.get(sliceIndex);
            int sliceOffset = globalOffset - sliceIndex * this.sliceSize;
            this.function.initialize(slice, sliceOffset);
        }

        @Override
        public void addValue(BlockCursor[] cursors, int position) {
            BlockCursor cursor;
            int field = -1;
            if (this.input != null) {
                cursor = cursors[this.input.getChannel()];
                field = this.input.getField();
            } else {
                cursor = null;
            }
            int globalOffset = position * this.fixedWidthSize;
            int sliceIndex = globalOffset / this.sliceSize;
            Slice slice = this.slices.get(sliceIndex);
            int sliceOffset = globalOffset - sliceIndex * this.sliceSize;
            if (this.step == AggregationNode.Step.FINAL) {
                this.function.addIntermediate(cursor, field, slice, sliceOffset);
            } else {
                this.function.addInput(cursor, field, slice, sliceOffset);
            }
        }

        @Override
        public void evaluate(int position, BlockBuilder output) {
            int offset = position * this.fixedWidthSize;
            int sliceIndex = offset / this.sliceSize;
            Slice slice = this.slices.get(sliceIndex);
            int sliceOffset = offset - sliceIndex * this.sliceSize;
            if (this.step == AggregationNode.Step.PARTIAL) {
                this.function.evaluateIntermediate(slice, sliceOffset, output);
            } else {
                this.function.evaluateFinal(slice, sliceOffset, output);
            }
        }
    }

    private static interface Aggregator {
        public long getEstimatedSize();

        public TupleInfo getTupleInfo();

        public void initialize(int var1);

        public void addValue(BlockCursor[] var1, int var2);

        public void evaluate(int var1, BlockBuilder var2);
    }

    public static class HashMemoryManager {
        private final OperatorContext operatorContext;
        private long currentMemoryReservation;

        public HashMemoryManager(OperatorContext operatorContext) {
            this.operatorContext = operatorContext;
        }

        public boolean canUse(long memorySize) {
            long delta = (memorySize -= this.operatorContext.getOperatorPreAllocatedMemory().toBytes()) - this.currentMemoryReservation;
            if (delta <= 0L) {
                return false;
            }
            if (!this.operatorContext.reserveMemory(delta)) {
                return true;
            }
            this.currentMemoryReservation = Math.max(this.currentMemoryReservation, memorySize);
            return false;
        }

        public Object getMaxMemorySize() {
            return this.operatorContext.getMaxMemorySize();
        }
    }

    private static class GroupByHashAggregationBuilder {
        private final List<Aggregator> aggregates;
        private final SliceHashStrategy hashStrategy;
        private final Long2IntOpenCustomHashMap addressToGroupId;
        private final List<UncompressedBlock> groupByBlocks = new ArrayList<UncompressedBlock>();
        private final int groupByChannel;
        private final TupleInfo groupByTupleInfo;
        private final HashMemoryManager memoryManager;
        private BlockBuilder blockBuilder;
        private int nextGroupId;

        private GroupByHashAggregationBuilder(List<AggregationFunctionDefinition> functionDefinitions, AggregationNode.Step step, int expectedGroups, int groupByChannel, TupleInfo groupByTupleInfo, HashMemoryManager memoryManager) {
            this.groupByChannel = groupByChannel;
            this.groupByTupleInfo = groupByTupleInfo;
            this.memoryManager = memoryManager;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (AggregationFunctionDefinition functionDefinition : (List)Preconditions.checkNotNull(functionDefinitions, (Object)"functionDefinitions is null")) {
                builder.add((Object)HashAggregationOperator.createAggregator(functionDefinition, step, expectedGroups));
            }
            this.aggregates = builder.build();
            this.hashStrategy = new SliceHashStrategy(groupByTupleInfo);
            this.addressToGroupId = new Long2IntOpenCustomHashMap(expectedGroups, (LongHash.Strategy)this.hashStrategy);
            this.addressToGroupId.defaultReturnValue(-1);
            Slice slice = Slices.allocate((int)((int)BlockBuilder.DEFAULT_MAX_BLOCK_SIZE.toBytes()));
            this.hashStrategy.addSlice(slice);
            this.blockBuilder = new BlockBuilder(groupByTupleInfo, slice.length(), slice.getOutput());
        }

        private void processPage(Page page) {
            Block[] blocks = page.getBlocks();
            BlockCursor[] cursors = new BlockCursor[blocks.length];
            for (int i = 0; i < blocks.length; ++i) {
                cursors[i] = blocks[i].cursor();
            }
            Slice groupBySlice = ((UncompressedBlock)blocks[this.groupByChannel]).getSlice();
            this.hashStrategy.setLookupSlice(groupBySlice);
            int rows = page.getPositionCount();
            for (int position = 0; position < rows; ++position) {
                for (BlockCursor cursor : cursors) {
                    Preconditions.checkState((boolean)cursor.advanceNextPosition());
                }
                int groupId = this.putIfAbsent(groupBySlice, cursors);
                this.processRow(cursors, groupId);
            }
            for (BlockCursor cursor : cursors) {
                Preconditions.checkState((!cursor.advanceNextPosition() ? 1 : 0) != 0);
            }
        }

        private int putIfAbsent(Slice groupBySlice, BlockCursor[] cursors) {
            int rawOffset = cursors[this.groupByChannel].getRawOffset();
            int groupId = this.addressToGroupId.get(SyntheticAddress.encodeSyntheticAddress(-1, rawOffset));
            if (groupId < 0) {
                groupId = this.addNewGroup(groupBySlice, rawOffset);
            }
            return groupId;
        }

        private int addNewGroup(Slice groupBySlice, int rawOffset) {
            int length = this.groupByTupleInfo.size(groupBySlice, rawOffset);
            if (this.blockBuilder.writableBytes() < length) {
                UncompressedBlock block = this.blockBuilder.build();
                this.groupByBlocks.add(block);
                Slice slice = Slices.allocate((int)Math.max((int)BlockBuilder.DEFAULT_MAX_BLOCK_SIZE.toBytes(), length));
                this.blockBuilder = new BlockBuilder(this.groupByTupleInfo, slice.length(), slice.getOutput());
                this.hashStrategy.addSlice(slice);
            }
            int groupByValueRawOffset = this.blockBuilder.size();
            this.blockBuilder.appendTuple(groupBySlice, rawOffset, length);
            int groupId = this.nextGroupId++;
            this.addressToGroupId.put(SyntheticAddress.encodeSyntheticAddress(this.groupByBlocks.size(), groupByValueRawOffset), groupId);
            this.initializeRow(groupId);
            return groupId;
        }

        private void initializeRow(int groupId) {
            for (Aggregator aggregate : this.aggregates) {
                aggregate.initialize(groupId);
            }
        }

        private void processRow(BlockCursor[] cursors, int groupId) {
            for (Aggregator aggregate : this.aggregates) {
                aggregate.addValue(cursors, groupId);
            }
        }

        public boolean isFull() {
            long memorySize = this.hashStrategy.getEstimatedSize();
            for (Aggregator aggregate : this.aggregates) {
                memorySize += aggregate.getEstimatedSize();
            }
            return this.memoryManager.canUse(memorySize);
        }

        public Iterator<Page> build() {
            if (!this.blockBuilder.isEmpty()) {
                UncompressedBlock block = this.blockBuilder.build();
                this.groupByBlocks.add(block);
            }
            return Iterators.transform(this.groupByBlocks.iterator(), (Function)new Function<UncompressedBlock, Page>(){
                private int currentPosition = 0;

                public Page apply(UncompressedBlock groupByBlock) {
                    Block[] blocks = new Block[GroupByHashAggregationBuilder.this.aggregates.size() + 1];
                    blocks[0] = groupByBlock;
                    int pagePositionCount = groupByBlock.getPositionCount();
                    for (int channel = 1; channel < GroupByHashAggregationBuilder.this.aggregates.size() + 1; ++channel) {
                        Aggregator aggregator = (Aggregator)GroupByHashAggregationBuilder.this.aggregates.get(channel - 1);
                        BlockBuilder blockBuilder = new BlockBuilder(aggregator.getTupleInfo());
                        for (int position = 0; position < pagePositionCount; ++position) {
                            aggregator.evaluate(this.currentPosition + position, blockBuilder);
                        }
                        blocks[channel] = blockBuilder.build();
                    }
                    Page page = new Page(blocks);
                    this.currentPosition += pagePositionCount;
                    return page;
                }
            });
        }
    }

    public static class HashAggregationOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final TupleInfo groupByTupleInfo;
        private final int groupByChannel;
        private final AggregationNode.Step step;
        private final List<AggregationFunctionDefinition> functionDefinitions;
        private final int expectedGroups;
        private final List<TupleInfo> tupleInfos;
        private boolean closed;

        public HashAggregationOperatorFactory(int operatorId, TupleInfo groupByTupleInfo, int groupByChannel, AggregationNode.Step step, List<AggregationFunctionDefinition> functionDefinitions, int expectedGroups) {
            this.operatorId = operatorId;
            this.groupByTupleInfo = groupByTupleInfo;
            this.groupByChannel = groupByChannel;
            this.step = step;
            this.functionDefinitions = functionDefinitions;
            this.expectedGroups = expectedGroups;
            this.tupleInfos = HashAggregationOperator.toTupleInfos(groupByTupleInfo, step, functionDefinitions);
        }

        @Override
        public List<TupleInfo> getTupleInfos() {
            return this.tupleInfos;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, HashAggregationOperator.class.getSimpleName());
            return new HashAggregationOperator(operatorContext, this.groupByTupleInfo, this.groupByChannel, this.step, this.functionDefinitions, this.expectedGroups);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

