/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.execution.TaskId;
import com.facebook.presto.operator.DriverStats;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.PipelineContext;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.stats.CounterStat;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.joda.time.DateTime;

public class DriverContext {
    private final PipelineContext pipelineContext;
    private final Executor executor;
    private final AtomicBoolean finished = new AtomicBoolean();
    private final DateTime createdTime = DateTime.now();
    private final long createNanos = System.nanoTime();
    private final AtomicLong startNanos = new AtomicLong();
    private final AtomicLong endNanos = new AtomicLong();
    private final AtomicReference<DateTime> executionStartTime = new AtomicReference();
    private final AtomicReference<DateTime> executionEndTime = new AtomicReference();
    private final AtomicLong memoryReservation = new AtomicLong();
    private final List<OperatorContext> operatorContexts = new CopyOnWriteArrayList<OperatorContext>();

    public DriverContext(PipelineContext pipelineContext, Executor executor) {
        this.pipelineContext = (PipelineContext)Preconditions.checkNotNull((Object)pipelineContext, (Object)"pipelineContext is null");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
    }

    public TaskId getTaskId() {
        return this.pipelineContext.getTaskId();
    }

    public OperatorContext addOperatorContext(int operatorId, String operatorType) {
        Preconditions.checkArgument((operatorId >= 0 ? 1 : 0) != 0, (Object)"operatorId is negative");
        for (OperatorContext operatorContext : this.operatorContexts) {
            Preconditions.checkArgument((operatorId != operatorContext.getOperatorId() ? 1 : 0) != 0, (String)"A context already exists for operatorId %s", (Object[])new Object[]{operatorId});
        }
        OperatorContext operatorContext = new OperatorContext(operatorId, operatorType, this, this.executor);
        this.operatorContexts.add(operatorContext);
        return operatorContext;
    }

    public List<OperatorContext> getOperatorContexts() {
        return ImmutableList.copyOf(this.operatorContexts);
    }

    public Session getSession() {
        return this.pipelineContext.getSession();
    }

    public void start() {
        if (!this.startNanos.compareAndSet(0L, System.nanoTime())) {
            return;
        }
        this.pipelineContext.start();
        this.executionStartTime.set(DateTime.now());
    }

    public void finished() {
        if (!this.finished.compareAndSet(false, true)) {
            return;
        }
        this.executionEndTime.set(DateTime.now());
        this.endNanos.set(System.nanoTime());
        this.pipelineContext.driverFinished(this);
    }

    public void failed(Throwable cause) {
        this.pipelineContext.failed(cause);
        this.finished.set(true);
    }

    public boolean isDone() {
        return this.finished.get() || this.pipelineContext.isDone();
    }

    public DataSize getMaxMemorySize() {
        return this.pipelineContext.getMaxMemorySize();
    }

    public DataSize getOperatorPreAllocatedMemory() {
        return this.pipelineContext.getMaxMemorySize();
    }

    public boolean reserveMemory(long bytes) {
        boolean result = this.pipelineContext.reserveMemory(bytes);
        if (result) {
            this.memoryReservation.getAndAdd(bytes);
        }
        return result;
    }

    public boolean isCpuTimerEnabled() {
        return this.pipelineContext.isCpuTimerEnabled();
    }

    public CounterStat getInputDataSize() {
        OperatorContext inputOperator = (OperatorContext)Iterables.getFirst(this.operatorContexts, null);
        if (inputOperator != null) {
            return inputOperator.getInputDataSize();
        }
        return new CounterStat();
    }

    public CounterStat getInputPositions() {
        OperatorContext inputOperator = (OperatorContext)Iterables.getFirst(this.operatorContexts, null);
        if (inputOperator != null) {
            return inputOperator.getInputPositions();
        }
        return new CounterStat();
    }

    public CounterStat getOutputDataSize() {
        OperatorContext inputOperator = (OperatorContext)Iterables.getLast(this.operatorContexts, null);
        if (inputOperator != null) {
            return inputOperator.getOutputDataSize();
        }
        return new CounterStat();
    }

    public CounterStat getOutputPositions() {
        OperatorContext inputOperator = (OperatorContext)Iterables.getLast(this.operatorContexts, null);
        if (inputOperator != null) {
            return inputOperator.getOutputPositions();
        }
        return new CounterStat();
    }

    @Deprecated
    public void addOutputItems(PlanNodeId id, Set<?> output) {
        this.pipelineContext.addOutputItems(id, output);
    }

    public DriverStats getDriverStats() {
        long outputPositions;
        DataSize outputDataSize;
        long processedInputPositions;
        DataSize processedInputDataSize;
        long rawInputPositions;
        DataSize rawInputDataSize;
        long totalScheduledTime = 0L;
        long totalCpuTime = 0L;
        long totalUserTime = 0L;
        long totalBlockedTime = 0L;
        ImmutableList operators = ImmutableList.copyOf((Iterable)Iterables.transform(this.operatorContexts, OperatorContext.operatorStatsGetter()));
        for (OperatorStats operator : operators) {
            totalScheduledTime += operator.getGetOutputWall().roundTo(TimeUnit.NANOSECONDS);
            totalCpuTime += operator.getGetOutputCpu().roundTo(TimeUnit.NANOSECONDS);
            totalUserTime += operator.getGetOutputUser().roundTo(TimeUnit.NANOSECONDS);
            totalScheduledTime += operator.getAddInputWall().roundTo(TimeUnit.NANOSECONDS);
            totalCpuTime += operator.getAddInputCpu().roundTo(TimeUnit.NANOSECONDS);
            totalUserTime += operator.getAddInputUser().roundTo(TimeUnit.NANOSECONDS);
            totalScheduledTime += operator.getFinishWall().roundTo(TimeUnit.NANOSECONDS);
            totalCpuTime += operator.getFinishCpu().roundTo(TimeUnit.NANOSECONDS);
            totalUserTime += operator.getFinishUser().roundTo(TimeUnit.NANOSECONDS);
            totalBlockedTime += operator.getBlockedWall().roundTo(TimeUnit.NANOSECONDS);
        }
        OperatorStats inputOperator = (OperatorStats)Iterables.getFirst((Iterable)operators, null);
        if (inputOperator != null) {
            rawInputDataSize = inputOperator.getInputDataSize();
            rawInputPositions = inputOperator.getInputPositions();
            processedInputDataSize = inputOperator.getOutputDataSize();
            processedInputPositions = inputOperator.getOutputPositions();
            OperatorStats outputOperator = (OperatorStats)Preconditions.checkNotNull((Object)Iterables.getLast((Iterable)operators, null));
            outputDataSize = outputOperator.getOutputDataSize();
            outputPositions = outputOperator.getOutputPositions();
        } else {
            rawInputDataSize = new DataSize(0.0, DataSize.Unit.BYTE);
            rawInputPositions = 0L;
            processedInputDataSize = new DataSize(0.0, DataSize.Unit.BYTE);
            processedInputPositions = 0L;
            outputDataSize = new DataSize(0.0, DataSize.Unit.BYTE);
            outputPositions = 0L;
        }
        long startNanos = this.startNanos.get();
        if (startNanos < this.createNanos) {
            startNanos = System.nanoTime();
        }
        Duration queuedTime = new Duration((double)(startNanos - this.createNanos), TimeUnit.NANOSECONDS);
        long endNanos = this.endNanos.get();
        Duration elapsedTime = endNanos >= startNanos ? new Duration((double)(endNanos - this.createNanos), TimeUnit.NANOSECONDS) : new Duration(0.0, TimeUnit.NANOSECONDS);
        return new DriverStats(this.createdTime, this.executionStartTime.get(), this.executionEndTime.get(), queuedTime.convertToMostSuccinctTimeUnit(), elapsedTime.convertToMostSuccinctTimeUnit(), new DataSize((double)this.memoryReservation.get(), DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), new Duration((double)totalScheduledTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalCpuTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalUserTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalBlockedTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), rawInputDataSize.convertToMostSuccinctDataSize(), rawInputPositions, processedInputDataSize.convertToMostSuccinctDataSize(), processedInputPositions, outputDataSize.convertToMostSuccinctDataSize(), outputPositions, (List<OperatorStats>)ImmutableList.copyOf((Iterable)Iterables.transform(this.operatorContexts, OperatorContext.operatorStatsGetter())));
    }

    public static Function<DriverContext, DriverStats> driverStatsGetter() {
        return new Function<DriverContext, DriverStats>(){

            public DriverStats apply(DriverContext driverContext) {
                return driverContext.getDriverStats();
            }
        };
    }
}

