/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.block.uncompressed.UncompressedBlock;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import it.unimi.dsi.fastutil.Swapper;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;

public class ChannelIndex
implements LongIterable,
Swapper {
    private int positionCount;
    private final LongArrayList valueAddresses;
    private final ObjectArrayList<Slice> slices;
    private final TupleInfo tupleInfo;
    private long slicesMemorySize;

    public ChannelIndex(int expectedPositions, TupleInfo tupleInfo) {
        this.tupleInfo = tupleInfo;
        this.valueAddresses = new LongArrayList(expectedPositions);
        this.slices = ObjectArrayList.wrap((Object[])new Slice[1024], (int)0);
    }

    public DataSize getEstimatedSize() {
        long sliceArraySize = SizeOf.sizeOf((Object[])this.slices.elements());
        long addressesArraySize = SizeOf.sizeOf((long[])this.valueAddresses.elements());
        return new DataSize((double)(this.slicesMemorySize + sliceArraySize + addressesArraySize), DataSize.Unit.BYTE);
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public TupleInfo getTupleInfo() {
        return this.tupleInfo;
    }

    public ObjectArrayList<Slice> getSlices() {
        return this.slices;
    }

    public LongArrayList getValueAddresses() {
        return this.valueAddresses;
    }

    public void swap(int a, int b) {
        long[] elements = this.valueAddresses.elements();
        long temp = elements[a];
        elements[a] = elements[b];
        elements[b] = temp;
    }

    public LongListIterator iterator() {
        return this.valueAddresses.iterator();
    }

    public void indexBlock(UncompressedBlock block) {
        this.positionCount += block.getPositionCount();
        int blockIndex = this.slices.size();
        this.slices.add(blockIndex, (Object)block.getSlice());
        this.slicesMemorySize += (long)block.getSlice().length();
        BlockCursor cursor = block.cursor();
        for (int position = 0; position < block.getPositionCount(); ++position) {
            Preconditions.checkState((boolean)cursor.advanceNextPosition());
            int offset = cursor.getRawOffset();
            long sliceAddress = SyntheticAddress.encodeSyntheticAddress(blockIndex, offset);
            Preconditions.checkState(((int)(sliceAddress >> 32) == blockIndex ? 1 : 0) != 0);
            Preconditions.checkState(((int)sliceAddress == offset ? 1 : 0) != 0);
            this.valueAddresses.add(sliceAddress);
        }
    }

    public void appendTo(int position, BlockBuilder output) {
        long sliceAddress = this.valueAddresses.getLong(position);
        Slice slice = this.getSliceForSyntheticAddress(sliceAddress);
        int offset = SyntheticAddress.decodeSliceOffset(sliceAddress);
        output.appendTuple(slice, offset);
    }

    public Slice getSliceForSyntheticAddress(long sliceAddress) {
        return (Slice)this.slices.get(SyntheticAddress.decodeSliceIndex(sliceAddress));
    }
}

