/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.ChannelIndex;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.tuple.TupleInfo;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.longs.LongHash;
import java.util.Arrays;

public class ChannelHash {
    private static final int LOOKUP_SLICE_INDEX = -1;
    private final SliceHashStrategy hashStrategy;
    private final AddressToPositionMap addressToPositionMap;
    private final IntArrayList positionLinks;

    public ChannelHash(ChannelIndex channelIndex, OperatorContext operatorContext) {
        this.hashStrategy = new SliceHashStrategy(channelIndex.getTupleInfo(), (Slice[])channelIndex.getSlices().elements());
        this.addressToPositionMap = new AddressToPositionMap(channelIndex.getPositionCount(), (LongHash.Strategy)this.hashStrategy);
        this.addressToPositionMap.defaultReturnValue(-1);
        this.positionLinks = new IntArrayList(new int[channelIndex.getValueAddresses().size()]);
        Arrays.fill(this.positionLinks.elements(), -1);
        for (int position = 0; position < channelIndex.getValueAddresses().size(); ++position) {
            operatorContext.setMemoryReservation(this.getEstimatedSize());
            long sliceAddress = channelIndex.getValueAddresses().elements()[position];
            int oldPosition = this.addressToPositionMap.put(sliceAddress, position);
            if (oldPosition < 0) continue;
            this.positionLinks.set(position, oldPosition);
        }
    }

    public ChannelHash(ChannelHash hash) {
        this.hashStrategy = new SliceHashStrategy(hash.hashStrategy.tupleInfo, hash.hashStrategy.slices);
        this.addressToPositionMap = new AddressToPositionMap((Long2IntMap)hash.addressToPositionMap, (LongHash.Strategy)this.hashStrategy);
        this.addressToPositionMap.defaultReturnValue(-1);
        this.positionLinks = hash.positionLinks;
    }

    private long getEstimatedSize() {
        long addressToPositionSize = this.addressToPositionMap.getEstimatedSize().toBytes();
        long positionLinksSize = SizeOf.sizeOf((int[])this.positionLinks.elements());
        return addressToPositionSize + positionLinksSize;
    }

    public void setLookupSlice(Slice lookupSlice) {
        this.hashStrategy.setLookupSlice(lookupSlice);
    }

    public int get(BlockCursor cursor) {
        int position = this.addressToPositionMap.get(SyntheticAddress.encodeSyntheticAddress(-1, cursor.getRawOffset()));
        return position;
    }

    public int getNextPosition(int currentPosition) {
        return this.positionLinks.getInt(currentPosition);
    }

    private static class AddressToPositionMap
    extends Long2IntOpenCustomHashMap {
        private AddressToPositionMap(int expected, LongHash.Strategy strategy) {
            super(expected, strategy);
        }

        private AddressToPositionMap(Long2IntMap m, LongHash.Strategy strategy) {
            super(m, strategy);
        }

        public DataSize getEstimatedSize() {
            return new DataSize((double)(SizeOf.sizeOf((long[])this.key) + SizeOf.sizeOf((int[])this.value) + SizeOf.sizeOf((boolean[])this.used)), DataSize.Unit.BYTE);
        }
    }

    public static class SliceHashStrategy
    implements LongHash.Strategy {
        private final TupleInfo tupleInfo;
        private final Slice[] slices;
        private Slice lookupSlice;

        public SliceHashStrategy(TupleInfo tupleInfo, Slice[] slices) {
            this.tupleInfo = tupleInfo;
            this.slices = slices;
        }

        public void setLookupSlice(Slice lookupSlice) {
            this.lookupSlice = lookupSlice;
        }

        public int hashCode(long sliceAddress) {
            Slice slice = this.getSliceForSyntheticAddress(sliceAddress);
            int offset = (int)sliceAddress;
            int length = this.tupleInfo.size(slice, offset);
            int hashCode = slice.hashCode(offset, length);
            return hashCode;
        }

        public boolean equals(long leftSliceAddress, long rightSliceAddress) {
            Slice leftSlice = this.getSliceForSyntheticAddress(leftSliceAddress);
            int leftOffset = SyntheticAddress.decodeSliceOffset(leftSliceAddress);
            int leftLength = this.tupleInfo.size(leftSlice, leftOffset);
            Slice rightSlice = this.getSliceForSyntheticAddress(rightSliceAddress);
            int rightOffset = SyntheticAddress.decodeSliceOffset(rightSliceAddress);
            int rightLength = this.tupleInfo.size(rightSlice, rightOffset);
            return leftSlice.equals(leftOffset, leftLength, rightSlice, rightOffset, rightLength);
        }

        private Slice getSliceForSyntheticAddress(long sliceAddress) {
            int sliceIndex = SyntheticAddress.decodeSliceIndex(sliceAddress);
            Slice slice = sliceIndex == -1 ? this.lookupSlice : this.slices[sliceIndex];
            return slice;
        }
    }
}

