/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public final class TableAlias {
    private final String sourceConnectorId;
    private final String sourceSchemaName;
    private final String sourceTableName;
    private final String destinationConnectorId;
    private final String destinationSchemaName;
    private final String destinationTableName;

    @JsonCreator
    public TableAlias(@JsonProperty(value="sourceConnectorId") String sourceConnectorId, @JsonProperty(value="sourceSchemaName") String sourceSchemaName, @JsonProperty(value="sourceTableName") String sourceTableName, @JsonProperty(value="destinationConnectorId") String destinationConnectorId, @JsonProperty(value="destinationSchemaName") String destinationSchemaName, @JsonProperty(value="destinationTableName") String destinationTableName) {
        this.sourceConnectorId = (String)Preconditions.checkNotNull((Object)sourceConnectorId, (Object)"sourceConnectorId is null");
        this.sourceSchemaName = (String)Preconditions.checkNotNull((Object)sourceSchemaName, (Object)"sourceSchemaName is null");
        this.sourceTableName = (String)Preconditions.checkNotNull((Object)sourceTableName, (Object)"sourceTableName is null");
        this.destinationConnectorId = (String)Preconditions.checkNotNull((Object)destinationConnectorId, (Object)"destinationConnectorId is null");
        this.destinationSchemaName = (String)Preconditions.checkNotNull((Object)destinationSchemaName, (Object)"destinationSchemaName is null");
        this.destinationTableName = (String)Preconditions.checkNotNull((Object)destinationTableName, (Object)"destinationTableName is null");
    }

    @JsonProperty
    public String getSourceConnectorId() {
        return this.sourceConnectorId;
    }

    @JsonProperty
    public String getSourceSchemaName() {
        return this.sourceSchemaName;
    }

    @JsonProperty
    public String getSourceTableName() {
        return this.sourceTableName;
    }

    @JsonProperty
    public String getDestinationConnectorId() {
        return this.destinationConnectorId;
    }

    @JsonProperty
    public String getDestinationSchemaName() {
        return this.destinationSchemaName;
    }

    @JsonProperty
    public String getDestinationTableName() {
        return this.destinationTableName;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("sourceConnectorId", (Object)this.sourceConnectorId).add("sourceSchemaName", (Object)this.sourceSchemaName).add("sourceTableName", (Object)this.sourceTableName).add("destinationConnectorId", (Object)this.destinationConnectorId).add("destinationSchemaName", (Object)this.destinationSchemaName).add("destinationTableName", (Object)this.destinationTableName).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sourceConnectorId, this.sourceSchemaName, this.sourceTableName, this.destinationConnectorId, this.destinationSchemaName, this.destinationTableName});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TableAlias other = (TableAlias)obj;
        return Objects.equal((Object)this.sourceConnectorId, (Object)other.sourceConnectorId) && Objects.equal((Object)this.sourceSchemaName, (Object)other.sourceSchemaName) && Objects.equal((Object)this.sourceTableName, (Object)other.sourceTableName) && Objects.equal((Object)this.destinationConnectorId, (Object)other.destinationConnectorId) && Objects.equal((Object)this.destinationSchemaName, (Object)other.destinationSchemaName) && Objects.equal((Object)this.destinationTableName, (Object)other.destinationTableName);
    }

    public static class TableAliasMapper
    implements ResultSetMapper<TableAlias> {
        public TableAlias map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            String sourceConnectorId = r.getString("source_connector_id");
            String sourceSchemaName = r.getString("source_schema_name");
            String sourceTableName = r.getString("source_table_name");
            String destinationConnectorId = r.getString("destination_connector_id");
            String destinationSchemaName = r.getString("destination_schema_name");
            String destinationTableName = r.getString("destination_table_name");
            return new TableAlias(sourceConnectorId, sourceSchemaName, sourceTableName, destinationConnectorId, destinationSchemaName, destinationTableName);
        }
    }
}

