/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import java.util.List;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;

public interface StorageManagerDao {
    @SqlUpdate(value="CREATE TABLE IF NOT EXISTS columns (\n  shard_id BIGINT NOT NULL,\n  column_id BIGINT NOT NULL,\n  filename VARCHAR(255) NOT NULL,\n  PRIMARY KEY (shard_id, column_id)\n)")
    public void createTableColumns();

    @SqlUpdate(value="INSERT INTO columns (shard_id, column_id, filename)\nVALUES (:shardId, :columnId, :filename)")
    public void insertColumn(@Bind(value="shardId") long var1, @Bind(value="columnId") long var3, @Bind(value="filename") String var5);

    @SqlQuery(value="SELECT filename\nFROM columns\nWHERE shard_id = :shardId\n  AND column_id = :columnId\n")
    public String getColumnFilename(@Bind(value="shardId") long var1, @Bind(value="columnId") long var3);

    @SqlQuery(value="SELECT filename\nFROM columns\nWHERE shard_id = :shardId\n")
    public List<String> getShardFiles(@Bind(value="shardId") long var1);

    @SqlQuery(value="SELECT COUNT(*) > 0\nFROM columns\nWHERE shard_id = :shardId")
    public boolean shardExists(@Bind(value="shardId") long var1);

    @SqlUpdate(value="DELETE FROM columns\nWHERE shard_id = :shardId")
    public void dropShard(@Bind(value="shardId") long var1);
}

