/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class ShardNode {
    private final long shardId;
    private final String nodeIdentifier;
    private final long tableId;
    private final long partitionId;

    public ShardNode(long shardId, String nodeIdentifier, long tableId, long partitionId) {
        this.shardId = shardId;
        this.nodeIdentifier = (String)Preconditions.checkNotNull((Object)nodeIdentifier, (Object)"nodeIdentifier is null");
        this.tableId = tableId;
        this.partitionId = partitionId;
    }

    public long getShardId() {
        return this.shardId;
    }

    public String getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public long getTableId() {
        return this.tableId;
    }

    public long getPartitionId() {
        return this.partitionId;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("shardId", this.shardId).add("nodeIdentifier", (Object)this.nodeIdentifier).add("tableId", this.tableId).add("partitionId", this.partitionId).toString();
    }

    public static class Mapper
    implements ResultSetMapper<ShardNode> {
        public ShardNode map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return new ShardNode(r.getLong("shard_id"), r.getString("node_identifier"), r.getLong("table_id"), r.getLong("partition_id"));
        }
    }
}

