/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.ShardNode;
import com.facebook.presto.metadata.TablePartition;
import com.facebook.presto.split.NativePartitionKey;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.skife.jdbi.v2.exceptions.UnableToObtainConnectionException;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.GetGeneratedKeys;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.Mapper;

public interface ShardManagerDao {
    @SqlUpdate(value="CREATE TABLE IF NOT EXISTS nodes (\n  node_id BIGINT PRIMARY KEY AUTO_INCREMENT,\n  node_identifier VARCHAR(255) NOT NULL,\n  UNIQUE (node_identifier)\n)")
    public void createTableNodes();

    @SqlUpdate(value="CREATE TABLE IF NOT EXISTS shards (\n  shard_id BIGINT PRIMARY KEY AUTO_INCREMENT,\n  table_id BIGINT NOT NULL,\n  committed BOOLEAN NOT NULL\n)")
    public void createTableShards();

    @SqlUpdate(value="CREATE TABLE IF NOT EXISTS shard_nodes (\n  shard_id BIGINT NOT NULL,\n  node_id BIGINT NOT NULL,\n  PRIMARY KEY (shard_id, node_id),\n  FOREIGN KEY (shard_id) REFERENCES shards (shard_id),\n  FOREIGN KEY (node_id) REFERENCES nodes (node_id)\n)")
    public void createTableShardNodes();

    @SqlUpdate(value="CREATE TABLE IF NOT EXISTS table_partitions (\n  partition_id BIGINT PRIMARY KEY AUTO_INCREMENT,\n  partition_name VARCHAR(255) NOT NULL,\n  table_id BIGINT NOT NULL,\n  UNIQUE (table_id, partition_name)\n)")
    public void createTablePartitions();

    @SqlUpdate(value="CREATE TABLE IF NOT EXISTS partition_keys (\n  partition_key_id BIGINT PRIMARY KEY AUTO_INCREMENT,\n  table_id BIGINT NOT NULL,\n  partition_name VARCHAR(255) NOT NULL,\n  key_name VARCHAR(255) NOT NULL,\n  key_type VARCHAR(255) NOT NULL,\n  key_value VARCHAR(255) NOT NULL,\n  UNIQUE (table_id, partition_name, key_name, key_type, key_value)\n)")
    public void createPartitionKeys();

    @SqlUpdate(value="CREATE TABLE IF NOT EXISTS partition_shards (\n  shard_id BIGINT NOT NULL,\n  table_id BIGINT NOT NULL,\n  partition_id BIGINT NOT NULL,\n  FOREIGN KEY (shard_id) REFERENCES shards (shard_id),\n  FOREIGN KEY (partition_id) REFERENCES table_partitions (partition_id)\n)")
    public void createPartitionShards();

    @SqlUpdate(value="INSERT INTO nodes (node_identifier) VALUES (:nodeIdentifier)")
    public void insertNode(@Bind(value="nodeIdentifier") String var1);

    @SqlUpdate(value="INSERT INTO shards (table_id, committed)\nVALUES (:tableId, :committed)\n")
    @GetGeneratedKeys
    public long insertShard(@Bind(value="tableId") long var1, @Bind(value="committed") boolean var3);

    @SqlUpdate(value="INSERT INTO shard_nodes (shard_id, node_id)\nVALUES (:shardId, :nodeId)\n")
    public void insertShardNode(@Bind(value="shardId") long var1, @Bind(value="nodeId") long var3);

    @SqlUpdate(value="INSERT INTO partition_keys (table_id, partition_name, key_name, key_type, key_value)\nVALUES (:tableId, :partitionName, :keyName, :keyType, :keyValue)")
    @GetGeneratedKeys
    public long insertPartitionKey(@Bind(value="tableId") long var1, @Bind(value="partitionName") String var3, @Bind(value="keyName") String var4, @Bind(value="keyType") String var5, @Bind(value="keyValue") String var6);

    @SqlUpdate(value="INSERT INTO table_partitions (partition_name, table_id)\nVALUES (:partitionName, :tableId)\n")
    @GetGeneratedKeys
    public long insertPartition(@Bind(value="tableId") long var1, @Bind(value="partitionName") String var3);

    @SqlUpdate(value="INSERT INTO partition_shards (shard_id, table_id, partition_id)\nVALUES (:shardId, :tableId, :partitionId)\n")
    public void insertPartitionShard(@Bind(value="shardId") long var1, @Bind(value="tableId") long var3, @Bind(value="partitionId") long var5);

    @SqlUpdate(value="UPDATE shards SET committed = TRUE WHERE shard_id = :shardId")
    public void commitShard(@Bind(value="shardId") long var1);

    @SqlQuery(value="SELECT node_id FROM nodes WHERE node_identifier = :nodeIdentifier")
    public Long getNodeId(@Bind(value="nodeIdentifier") String var1);

    @SqlQuery(value="SELECT *\n FROM partition_keys\n WHERE table_id = :tableId")
    @Mapper(value=NativePartitionKey.Mapper.class)
    public Set<NativePartitionKey> getPartitionKeys(@Bind(value="tableId") long var1);

    @SqlQuery(value="SELECT *\n FROM table_partitions\n WHERE table_id = :tableId\n")
    @Mapper(value=TablePartition.Mapper.class)
    public Set<TablePartition> getPartitions(@Bind(value="tableId") long var1);

    @SqlQuery(value="SELECT s.shard_id, n.node_identifier, ps.table_id, ps.partition_id\nFROM shard_nodes sn\nJOIN shards s ON (sn.shard_id = s.shard_id)\nJOIN nodes n ON (sn.node_id = n.node_id)\nJOIN partition_shards ps ON (ps.table_id = s.table_id AND ps.shard_id = s.shard_id)\nWHERE s.committed IS TRUE\n  AND ps.partition_id = :partitionId")
    @Mapper(value=ShardNode.Mapper.class)
    public List<ShardNode> getCommittedShardNodesByPartitionId(@Bind(value="partitionId") long var1);

    @SqlQuery(value="SELECT s.shard_id, n.node_identifier, ps.table_id, ps.partition_id\nFROM shard_nodes sn\nJOIN shards s ON (sn.shard_id = s.shard_id)\nJOIN nodes n ON (sn.node_id = n.node_id)\nJOIN partition_shards ps ON (ps.table_id = s.table_id AND ps.shard_id = s.shard_id)\nWHERE s.committed IS TRUE\n  AND ps.table_id = :tableId\n")
    @Mapper(value=ShardNode.Mapper.class)
    public List<ShardNode> getCommittedShardNodesByTableId(@Bind(value="tableId") long var1);

    @SqlQuery(value="SELECT sn.shard_id, n.node_identifier, tp.table_id, tp.partition_id\nFROM table_partitions tp\nJOIN partition_shards ps ON (tp.partition_id = ps.partition_id)\nJOIN shard_nodes sn ON (ps.shard_id = sn.shard_id)\nJOIN nodes n ON (sn.node_id = n.node_id)\nWHERE tp.table_id = :tableId\n  AND tp.partition_name = :partitionName")
    @Mapper(value=ShardNode.Mapper.class)
    public List<ShardNode> getAllShardNodes(@Bind(value="tableId") long var1, @Bind(value="partitionName") String var3);

    @SqlQuery(value="SELECT node_identifier FROM nodes")
    public List<String> getAllNodesInUse();

    @SqlQuery(value="SELECT ps.shard_id\nFROM table_partitions tp\nJOIN partition_shards ps ON (tp.partition_id = ps.partition_id)\nWHERE tp.table_id = :tableId\n  AND tp.partition_name = :partitionName\n")
    public List<Long> getAllShards(@Bind(value="tableId") long var1, @Bind(value="partitionName") String var3);

    @SqlUpdate(value="DELETE FROM shard_nodes\nWHERE shard_id = :shardId\n")
    public void deleteShardFromShardNodes(@Bind(value="shardId") long var1);

    @SqlUpdate(value="DELETE FROM partition_shards\nWHERE shard_id = :shardId\n")
    public void deleteShardFromPartitionShards(@Bind(value="shardId") long var1);

    @SqlUpdate(value="DELETE FROM shards\n  WHERE shard_id = :shardId\n")
    public void deleteShard(@Bind(value="shardId") long var1);

    @SqlUpdate(value="DELETE FROM shard_nodes\n  WHERE shard_id = :shardId\n  AND (:nodeIdentifier IS NULL OR node_id = (SELECT node_id FROM nodes WHERE node_identifier = :nodeIdentifier))")
    public void dropShardNode(@Bind(value="shardId") long var1, @Nullable @Bind(value="nodeIdentifier") String var3);

    @SqlUpdate(value="DELETE FROM table_partitions\nWHERE table_id = :tableId\n  AND partition_name = :partitionName\n")
    public void dropPartition(@Bind(value="tableId") long var1, @Bind(value="partitionName") String var3);

    @SqlUpdate(value="DELETE FROM partition_keys\nWHERE table_id = :tableId\n  AND partition_name = :partitionName\n")
    public void dropPartitionKeys(@Bind(value="tableId") long var1, @Bind(value="partitionName") String var3);

    @SqlQuery(value="SELECT s.shard_id FROM shards s\n LEFT JOIN shard_nodes sn ON (s.shard_id = sn.shard_id)\n LEFT JOIN nodes n ON (sn.node_id = n.node_id)\n  WHERE s.shard_id NOT IN (SELECT shard_id FROM partition_shards ps WHERE ps.table_id = s.table_id)\n  AND s.committed IS TRUE\n  AND n.node_identifier = :nodeIdentifier")
    public List<Long> getOrphanedShards(@Bind(value="nodeIdentifier") String var1);

    @SqlQuery(value="SELECT s.shard_id FROM shards s\n  WHERE s.shard_id NOT IN (SELECT shard_id FROM partition_shards ps WHERE ps.table_id = s.table_id)\n  AND s.shard_id NOT IN (SELECT DISTINCT shard_id FROM shard_nodes sn)\n  AND s.committed IS TRUE\n")
    public List<Long> getAllOrphanedShards();

    @SqlUpdate(value="DELETE FROM table_partitions\n  WHERE table_id NOT IN (SELECT table_id FROM tables)\n  AND partition_id NOT IN (SELECT partition_id FROM partition_shards)\n")
    public void dropAllOrphanedPartitions();

    public static class Utils {
        public static final Logger log = Logger.get(ShardManagerDao.class);

        public static void createShardTablesWithRetry(ShardManagerDao dao) throws InterruptedException {
            Duration delay = new Duration(10.0, TimeUnit.SECONDS);
            while (true) {
                try {
                    Utils.createShardTables(dao);
                    return;
                }
                catch (UnableToObtainConnectionException e) {
                    log.warn("Failed to connect to database. Will retry again in %s. Exception: %s", new Object[]{delay, e.getMessage()});
                    Thread.sleep(delay.toMillis());
                    continue;
                }
                break;
            }
        }

        private static void createShardTables(ShardManagerDao dao) {
            dao.createTableNodes();
            dao.createTableShards();
            dao.createTableShardNodes();
            dao.createTablePartitions();
            dao.createPartitionKeys();
            dao.createPartitionShards();
        }
    }
}

