/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.TableHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class NativeTableHandle
implements TableHandle {
    private final String schemaName;
    private final String tableName;
    private final long tableId;

    @JsonCreator
    public NativeTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="tableId") long tableId) {
        this.schemaName = MetadataUtil.checkSchemaName(schemaName);
        this.tableName = MetadataUtil.checkTableName(tableName);
        Preconditions.checkArgument((tableId > 0L ? 1 : 0) != 0, (Object)"tableId must be greater than zero");
        this.tableId = tableId;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public long getTableId() {
        return this.tableId;
    }

    public String toString() {
        return "native:" + this.schemaName + "." + this.tableName + ":" + this.tableId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.schemaName, this.tableName, this.tableId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NativeTableHandle other = (NativeTableHandle)obj;
        return Objects.equal((Object)this.schemaName, (Object)other.schemaName) && Objects.equal((Object)this.tableName, (Object)other.tableName) && Objects.equal((Object)this.tableId, (Object)other.tableId);
    }
}

