/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.MetadataDao;
import com.facebook.presto.metadata.MetadataDaoUtils;
import com.facebook.presto.metadata.NativeColumnHandle;
import com.facebook.presto.metadata.NativeTableHandle;
import com.facebook.presto.metadata.Table;
import com.facebook.presto.metadata.TableColumn;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TableMetadata;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.util.SqlUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.VoidTransactionCallback;

public class NativeMetadata
implements ConnectorMetadata {
    private final IDBI dbi;
    private final MetadataDao dao;
    private final String catalogName;

    public NativeMetadata(String catalogName, IDBI dbi) {
        this.catalogName = catalogName;
        this.dbi = (IDBI)Preconditions.checkNotNull((Object)dbi, (Object)"dbi is null");
        this.dao = (MetadataDao)dbi.onDemand(MetadataDao.class);
        MetadataDaoUtils.createMetadataTablesWithRetry(this.dao);
    }

    public boolean canHandle(TableHandle tableHandle) {
        return tableHandle instanceof NativeTableHandle;
    }

    public List<String> listSchemaNames() {
        return this.dao.listSchemaNames(this.catalogName);
    }

    public TableHandle getTableHandle(SchemaTableName tableName) {
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
        Table table = this.dao.getTableInformation(this.catalogName, tableName.getSchemaName(), tableName.getTableName());
        if (table == null) {
            return null;
        }
        return new NativeTableHandle(tableName.getSchemaName(), tableName.getTableName(), table.getTableId());
    }

    public TableMetadata getTableMetadata(TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof NativeTableHandle), (Object)"tableHandle is not an instance of NativeTableHandle");
        NativeTableHandle nativeTableHandle = (NativeTableHandle)tableHandle;
        SchemaTableName tableName = this.getTableName(tableHandle);
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (String)"Table %s does not exist", (Object[])new Object[]{tableName});
        List<ColumnMetadata> columns = this.dao.getTableColumnMetaData(nativeTableHandle.getTableId());
        Preconditions.checkArgument((!columns.isEmpty() ? 1 : 0) != 0, (String)"Table %s does not have any columns", (Object[])new Object[]{tableName});
        if (columns.isEmpty()) {
            return null;
        }
        return new TableMetadata(tableName, columns);
    }

    public List<SchemaTableName> listTables(@Nullable String schemaNameOrNull) {
        return this.dao.listTables(this.catalogName, schemaNameOrNull);
    }

    public Map<String, ColumnHandle> getColumnHandles(TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof NativeTableHandle), (Object)"tableHandle is not an instance of NativeTableHandle");
        NativeTableHandle nativeTableHandle = (NativeTableHandle)tableHandle;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TableColumn tableColumn : this.dao.listTableColumns(nativeTableHandle.getTableId())) {
            builder.put((Object)tableColumn.getColumnName(), (Object)new NativeColumnHandle(tableColumn.getColumnName(), tableColumn.getColumnId()));
        }
        return builder.build();
    }

    public ColumnHandle getColumnHandle(TableHandle tableHandle, String columnName) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof NativeTableHandle), (Object)"tableHandle is not an instance of NativeTableHandle");
        NativeTableHandle nativeTableHandle = (NativeTableHandle)tableHandle;
        Long columnId = this.dao.getColumnId(nativeTableHandle.getTableId(), columnName);
        if (columnId == null) {
            return null;
        }
        return new NativeColumnHandle(columnName, columnId);
    }

    public ColumnMetadata getColumnMetadata(TableHandle tableHandle, ColumnHandle columnHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkNotNull((Object)columnHandle, (Object)"columnHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof NativeTableHandle), (Object)"tableHandle is not an instance of NativeTableHandle");
        Preconditions.checkArgument((boolean)(columnHandle instanceof NativeColumnHandle), (Object)"columnHandle is not an instance of NativeColumnHandle");
        long columnId = ((NativeColumnHandle)columnHandle).getColumnId();
        ColumnMetadata columnMetadata = this.dao.getColumnMetadata(columnId);
        Preconditions.checkState((columnMetadata != null ? 1 : 0) != 0, (String)"no column with id %s exists", (Object[])new Object[]{columnId});
        return columnMetadata;
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(SchemaTablePrefix prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        ImmutableListMultimap.Builder columns = ImmutableListMultimap.builder();
        for (TableColumn tableColumn : this.dao.listTableColumns(this.catalogName, prefix.getSchemaName(), prefix.getTableName())) {
            ColumnMetadata columnMetadata = new ColumnMetadata(tableColumn.getColumnName(), tableColumn.getDataType().toColumnType(), tableColumn.getOrdinalPosition(), false);
            columns.put((Object)tableColumn.getTable().asSchemaTableName(), (Object)columnMetadata);
        }
        return (Map)columns.build().asMap();
    }

    private SchemaTableName getTableName(TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof NativeTableHandle), (Object)"tableHandle is not an instance of NativeTableHandle");
        long tableId = ((NativeTableHandle)tableHandle).getTableId();
        SchemaTableName tableName = this.dao.getTableName(tableId).asSchemaTableName();
        Preconditions.checkState((tableName != null ? 1 : 0) != 0, (String)"no table with id %s exists", (Object[])new Object[]{tableId});
        return tableName;
    }

    public TableHandle createTable(final TableMetadata tableMetadata) {
        Long tableId = (Long)this.dbi.inTransaction((TransactionCallback)new TransactionCallback<Long>(){

            public Long inTransaction(final Handle handle, TransactionStatus status) throws Exception {
                return SqlUtils.runIgnoringConstraintViolation(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        MetadataDao dao = (MetadataDao)handle.attach(MetadataDao.class);
                        long tableId = dao.insertTable(NativeMetadata.this.catalogName, tableMetadata.getTable().getSchemaName(), tableMetadata.getTable().getTableName());
                        int ordinalPosition = 0;
                        for (ColumnMetadata column : tableMetadata.getColumns()) {
                            dao.insertColumn(tableId, column.getName(), ordinalPosition, TupleInfo.Type.fromColumnType(column.getType()).getName());
                            ++ordinalPosition;
                        }
                        return tableId;
                    }
                }, null);
            }
        });
        Preconditions.checkState((tableId != null ? 1 : 0) != 0, (String)"table %s already exists", (Object[])new Object[]{tableMetadata.getTable()});
        return new NativeTableHandle(tableMetadata.getTable().getSchemaName(), tableMetadata.getTable().getTableName(), tableId);
    }

    public void dropTable(TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof NativeTableHandle), (Object)"tableHandle is not an instance of NativeTableHandle");
        final long tableId = ((NativeTableHandle)tableHandle).getTableId();
        this.dbi.inTransaction((TransactionCallback)new VoidTransactionCallback(){

            protected void execute(Handle handle, TransactionStatus status) throws Exception {
                MetadataDaoUtils.dropTable(NativeMetadata.this.dao, tableId);
            }
        });
    }
}

