/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.connector.informationSchema.InformationSchemaMetadata;
import com.facebook.presto.metadata.FunctionHandle;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TableMetadata;
import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Singleton;

@Singleton
public class MetadataManager
implements Metadata {
    private final CopyOnWriteArrayList<ConnectorMetadata> internalSchemas = new CopyOnWriteArrayList();
    private final ConcurrentMap<String, ConnectorMetadata> connectors = new ConcurrentHashMap<String, ConnectorMetadata>();
    private final ConcurrentMap<String, ConnectorMetadata> informationSchemas = new ConcurrentHashMap<String, ConnectorMetadata>();
    private final FunctionRegistry functions = new FunctionRegistry();

    public void addConnectorMetadata(String catalogName, ConnectorMetadata connectorMetadata) {
        Preconditions.checkState((this.connectors.putIfAbsent(catalogName, connectorMetadata) == null ? 1 : 0) != 0, (String)"Catalog '%s' is already registered", (Object[])new Object[]{catalogName});
        this.informationSchemas.put(catalogName, new InformationSchemaMetadata(catalogName));
    }

    public void addInternalSchemaMetadata(ConnectorMetadata connectorMetadata) {
        this.internalSchemas.add((ConnectorMetadata)Preconditions.checkNotNull((Object)connectorMetadata, (Object)"connectorMetadata is null"));
    }

    @Override
    public FunctionInfo getFunction(QualifiedName name, List<Type> parameterTypes) {
        return this.functions.get(name, parameterTypes);
    }

    @Override
    public FunctionInfo getFunction(FunctionHandle handle) {
        return this.functions.get(handle);
    }

    @Override
    public boolean isAggregationFunction(QualifiedName name) {
        return this.functions.isAggregationFunction(name);
    }

    @Override
    public List<FunctionInfo> listFunctions() {
        return this.functions.list();
    }

    @Override
    public List<String> listSchemaNames(String catalogName) {
        MetadataUtil.checkCatalogName(catalogName);
        ImmutableSet.Builder schemaNames = ImmutableSet.builder();
        for (ConnectorMetadata metadata : this.allConnectorsFor(catalogName)) {
            schemaNames.addAll((Iterable)metadata.listSchemaNames());
        }
        return ImmutableList.copyOf((Collection)schemaNames.build());
    }

    @Override
    public Optional<TableHandle> getTableHandle(QualifiedTableName table) {
        Preconditions.checkNotNull((Object)table, (Object)"table is null");
        SchemaTableName tableName = table.asSchemaTableName();
        for (ConnectorMetadata connectorMetadata : this.allConnectorsFor(table.getCatalogName())) {
            TableHandle tableHandle = connectorMetadata.getTableHandle(tableName);
            if (tableHandle == null) continue;
            return Optional.of((Object)tableHandle);
        }
        return Optional.absent();
    }

    @Override
    public TableMetadata getTableMetadata(TableHandle tableHandle) {
        return this.lookupConnectorFor(tableHandle).getTableMetadata(tableHandle);
    }

    @Override
    public Map<String, ColumnHandle> getColumnHandles(TableHandle tableHandle) {
        return this.lookupConnectorFor(tableHandle).getColumnHandles(tableHandle);
    }

    @Override
    public ColumnMetadata getColumnMetadata(TableHandle tableHandle, ColumnHandle columnHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkNotNull((Object)columnHandle, (Object)"columnHandle is null");
        return this.lookupConnectorFor(tableHandle).getColumnMetadata(tableHandle, columnHandle);
    }

    @Override
    public List<QualifiedTableName> listTables(QualifiedTablePrefix prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        String schemaNameOrNull = (String)prefix.getSchemaName().orNull();
        LinkedHashSet<QualifiedTableName> tables = new LinkedHashSet<QualifiedTableName>();
        for (ConnectorMetadata internalSchemaMetadata : this.allConnectorsFor(prefix.getCatalogName())) {
            for (QualifiedTableName tableName : Iterables.transform((Iterable)internalSchemaMetadata.listTables(schemaNameOrNull), QualifiedTableName.convertFromSchemaTableName(prefix.getCatalogName()))) {
                tables.add(tableName);
            }
        }
        return ImmutableList.copyOf(tables);
    }

    @Override
    public Optional<ColumnHandle> getColumnHandle(TableHandle tableHandle, String columnName) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        MetadataUtil.checkColumnName(columnName);
        return Optional.fromNullable((Object)this.lookupConnectorFor(tableHandle).getColumnHandle(tableHandle, columnName));
    }

    @Override
    public Map<QualifiedTableName, List<ColumnMetadata>> listTableColumns(QualifiedTablePrefix prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        LinkedHashMap tableColumns = new LinkedHashMap();
        for (ConnectorMetadata connectorMetadata : this.allConnectorsFor(prefix.getCatalogName())) {
            for (Map.Entry entry : connectorMetadata.listTableColumns(prefix.asSchemaTablePrefix()).entrySet()) {
                QualifiedTableName tableName = new QualifiedTableName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                if (tableColumns.containsKey(tableName)) continue;
                tableColumns.put(tableName, entry.getValue());
            }
        }
        return ImmutableMap.copyOf(tableColumns);
    }

    @Override
    public TableHandle createTable(String catalogName, TableMetadata tableMetadata) {
        ConnectorMetadata connectorMetadata = (ConnectorMetadata)this.connectors.get(catalogName);
        Preconditions.checkArgument((connectorMetadata != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{catalogName});
        return connectorMetadata.createTable(tableMetadata);
    }

    @Override
    public void dropTable(TableHandle tableHandle) {
        this.lookupConnectorFor(tableHandle).dropTable(tableHandle);
    }

    @Override
    public Optional<String> getConnectorId(TableHandle tableHandle) {
        for (Map.Entry entry : this.connectors.entrySet()) {
            if (!((ConnectorMetadata)entry.getValue()).canHandle(tableHandle)) continue;
            return Optional.of(entry.getKey());
        }
        return Optional.absent();
    }

    @Override
    public Optional<TableHandle> getTableHandle(String connectorId, SchemaTableName tableName) {
        ConnectorMetadata metadata = (ConnectorMetadata)this.connectors.get(connectorId);
        if (metadata == null) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)metadata.getTableHandle(tableName));
    }

    private List<ConnectorMetadata> allConnectorsFor(String catalogName) {
        ConnectorMetadata informationSchema;
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.internalSchemas);
        ConnectorMetadata connector = (ConnectorMetadata)this.connectors.get(catalogName);
        if (connector != null) {
            builder.add((Object)connector);
        }
        if ((informationSchema = (ConnectorMetadata)this.informationSchemas.get(catalogName)) != null) {
            builder.add((Object)informationSchema);
        }
        return builder.build();
    }

    private ConnectorMetadata lookupConnectorFor(TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        for (ConnectorMetadata metadata : this.informationSchemas.values()) {
            if (!metadata.canHandle(tableHandle)) continue;
            return metadata;
        }
        for (ConnectorMetadata internalSchemaMetadata : this.internalSchemas) {
            if (!internalSchemaMetadata.canHandle(tableHandle)) continue;
            return internalSchemaMetadata;
        }
        for (ConnectorMetadata metadata : this.connectors.values()) {
            if (!metadata.canHandle(tableHandle)) continue;
            return metadata;
        }
        throw new IllegalArgumentException("Table %s does not exist: " + tableHandle);
    }
}

