/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.MetadataDao;
import com.google.common.base.Throwables;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import org.skife.jdbi.v2.exceptions.UnableToObtainConnectionException;

public final class MetadataDaoUtils {
    public static final Logger log = Logger.get(MetadataDaoUtils.class);

    private MetadataDaoUtils() {
    }

    public static void dropTable(MetadataDao dao, long tableId) {
        dao.dropColumns(tableId);
        dao.dropTable(tableId);
    }

    public static void createMetadataTablesWithRetry(MetadataDao dao) {
        Duration delay = new Duration(10.0, TimeUnit.SECONDS);
        while (true) {
            try {
                MetadataDaoUtils.createMetadataTables(dao);
                return;
            }
            catch (UnableToObtainConnectionException e) {
                log.warn("Failed to connect to database. Will retry again in %s. Exception: %s", new Object[]{delay, e.getMessage()});
                MetadataDaoUtils.sleep(delay);
                continue;
            }
            break;
        }
    }

    public static void createMetadataTables(MetadataDao dao) {
        dao.createTablesTable();
        dao.createColumnsTable();
    }

    private static void sleep(Duration duration) {
        try {
            Thread.sleep(duration.toMillis());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate((Throwable)e);
        }
    }
}

