/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.ColumnMetadataMapper;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.QualifiedTableNameMapper;
import com.facebook.presto.metadata.SchemaTableNameMapper;
import com.facebook.presto.metadata.Table;
import com.facebook.presto.metadata.TableColumn;
import com.facebook.presto.metadata.TableColumnMapper;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.SchemaTableName;
import java.util.List;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.BindBean;
import org.skife.jdbi.v2.sqlobject.GetGeneratedKeys;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.Mapper;

public interface MetadataDao {
    @SqlUpdate(value="CREATE TABLE IF NOT EXISTS tables (\n  table_id BIGINT PRIMARY KEY AUTO_INCREMENT,\n  catalog_name VARCHAR(255) NOT NULL,\n  schema_name VARCHAR(255) NOT NULL,\n  table_name VARCHAR(255) NOT NULL,\n  UNIQUE (catalog_name, schema_name, table_name)\n)")
    public void createTablesTable();

    @SqlUpdate(value="CREATE TABLE IF NOT EXISTS columns (\n  column_id BIGINT PRIMARY KEY AUTO_INCREMENT,\n  table_id BIGINT NOT NULL,\n  column_name VARCHAR(255) NOT NULL,\n  ordinal_position INT NOT NULL,\n  data_type VARCHAR(255) NOT NULL,\n  UNIQUE (table_id, column_name),\n  UNIQUE (table_id, ordinal_position),\n  FOREIGN KEY (table_id) REFERENCES tables (table_id)\n)")
    public void createColumnsTable();

    @SqlQuery(value="SELECT table_id FROM tables\nWHERE catalog_name = :catalogName\n  AND schema_name = :schemaName\n  AND table_name = :tableName")
    @Mapper(value=Table.TableMapper.class)
    public Table getTableInformation(@Bind(value="catalogName") String var1, @Bind(value="schemaName") String var2, @Bind(value="tableName") String var3);

    @SqlQuery(value="SELECT catalog_name, schema_name, table_name\nFROM tables\nWHERE table_id = :tableId")
    @Mapper(value=QualifiedTableNameMapper.class)
    public QualifiedTableName getTableName(@Bind(value="tableId") long var1);

    @SqlQuery(value="SELECT c.column_name, c.data_type, c.ordinal_position\nFROM tables t\nJOIN columns c ON (t.table_id = c.table_id)\nWHERE (c.column_id = :columnId)")
    @Mapper(value=ColumnMetadataMapper.class)
    public ColumnMetadata getColumnMetadata(@Bind(value="columnId") long var1);

    @SqlQuery(value="SELECT column_name, data_type, ordinal_position\nFROM columns\nWHERE table_id = :tableId\nORDER BY ordinal_position")
    @Mapper(value=ColumnMetadataMapper.class)
    public List<ColumnMetadata> getTableColumnMetaData(@Bind(value="tableId") long var1);

    @SqlQuery(value="SELECT column_id\nFROM columns\nWHERE table_id = :tableId AND column_name = :columnName")
    public Long getColumnId(@Bind(value="tableId") long var1, @Bind(value="columnName") String var3);

    @SqlQuery(value="SELECT catalog_name, schema_name, table_name\nFROM tables\nWHERE (catalog_name = :catalogName OR :catalogName IS NULL)\n  AND (schema_name = :schemaName OR :schemaName IS NULL)")
    @Mapper(value=SchemaTableNameMapper.class)
    public List<SchemaTableName> listTables(@Bind(value="catalogName") String var1, @Bind(value="schemaName") String var2);

    @SqlQuery(value="SELECT DISTINCT schema_name FROM tables\nWHERE catalog_name = :catalogName\n")
    public List<String> listSchemaNames(@Bind(value="catalogName") String var1);

    @SqlQuery(value="SELECT t.catalog_name, t.schema_name, t.table_name,\n  c.column_id, c.column_name, c.ordinal_position, c.data_type\nFROM tables t\nJOIN columns c ON (t.table_id = c.table_id)\nWHERE (catalog_name = :catalogName OR :catalogName IS NULL)\n  AND (schema_name = :schemaName OR :schemaName IS NULL)\n  AND (table_name = :tableName OR :tableName IS NULL)\nORDER BY schema_name, table_name, ordinal_position")
    @Mapper(value=TableColumnMapper.class)
    public List<TableColumn> listTableColumns(@Bind(value="catalogName") String var1, @Bind(value="schemaName") String var2, @Bind(value="tableName") String var3);

    @SqlQuery(value="SELECT t.catalog_name, t.schema_name, t.table_name,\n  c.column_id, c.column_name, c.ordinal_position, c.data_type\nFROM tables t\nJOIN columns c ON (t.table_id = c.table_id)\nWHERE t.table_id = :tableId")
    @Mapper(value=TableColumnMapper.class)
    public List<TableColumn> listTableColumns(@Bind(value="tableId") long var1);

    @SqlQuery(value="SELECT COUNT(*) > 0 FROM tables\nWHERE catalog_name = :catalogName\n  AND schema_name = :schemaName\n  AND table_name = :tableName")
    public boolean tableExists(@BindBean QualifiedTableName var1);

    @SqlUpdate(value="INSERT INTO tables (catalog_name, schema_name, table_name)\nVALUES (:catalogName, :schemaName, :tableName)")
    @GetGeneratedKeys
    public long insertTable(@Bind(value="catalogName") String var1, @Bind(value="schemaName") String var2, @Bind(value="tableName") String var3);

    @SqlUpdate(value="INSERT INTO columns (table_id, column_name, ordinal_position, data_type)\nVALUES (:tableId, :columnName, :ordinalPosition, :dataType)")
    public void insertColumn(@Bind(value="tableId") long var1, @Bind(value="columnName") String var3, @Bind(value="ordinalPosition") int var4, @Bind(value="dataType") String var5);

    @SqlUpdate(value="DELETE FROM tables WHERE table_id = :tableId")
    public int dropTable(@Bind(value="tableId") long var1);

    @SqlUpdate(value="DELETE FROM columns WHERE table_id = :tableId")
    public int dropColumns(@Bind(value="tableId") long var1);
}

