/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum DataSourceType {
    TPCH("tpch"),
    NATIVE("native"),
    INTERNAL("internal"),
    IMPORT("import"),
    REMOTE("remote"),
    COLLOCATED("collocated");

    private static final Map<String, DataSourceType> NAME_MAP;
    private final String name;

    private DataSourceType(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    @JsonCreator
    public static DataSourceType fromName(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        DataSourceType dataSourceType = NAME_MAP.get(name);
        Preconditions.checkArgument((dataSourceType != null ? 1 : 0) != 0, (String)"Invalid dataSourceType name: %s", (Object[])new Object[]{name});
        return dataSourceType;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DataSourceType dataSourceType : DataSourceType.values()) {
            builder.put((Object)dataSourceType.getName(), (Object)dataSourceType);
        }
        NAME_MAP = builder.build();
    }
}

