/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.importer;

import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;

public final class PeriodicImportJob {
    private final QualifiedTableName srcTable;
    private final QualifiedTableName dstTable;
    private final long intervalSeconds;

    public static PeriodicImportJob createJob(QualifiedTableName srcTable, QualifiedTableName dstTable, long intervalSeconds) {
        return new PeriodicImportJob(srcTable, dstTable, intervalSeconds);
    }

    @JsonCreator
    public PeriodicImportJob(@JsonProperty(value="srcCatalogName") String srcCatalogName, @JsonProperty(value="srcSchemaName") String srcSchemaName, @JsonProperty(value="srcTableName") String srcTableName, @JsonProperty(value="dstCatalogName") String dstCatalogName, @JsonProperty(value="dstSchemaName") String dstSchemaName, @JsonProperty(value="dstTableName") String dstTableName, @JsonProperty(value="intervalSeconds") long intervalSeconds) {
        this(new QualifiedTableName(srcCatalogName, srcSchemaName, srcTableName), new QualifiedTableName(dstCatalogName, dstSchemaName, dstTableName), intervalSeconds);
    }

    PeriodicImportJob(QualifiedTableName srcTable, QualifiedTableName dstTable, long intervalSeconds) {
        this.srcTable = MetadataUtil.checkTable(srcTable);
        this.dstTable = MetadataUtil.checkTable(dstTable);
        this.intervalSeconds = intervalSeconds;
    }

    @JsonProperty
    public String getSrcCatalogName() {
        return this.srcTable.getCatalogName();
    }

    @JsonProperty
    public String getSrcSchemaName() {
        return this.srcTable.getSchemaName();
    }

    @JsonProperty
    public String getSrcTableName() {
        return this.srcTable.getTableName();
    }

    @JsonProperty
    public String getDstCatalogName() {
        return this.dstTable.getCatalogName();
    }

    @JsonProperty
    public String getDstSchemaName() {
        return this.dstTable.getSchemaName();
    }

    @JsonProperty
    public String getDstTableName() {
        return this.dstTable.getTableName();
    }

    @JsonProperty
    public long getIntervalSeconds() {
        return this.intervalSeconds;
    }

    public QualifiedTableName getSrcTable() {
        return this.srcTable;
    }

    public QualifiedTableName getDstTable() {
        return this.dstTable;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("srcTable", (Object)this.srcTable).add("dstTable", (Object)this.dstTable).add("intervalSeconds", this.intervalSeconds).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.srcTable, this.dstTable, this.intervalSeconds});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PeriodicImportJob other = (PeriodicImportJob)obj;
        return Objects.equal((Object)this.srcTable, (Object)other.srcTable) && Objects.equal((Object)this.dstTable, (Object)other.dstTable) && this.intervalSeconds == other.intervalSeconds;
    }
}

