/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.importer;

import com.facebook.presto.importer.JobStateFactory;
import com.facebook.presto.importer.PeriodicImportConfig;
import com.facebook.presto.importer.PeriodicImportManager;
import com.facebook.presto.importer.PersistentPeriodicImportJob;
import com.facebook.presto.util.Threads;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;
import org.weakref.jmx.Managed;

@Singleton
public class PeriodicImportController {
    private static final Logger log = Logger.get(PeriodicImportController.class);
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean stopped = new AtomicBoolean();
    private final Duration checkInterval;
    private final AtomicBoolean enabled = new AtomicBoolean();
    private final PeriodicImportManager periodicImportManager;
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed("import-scheduler-%s"));
    private final JobStateFactory jobStateFactory;
    private final AtomicReference<ScheduledFuture<?>> scheduledFuture = new AtomicReference();
    private final Map<Long, JobStateFactory.JobState> runningJobs = new HashMap<Long, JobStateFactory.JobState>();

    @Inject
    PeriodicImportController(PeriodicImportConfig config, PeriodicImportManager periodicImportManager, JobStateFactory jobStateFactory) {
        Preconditions.checkNotNull((Object)config, (Object)"Config was null!");
        this.periodicImportManager = (PeriodicImportManager)Preconditions.checkNotNull((Object)periodicImportManager, (Object)"Import manager was null!");
        this.checkInterval = config.getCheckInterval();
        this.enabled.set(config.isEnabled());
        this.jobStateFactory = jobStateFactory;
    }

    @PostConstruct
    public void start() {
        if (this.enabled.get()) {
            if (this.started.compareAndSet(false, true)) {
                this.scheduledFuture.set(this.executorService.scheduleAtFixedRate(new ImportControllerRunnable(), this.checkInterval.toMillis(), this.checkInterval.toMillis(), TimeUnit.MILLISECONDS));
            } else {
                log.info("Ignored double start.");
            }
        } else {
            log.info("Periodic Importer not enabled.");
        }
    }

    @PreDestroy
    public void stop() {
        if (!this.stopped.compareAndSet(false, true)) {
            this.executorService.shutdownNow();
        }
    }

    @Managed
    public void setEnabled(boolean enabled) {
        this.enabled.set(enabled);
    }

    @Managed
    public boolean isEnabled() {
        return this.enabled.get();
    }

    private class ImportControllerRunnable
    implements Runnable {
        private ImportControllerRunnable() {
        }

        @Override
        public void run() {
            try {
                List<PersistentPeriodicImportJob> jobs = PeriodicImportController.this.periodicImportManager.getJobs();
                ImmutableMap configuredJobs = Maps.uniqueIndex(jobs, PersistentPeriodicImportJob.jobIdGetter());
                Set currentJobs = PeriodicImportController.this.runningJobs.keySet();
                ImmutableSet jobsToAdd = ImmutableSet.copyOf((Collection)Sets.difference(configuredJobs.keySet(), currentJobs));
                ImmutableSet jobsToRemove = ImmutableSet.copyOf((Collection)Sets.difference(currentJobs, configuredJobs.keySet()));
                for (Long jobId : jobsToAdd) {
                    PeriodicImportController.this.runningJobs.put(jobId, PeriodicImportController.this.jobStateFactory.forImportJob((PersistentPeriodicImportJob)configuredJobs.get(jobId)));
                }
                for (Long oldJob : jobsToRemove) {
                    JobStateFactory.JobState removedJob = (JobStateFactory.JobState)PeriodicImportController.this.runningJobs.remove(oldJob);
                    removedJob.cancel(true);
                }
                log.debug("Current set of jobs is %s", new Object[]{PeriodicImportController.this.runningJobs.keySet()});
                for (JobStateFactory.JobState importJob : PeriodicImportController.this.runningJobs.values()) {
                    importJob.schedule();
                }
            }
            catch (Throwable e) {
                log.error(e, "Caught problem when scanning import jobs!");
            }
        }
    }
}

